/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.precondition;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.distribution.journal.HandlerAdapter;
import org.apache.sling.distribution.journal.MessageInfo;
import org.apache.sling.distribution.journal.MessagingProvider;
import org.apache.sling.distribution.journal.Reset;
import org.apache.sling.distribution.journal.messages.PackageStatusMessage;
import org.apache.sling.distribution.journal.shared.Topics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageStatusWatcher
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Closeable poller;
    private final Map<String, NavigableMap<Long, PackageStatusMessage.Status>> pkgStatusPerSubAgent = new ConcurrentHashMap<String, NavigableMap<Long, PackageStatusMessage.Status>>();

    public PackageStatusWatcher(MessagingProvider messagingProvider, Topics topics) {
        String topicName = topics.getStatusTopic();
        this.poller = messagingProvider.createPoller(topicName, Reset.earliest, new HandlerAdapter[]{HandlerAdapter.create(PackageStatusMessage.class, this::handle)});
    }

    public PackageStatusMessage.Status getStatus(String subAgentName, long pkgOffset) {
        Map<Long, PackageStatusMessage.Status> statusPerAgent = this.getAgentStatus(subAgentName);
        PackageStatusMessage.Status status = statusPerAgent.get(pkgOffset);
        if (status == null && this.higherStatusAlreadyArrived(subAgentName, pkgOffset)) {
            this.log.info("Considering offset={} imported as status for this package can not arrive anymore.", (Object)pkgOffset);
            return PackageStatusMessage.Status.IMPORTED;
        }
        return status;
    }

    private boolean higherStatusAlreadyArrived(String subAgentName, long pkgOffset) {
        NavigableMap<Long, PackageStatusMessage.Status> pkgStatus = this.pkgStatusPerSubAgent.get(subAgentName);
        return pkgStatus.higherKey(pkgOffset) != null;
    }

    private Map<Long, PackageStatusMessage.Status> getAgentStatus(String subAgentName) {
        return this.pkgStatusPerSubAgent.computeIfAbsent(subAgentName, this::newMap);
    }

    private NavigableMap<Long, PackageStatusMessage.Status> newMap(String subAgentName) {
        return new TreeMap<Long, PackageStatusMessage.Status>();
    }

    @Override
    public void close() throws IOException {
        this.poller.close();
    }

    private void handle(MessageInfo info, PackageStatusMessage pkgStatusMsg) {
        long pkgOffset = pkgStatusMsg.getOffset();
        Map<Long, PackageStatusMessage.Status> agentStatus = this.getAgentStatus(pkgStatusMsg.getSubAgentName());
        agentStatus.computeIfAbsent(pkgOffset, offset -> pkgStatusMsg.getStatus());
    }
}

