/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.kafka;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.header.Header;
import org.apache.sling.distribution.journal.ExceptionEventSender;
import org.apache.sling.distribution.journal.HandlerAdapter;
import org.apache.sling.distribution.journal.MessagingException;
import org.apache.sling.distribution.journal.RunnableUtil;
import org.apache.sling.distribution.journal.kafka.JsonRecordHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPoller
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaPoller.class);
    private static final long ERROR_SLEEP_MS = 10000L;
    private final KafkaConsumer<String, String> consumer;
    private final Map<String, JsonRecordHandler<?>> handlers;
    private final ExceptionEventSender eventSender;
    private final ObjectMapper mapper;
    private volatile boolean running = true;
    long errorSleepMs;

    public KafkaPoller(KafkaConsumer<String, String> consumer, ExceptionEventSender eventSender, List<HandlerAdapter<?>> adapters) {
        this.consumer = Objects.requireNonNull(consumer);
        this.eventSender = Objects.requireNonNull(eventSender);
        this.errorSleepMs = 10000L;
        this.mapper = new ObjectMapper();
        this.handlers = adapters.stream().collect(Collectors.toMap(this::typeName, this::toHandler));
        RunnableUtil.startBackgroundThread(this::run, (String)"Message Poller");
    }

    private String typeName(HandlerAdapter<?> adapter) {
        return adapter.getType().getSimpleName();
    }

    <T> JsonRecordHandler<T> toHandler(HandlerAdapter<T> adapter) {
        ObjectReader reader = this.mapper.readerFor(adapter.getType());
        return new JsonRecordHandler(adapter.getHandler(), reader);
    }

    @Override
    public void close() throws IOException {
        LOG.info("Shutdown poller");
        this.running = false;
        this.consumer.wakeup();
    }

    public void run() {
        LOG.info("Start poller");
        while (this.running) {
            try {
                this.consumer.poll(Duration.ofHours(1L)).forEach(this::handle);
            }
            catch (WakeupException e) {
                LOG.debug("Waked up {}", (Object)e.getMessage(), (Object)e);
                this.running = false;
            }
            catch (Exception e) {
                this.eventSender.send(e);
                LOG.error("Exception while receiving from kafka: {}", (Object)e.getMessage(), (Object)e);
                this.sleepAfterError();
            }
        }
        this.consumer.close();
        LOG.info("Stopped poller");
    }

    public void handle(ConsumerRecord<String, String> record) {
        try {
            String messageType = this.getMessageType(record);
            JsonRecordHandler<?> handler = this.handlers.get(messageType);
            if (handler != null) {
                handler.accept(record);
            } else {
                LOG.info("No handler for messageType={}. Ignoring message.", (Object)messageType);
            }
        }
        catch (Exception e) {
            LOG.warn("Error consuming message {}", (Object)record.headers(), (Object)e);
        }
    }

    private String getMessageType(ConsumerRecord<String, String> record) {
        Iterator headers = record.headers().headers("messageType").iterator();
        if (!headers.hasNext()) {
            throw new MessagingException("Header messageType missing.");
        }
        Header messageTypeHeader = (Header)headers.next();
        return new String(messageTypeHeader.value(), StandardCharsets.UTF_8);
    }

    private void sleepAfterError() {
        try {
            Thread.sleep(this.errorSleepMs);
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
        }
    }
}

