/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.jackrabbit.vault.util.PathUtil;
import org.apache.sling.feature.cpconverter.shared.AbstractJcrNodeParser;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;

public class DefaultEntryParser
extends AbstractJcrNodeParser<Set<String>> {
    private final LinkedList<String> currentPath = new LinkedList();
    private final Set<String> coveredNodePaths = new LinkedHashSet<String>();

    public DefaultEntryParser(@NotNull String repositoryPath) {
        super(new String[0]);
        this.currentPath.push(repositoryPath);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if ("jcr:root".equals(qName)) {
            return;
        }
        String path = PathUtil.append((String)this.currentPath.peek(), (String)qName);
        this.currentPath.push(path);
        this.coveredNodePaths.add(path);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.currentPath.pop();
    }

    @Override
    protected void onJcrRootElement(String uri, String localName, String qName, Attributes attributes) {
    }

    @Override
    public Set<String> getParsingResult() {
        return this.coveredNodePaths;
    }
}

