/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.spi2dav;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.org.apache.jackrabbit.commons.webdav.NodeTypeUtil;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.ChildInfo;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.Name;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.NodeId;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.NodeInfo;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.PropertyId;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.conversion.NameException;
import relocated_for_contentpackage.org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import relocated_for_contentpackage.org.apache.jackrabbit.spi2dav.ItemInfoImpl;
import relocated_for_contentpackage.org.apache.jackrabbit.spi2dav.ItemResourceConstants;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.property.DavProperty;
import relocated_for_contentpackage.org.apache.jackrabbit.webdav.property.DavPropertySet;

public class NodeInfoImpl
extends ItemInfoImpl
implements NodeInfo {
    private static Logger log = LoggerFactory.getLogger(NodeInfoImpl.class);
    private final NodeId id;
    private final int index;
    private final Name primaryNodeTypeName;
    private final Name[] mixinNodeTypeNames;
    private final List<PropertyId> references = new ArrayList<PropertyId>();
    private final List<PropertyId> propertyIds = new ArrayList<PropertyId>();
    private List<ChildInfo> childInfos = null;

    public NodeInfoImpl(NodeId id, DavPropertySet propSet, NamePathResolver resolver) throws RepositoryException, NameException {
        super(propSet, resolver);
        this.id = id;
        DavProperty<?> indexProp = propSet.get("index", ItemResourceConstants.NAMESPACE);
        this.index = indexProp != null && indexProp.getValue() != null ? Integer.parseInt(indexProp.getValue().toString()) : 1;
        try {
            Iterator<String> it;
            DavProperty<?> prop = propSet.get("primarynodetype", ItemResourceConstants.NAMESPACE);
            if (prop != null) {
                it = NodeTypeUtil.ntNamesFromXml(prop.getValue()).iterator();
                if (!it.hasNext()) {
                    throw new RepositoryException("Missing primary nodetype for node " + id + ".");
                }
            } else {
                throw new RepositoryException("Missing primary nodetype for node " + id);
            }
            String jcrName = it.next();
            this.primaryNodeTypeName = resolver.getQName(jcrName);
            prop = propSet.get("mixinnodetypes", ItemResourceConstants.NAMESPACE);
            if (prop != null) {
                Collection<String> mixinNames = NodeTypeUtil.ntNamesFromXml(prop.getValue());
                this.mixinNodeTypeNames = new Name[mixinNames.size()];
                int i = 0;
                for (String jcrName2 : mixinNames) {
                    this.mixinNodeTypeNames[i] = resolver.getQName(jcrName2);
                    ++i;
                }
            } else {
                this.mixinNodeTypeNames = Name.EMPTY_ARRAY;
            }
        }
        catch (NameException e) {
            throw new RepositoryException("Error while resolving nodetype names: " + e.getMessage());
        }
    }

    @Override
    public boolean denotesNode() {
        return true;
    }

    @Override
    public NodeId getId() {
        return this.id;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public Name getNodetype() {
        return this.primaryNodeTypeName;
    }

    @Override
    public Name[] getMixins() {
        return this.mixinNodeTypeNames;
    }

    @Override
    public PropertyId[] getReferences() {
        return this.references.toArray(new PropertyId[this.references.size()]);
    }

    @Override
    public Iterator<PropertyId> getPropertyIds() {
        return this.propertyIds.iterator();
    }

    @Override
    public Iterator<ChildInfo> getChildInfos() {
        return this.childInfos == null ? null : this.childInfos.iterator();
    }

    void addReference(PropertyId referenceId) {
        this.references.add(referenceId);
    }

    void addPropertyId(PropertyId childId) {
        this.propertyIds.add(childId);
    }

    void addChildInfo(ChildInfo childInfo) {
        if (this.childInfos == null) {
            this.childInfos = new ArrayList<ChildInfo>();
        }
        this.childInfos.add(childInfo);
    }
}

