/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.jackrabbit.vault.util;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import relocated_for_contentpackage.javax.jcr.Repository;
import relocated_for_contentpackage.javax.jcr.RepositoryException;
import relocated_for_contentpackage.org.apache.jackrabbit.spi2dav.ConnectionOptions;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.RepositoryAddress;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.api.RepositoryFactory;

public class RepositoryProvider {
    protected static Logger log = LoggerFactory.getLogger(RepositoryProvider.class);
    private Map<RepositoryAddress, Repository> repos = new HashMap<RepositoryAddress, Repository>();

    public Repository getRepository(RepositoryAddress address) throws RepositoryException {
        return this.getRepository(address, null);
    }

    public Repository getRepository(RepositoryAddress address, ConnectionOptions options) throws RepositoryException {
        Repository rep = this.repos.get(address);
        if (rep == null) {
            rep = this.createRepository(address, options);
            this.repos.put(address, rep);
        }
        return rep;
    }

    private Repository createRepository(RepositoryAddress address, ConnectionOptions options) throws RepositoryException {
        ServiceLoader<RepositoryFactory> loader = ServiceLoader.load(RepositoryFactory.class);
        Iterator<RepositoryFactory> iter = loader.iterator();
        HashSet<String> supported = new HashSet<String>();
        while (iter.hasNext()) {
            Repository wrapped;
            RepositoryFactory fac = iter.next();
            supported.addAll(fac.getSupportedSchemes());
            Repository rep = fac.createRepository(address, options);
            if (rep == null) continue;
            if ((Boolean.getBoolean("jcrlog.sysout") || System.getProperty("jcrlog.file") != null) && (wrapped = this.wrapLogger(rep, address)) != null) {
                log.info("Enabling JCR Logger.");
                rep = wrapped;
            }
            return rep;
        }
        StringBuffer msg = new StringBuffer("URL scheme ");
        msg.append(address.getURI().getScheme());
        msg.append(" not supported. only");
        for (String s : supported) {
            msg.append(" ").append(s);
        }
        throw new RepositoryException(msg.toString());
    }

    private Repository wrapLogger(Repository base, RepositoryAddress address) {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass("relocated_for_contentpackage.org.apache.jackrabbit.jcrlog.RepositoryLogger");
            Properties props = new Properties();
            for (Object o : System.getProperties().keySet()) {
                String name = o.toString();
                if (!name.startsWith("jcrlog.")) continue;
                props.put(name.substring("jcrlog.".length()), System.getProperty(name));
            }
            Constructor<?> c = clazz.getConstructor(Repository.class, Properties.class, String.class);
            return (Repository)c.newInstance(base, props, address.toString());
        }
        catch (Exception e) {
            log.error("Unable to initialize JCR logger: {}", (Object)e.toString());
            return null;
        }
    }
}

