/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fileoptim.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.fileoptim.FileOptimizerService;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostOperation;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={PostOperation.class}, property={"sling.post.operation=fileoptim:restore"})
public class RestoreOriginalOperation
implements PostOperation {
    private static final Logger log = LoggerFactory.getLogger(RestoreOriginalOperation.class);
    @Reference
    private FileOptimizerService fileOptimizer;

    protected void doRun(SlingHttpServletRequest request, List<Modification> changes) throws IOException {
        Resource resource = request.getResource();
        if (this.fileOptimizer.isOptimized(resource)) {
            ModifiableValueMap mvm = (ModifiableValueMap)resource.getChild("jcr:content").adaptTo(ModifiableValueMap.class);
            mvm.put((Object)"jcr:data", mvm.get("optim:original", InputStream.class));
            mvm.remove((Object)"optim:original");
            mvm.remove((Object)"optim:algrithm");
            mvm.remove((Object)"optim:hash");
            mvm.remove((Object)"optim:savings");
            resource.getResourceResolver().commit();
            changes.add(Modification.onModified((String)resource.getPath()));
        }
    }

    public void run(SlingHttpServletRequest request, PostResponse response, SlingPostProcessor[] processors) {
        try {
            String path = request.getResource().getPath();
            response.setPath(path);
            ArrayList<Modification> changes = new ArrayList<Modification>();
            this.doRun(request, changes);
            if (processors != null) {
                for (SlingPostProcessor processor : processors) {
                    processor.process(request, changes);
                }
            }
            HashMap<String, String> modificationSourcesContainingPostfix = new HashMap<String, String>();
            HashSet<String> allModificationSources = new HashSet<String>(changes.size());
            for (Modification modification : changes) {
                String source = modification.getSource();
                if (source == null) continue;
                allModificationSources.add(source);
                int atIndex = source.indexOf(64);
                if (atIndex <= 0) continue;
                modificationSourcesContainingPostfix.put(source.substring(0, atIndex), source);
            }
        }
        catch (Exception e) {
            log.error("Exception during response processing.", (Throwable)e);
            response.setError((Throwable)e);
        }
    }
}

