/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fileoptim.impl.filters;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.fileoptim.FileOptimizerService;
import org.apache.sling.fileoptim.OptimizationResult;
import org.apache.sling.fileoptim.models.OptimizedFile;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Filter.class}, property={"sling.filter.scope=REQUEST"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Config.class)
public class FileOptimizerFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(FileOptimizerFilter.class);
    @Reference
    private FileOptimizerService fileOptimizer;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof SlingHttpServletRequest) {
            Resource resource = ((SlingHttpServletRequest)request).getResource();
            try {
                if (this.fileOptimizer.canOptimize(resource)) {
                    log.debug("Returning optimized file");
                    OptimizationResult res = this.fileOptimizer.getOptimizedContents(resource);
                    if (res.isOptimized()) {
                        OptimizedFile of = null;
                        of = !resource.getName().equals("jcr:content") ? (OptimizedFile)resource.getChild("jcr:content").adaptTo(OptimizedFile.class) : (OptimizedFile)resource.adaptTo(OptimizedFile.class);
                        response.setContentType(of.getMimeType());
                        response.setContentLengthLong(res.getOptimizedSize());
                        ((HttpServletResponse)response).setHeader("Optimized-With", res.getAlgorithm());
                        IOUtils.copy((InputStream)res.getOptimizedContentStream(), (OutputStream)response.getOutputStream());
                        return;
                    }
                }
            }
            catch (Exception e) {
                log.warn("Unexpected exception attempting to optimize file response", (Throwable)e);
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    @ObjectClassDefinition(name="%filter.name", description="%filter.description", localization="OSGI-INF/l10n/bundle")
    public static @interface Config {
        @AttributeDefinition(name="%filter.pattern.name", description="%filter.pattern.description")
        public String sling_filter_pattern() default "-";

        @AttributeDefinition(name="%filter.service.ranking.name", description="%filter.service.ranking.name")
        public int service_ranking() default 0;
    }
}

