/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factory.packages.impl;

import org.apache.jackrabbit.vault.packaging.DependencyHandling;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(name="Apache Sling OSGi Installer Package Transformer", description="Allows to configure how content packages are installed through the OSGi installer")
public @interface PackageTransformerConfiguration {
    @AttributeDefinition(name="Create Snapshots", description="Boolean flag indicating whether prior to the installation of the package a snapshot of the repository should be created. Only relevant when hollow packages are disabled.")
    public boolean shouldCreateSnapshots() default false;

    @AttributeDefinition(name="Use hollow packages", description="Boolean flag indicating whether hollow packages (i.e. packages not containing actual content) should be used. This prevents the package file from being copied to the repository first before being installed (i.e. reduces required disk space, improves speed) but also prevents snapshot creation and uninstallation.")
    public boolean shouldCreateHollowPackages() default false;

    @AttributeDefinition(name="Observation Manager's User Data", description="Sets the user data on the observation manager (only affects the session used for package installation) to the given value. Leave empty to not set it. Can be used to check in EventListeners whether an event was caused by package installation/uninstallation.")
    public String observationManagerUserData() default "";

    @AttributeDefinition(name="Dependency Handling", description="Sets the dependency handling for package installation. Must have one of the values 'IGNORE', 'BEST_EFFORT', 'REQUIRED' or 'STRICT'.")
    public DependencyHandling dependencyHandling() default DependencyHandling.STRICT;
}

