/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.jackrabbit.core.query.lucene.IndexListener;
import org.apache.jackrabbit.core.query.lucene.MultiIndex;
import org.apache.jackrabbit.core.query.lucene.PersistentIndex;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndexMerger
implements IndexListener {
    private static final Logger log = LoggerFactory.getLogger(IndexMerger.class);
    private int minMergeDocs = 100;
    private int maxMergeDocs = Integer.MAX_VALUE;
    private int mergeFactor = 10;
    private final List<IndexBucket> indexBuckets = new ArrayList<IndexBucket>();
    private final MultiIndex multiIndex;
    private final Executor executor;
    private final AtomicBoolean quit = new AtomicBoolean(false);
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final Object lock = new Object();
    private final ReadWriteLock indexReplacement = new ReentrantReadWriteLock();
    private final List<Worker> busyMergers = new ArrayList<Worker>();

    IndexMerger(MultiIndex multiIndex, Executor executor) {
        this.multiIndex = multiIndex;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        this.isStarted.set(true);
        List<Worker> list = this.busyMergers;
        synchronized (list) {
            for (Worker worker : this.busyMergers) {
                worker.unblock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void indexAdded(String name, int numDocs) {
        if (numDocs < 0) {
            throw new IllegalArgumentException("numDocs must be positive");
        }
        Object object = this.lock;
        synchronized (object) {
            IndexBucket indexBucket;
            if (this.indexBuckets.size() == 0) {
                long lower = 0L;
                for (long upper = (long)this.minMergeDocs; upper < (long)this.maxMergeDocs; upper *= (long)this.mergeFactor) {
                    this.indexBuckets.add(new IndexBucket(lower, upper, true));
                    lower = upper + 1L;
                }
                this.indexBuckets.add(new IndexBucket(lower, this.maxMergeDocs, false));
                this.indexBuckets.add(new IndexBucket(this.maxMergeDocs + 1, Long.MAX_VALUE, false));
            }
            IndexBucket bucket = this.indexBuckets.get(this.indexBuckets.size() - 1);
            Iterator<IndexBucket> i$ = this.indexBuckets.iterator();
            while (i$.hasNext() && !(bucket = (indexBucket = i$.next())).fits(numDocs)) {
            }
            bucket.add(new Index(name, numDocs));
            if (log.isDebugEnabled()) {
                log.debug("index added: name=" + name + ", numDocs=" + numDocs);
            }
            if (!bucket.allowsMerge()) {
                return;
            }
            if (bucket.size() >= this.mergeFactor) {
                long targetMergeDocs = bucket.upper;
                targetMergeDocs = Math.min(targetMergeDocs * (long)this.mergeFactor, (long)this.maxMergeDocs);
                ArrayList indexesToMerge = new ArrayList();
                int mergeDocs = 0;
                Iterator it = bucket.iterator();
                while (it.hasNext() && (long)mergeDocs <= targetMergeDocs) {
                    indexesToMerge.add(it.next());
                }
                if (indexesToMerge.size() > 2) {
                    Index[] idxs = indexesToMerge.toArray(new Index[indexesToMerge.size()]);
                    bucket.removeAll(indexesToMerge);
                    if (log.isDebugEnabled()) {
                        log.debug("requesting merge for " + indexesToMerge);
                    }
                    this.addMergeTask(new Merge(idxs));
                    if (log.isDebugEnabled()) {
                        int numBusy;
                        List<Worker> list = this.busyMergers;
                        synchronized (list) {
                            numBusy = this.busyMergers.size();
                        }
                        log.debug("# of busy merge workers: " + numBusy);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void documentDeleted(Term id) {
        log.debug("document deleted: " + id.text());
        List<Worker> list = this.busyMergers;
        synchronized (list) {
            for (Worker w : this.busyMergers) {
                w.documentDeleted(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitUntilIdle() throws InterruptedException {
        List<Worker> list = this.busyMergers;
        synchronized (list) {
            while (!this.busyMergers.isEmpty()) {
                this.busyMergers.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        log.debug("dispose IndexMerger");
        try {
            this.indexReplacement.writeLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while acquiring index replacement exclusive lock: " + e);
        }
        this.quit.set(true);
        log.debug("quit flag set");
        try {
            Worker[] workers;
            List<Worker> list = this.busyMergers;
            synchronized (list) {
                workers = this.busyMergers.toArray(new Worker[this.busyMergers.size()]);
            }
            for (Worker w : workers) {
                w.join(500L);
                if (w.isAlive()) {
                    log.info("Unable to stop IndexMerger.Worker. Daemon is busy.");
                    continue;
                }
                log.debug("IndexMerger.Worker thread stopped");
            }
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while waiting for IndexMerger threads to terminate.");
        }
    }

    public void setMergeFactor(int mergeFactor) {
        this.mergeFactor = mergeFactor;
    }

    public void setMinMergeDocs(int minMergeDocs) {
        this.minMergeDocs = minMergeDocs;
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMergeTask(Merge task) {
        if (!this.quit.get()) {
            Worker worker = new Worker(task);
            if (this.isStarted.get()) {
                worker.unblock();
            }
            List<Worker> list = this.busyMergers;
            synchronized (list) {
                this.busyMergers.add(worker);
            }
            this.executor.execute(worker);
        }
    }

    private class Worker
    implements Runnable,
    IndexListener {
        private final List<Term> deletedDocuments = Collections.synchronizedList(new ArrayList());
        private final CountDownLatch start = new CountDownLatch(1);
        private final AtomicBoolean terminated = new AtomicBoolean(false);
        private final Merge task;

        private Worker(Merge task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                try {
                    this.start.await();
                }
                catch (InterruptedException e) {
                    if (!IndexMerger.this.quit.get()) {
                        IndexMerger.this.addMergeTask(this.task);
                    }
                    Object object = this.terminated;
                    synchronized (object) {
                        this.terminated.set(true);
                        this.terminated.notifyAll();
                    }
                    object = IndexMerger.this.busyMergers;
                    synchronized (object) {
                        IndexMerger.this.busyMergers.remove(this);
                        IndexMerger.this.busyMergers.notifyAll();
                    }
                    log.debug("Worker finished");
                    return;
                }
                log.debug("accepted merge request");
                String[] names = new String[this.task.indexes.length];
                for (int i = 0; i < this.task.indexes.length; ++i) {
                    names[i] = this.task.indexes[i].name;
                }
                try {
                    Lock shared;
                    boolean success;
                    PersistentIndex index;
                    block47: {
                        log.debug("create new index");
                        index = IndexMerger.this.multiIndex.getOrCreateIndex(null);
                        success = false;
                        log.debug("get index readers from MultiIndex");
                        IndexReader[] readers = IndexMerger.this.multiIndex.getIndexReaders(names, IndexMerger.this);
                        try {
                            IndexReader reader;
                            long time = System.currentTimeMillis();
                            index.addIndexes(readers);
                            time = System.currentTimeMillis() - time;
                            int docCount = 0;
                            IndexReader[] arr$ = readers;
                            int len$ = arr$.length;
                            for (int i$ = 0; i$ < len$; docCount += reader.numDocs(), ++i$) {
                                reader = arr$[i$];
                            }
                            log.info("merged " + docCount + " documents in " + time + " ms into " + index.getName() + ".");
                        }
                        finally {
                            IndexReader[] arr$ = readers;
                            int len$ = arr$.length;
                            int i$ = 0;
                            while (true) {
                                if (i$ >= len$) {
                                }
                                IndexReader reader = arr$[i$];
                                try {
                                    Util.closeOrRelease(reader);
                                }
                                catch (IOException e) {
                                    log.warn("Unable to close IndexReader: " + e);
                                }
                                ++i$;
                            }
                        }
                        shared = IndexMerger.this.indexReplacement.readLock();
                        if (shared.tryLock()) break block47;
                        log.debug("index merging canceled");
                        if (success) return;
                        log.debug("deleting index " + index.getName());
                        IndexMerger.this.multiIndex.deleteIndex(index);
                        IndexMerger.this.addMergeTask(this.task);
                        return;
                    }
                    try {
                        try {
                            log.debug("replace indexes");
                            IndexMerger.this.multiIndex.replaceIndexes(names, index, this.deletedDocuments);
                        }
                        finally {
                            shared.unlock();
                        }
                        success = true;
                        return;
                    }
                    finally {
                        if (!success) {
                            log.debug("deleting index " + index.getName());
                            IndexMerger.this.multiIndex.deleteIndex(index);
                            IndexMerger.this.addMergeTask(this.task);
                        }
                    }
                }
                catch (Throwable e) {
                    log.error("Error while merging indexes: ", e);
                    return;
                }
            }
            finally {
                Object object = this.terminated;
                synchronized (object) {
                    this.terminated.set(true);
                    this.terminated.notifyAll();
                }
                object = IndexMerger.this.busyMergers;
                synchronized (object) {
                    IndexMerger.this.busyMergers.remove(this);
                    IndexMerger.this.busyMergers.notifyAll();
                }
                log.debug("Worker finished");
            }
        }

        @Override
        public void documentDeleted(Term id) {
            log.debug("document deleted: " + id.text());
            this.deletedDocuments.add(id);
        }

        void unblock() {
            this.start.countDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void join(long timeout) throws InterruptedException {
            AtomicBoolean atomicBoolean = this.terminated;
            synchronized (atomicBoolean) {
                while (!this.terminated.get()) {
                    this.terminated.wait(timeout);
                }
            }
        }

        boolean isAlive() {
            return !this.terminated.get();
        }
    }

    private static final class IndexBucket
    extends ArrayList<Index> {
        private static final long serialVersionUID = 2985514550083374904L;
        private final long lower;
        private final long upper;
        private final boolean allowMerge;

        IndexBucket(long lower, long upper, boolean allowMerge) {
            this.lower = lower;
            this.upper = upper;
            this.allowMerge = allowMerge;
        }

        boolean fits(long numDocs) {
            return numDocs >= this.lower && numDocs <= this.upper;
        }

        boolean allowsMerge() {
            return this.allowMerge;
        }
    }

    private static final class Merge {
        private final Index[] indexes;

        Merge(Index[] indexes) {
            this.indexes = new Index[indexes.length];
            System.arraycopy(indexes, 0, this.indexes, 0, indexes.length);
        }
    }

    private static final class Index
    implements Comparable<Index> {
        private final String name;
        private final int numDocs;

        Index(String name, int numDocs) {
            this.name = name;
            this.numDocs = numDocs;
        }

        @Override
        public int compareTo(Index other) {
            int val;
            int n = this.numDocs < other.numDocs ? -1 : (val = this.numDocs == other.numDocs ? 0 : 1);
            if (val != 0) {
                return val;
            }
            return this.name.compareTo(other.name);
        }

        public String toString() {
            return this.name + ":" + this.numDocs;
        }
    }
}

