/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.testservices.repository;

import javax.jcr.Session;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.api.SlingRepositoryInitializer;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SlingRepositoryInitializer.class}, property={"service.ranking:Integer=100"})
public class FirstRepositoryInitializer
implements SlingRepositoryInitializer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String SIGNAL_NODE_PATH = "/" + FirstRepositoryInitializer.class.getName();

    public void processRepository(SlingRepository repo) throws Exception {
        Session s = repo.loginAdministrative(null);
        try {
            if (s.itemExists(SIGNAL_NODE_PATH)) {
                this.log.warn("{} already exists, these tests expect to run on an empty repository", (Object)SIGNAL_NODE_PATH);
            } else {
                s.getRootNode().addNode(SIGNAL_NODE_PATH.substring(1));
                this.log.info("{} created", (Object)SIGNAL_NODE_PATH);
                s.save();
            }
        }
        finally {
            s.logout();
        }
    }
}

