/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.thymeleaf.internal.processor;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.scripting.core.servlet.CaptureResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.templatemode.TemplateMode;

public class SlingIncludeAttributeTagProcessor
extends AbstractAttributeTagProcessor {
    public static final int ATTRIBUTE_PRECEDENCE = 100;
    public static final String ATTRIBUTE_NAME = "include";
    public static final String ADD_SELECTORS_ATTRIBUTE_NAME = "addSelectors";
    public static final String REPLACE_SELECTORS_ATTRIBUTE_NAME = "replaceSelectors";
    public static final String REPLACE_SUFFIX_ATTRIBUTE_NAME = "replaceSuffix";
    public static final String RESOURCE_TYPE_ATTRIBUTE_NAME = "resourceType";
    public static final String UNWRAP_ATTRIBUTE_NAME = "unwrap";
    private final Logger logger = LoggerFactory.getLogger(SlingIncludeAttributeTagProcessor.class);

    public SlingIncludeAttributeTagProcessor(String dialectPrefix) {
        super(TemplateMode.HTML, dialectPrefix, null, true, ATTRIBUTE_NAME, true, 100, true);
    }

    protected void doProcess(ITemplateContext templateContext, IProcessableElementTag processableElementTag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler elementTagStructureHandler) {
        try {
            SlingHttpServletRequest slingHttpServletRequest = (SlingHttpServletRequest)templateContext.getVariable("request");
            SlingHttpServletResponse slingHttpServletResponse = (SlingHttpServletResponse)templateContext.getVariable("response");
            IEngineConfiguration configuration = templateContext.getConfiguration();
            IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser((IEngineConfiguration)configuration);
            IStandardExpression expression = expressionParser.parseExpression((IExpressionContext)templateContext, attributeValue);
            Object include = expression.execute((IExpressionContext)templateContext);
            String path = null;
            if (include instanceof String) {
                path = (String)include;
            }
            Resource resource = null;
            if (include instanceof Resource) {
                resource = (Resource)include;
            }
            RequestDispatcherOptions requestDispatcherOptions = this.prepareRequestDispatcherOptions(expressionParser, templateContext, processableElementTag, elementTagStructureHandler);
            String content = this.dispatch(resource, path, slingHttpServletRequest, slingHttpServletResponse, requestDispatcherOptions);
            Boolean unwrap = (Boolean)this.parseAttribute(expressionParser, templateContext, processableElementTag, elementTagStructureHandler, UNWRAP_ATTRIBUTE_NAME);
            if (unwrap != null && unwrap.booleanValue()) {
                elementTagStructureHandler.replaceWith((CharSequence)content, false);
            } else {
                elementTagStructureHandler.setBody((CharSequence)content, false);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("unable to process include attribute", e);
        }
    }

    protected Object parseAttribute(IStandardExpressionParser expressionParser, ITemplateContext templateContext, IProcessableElementTag processableElementTag, IElementTagStructureHandler elementTagStructureHandler, String name) {
        String value = processableElementTag.getAttributeValue(this.getDialectPrefix(), name);
        Object result = null;
        if (value != null) {
            IStandardExpression expression = expressionParser.parseExpression((IExpressionContext)templateContext, value);
            result = expression.execute((IExpressionContext)templateContext);
        }
        elementTagStructureHandler.removeAttribute(this.getDialectPrefix(), name);
        return result;
    }

    protected RequestDispatcherOptions prepareRequestDispatcherOptions(IStandardExpressionParser expressionParser, ITemplateContext templateContext, IProcessableElementTag processableElementTag, IElementTagStructureHandler elementTagStructureHandler) {
        String resourceType = (String)this.parseAttribute(expressionParser, templateContext, processableElementTag, elementTagStructureHandler, RESOURCE_TYPE_ATTRIBUTE_NAME);
        String replaceSelectors = (String)this.parseAttribute(expressionParser, templateContext, processableElementTag, elementTagStructureHandler, REPLACE_SELECTORS_ATTRIBUTE_NAME);
        String addSelectors = (String)this.parseAttribute(expressionParser, templateContext, processableElementTag, elementTagStructureHandler, ADD_SELECTORS_ATTRIBUTE_NAME);
        String replaceSuffix = (String)this.parseAttribute(expressionParser, templateContext, processableElementTag, elementTagStructureHandler, REPLACE_SUFFIX_ATTRIBUTE_NAME);
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        options.setForceResourceType(resourceType);
        options.setReplaceSelectors(replaceSelectors);
        options.setAddSelectors(addSelectors);
        options.setReplaceSuffix(replaceSuffix);
        return options;
    }

    protected String dispatch(Resource resource, String path, SlingHttpServletRequest slingHttpServletRequest, SlingHttpServletResponse slingHttpServletResponse, RequestDispatcherOptions requestDispatcherOptions) {
        block12: {
            if (path != null) {
                if (!path.startsWith("/")) {
                    path = slingHttpServletRequest.getResource().getPath() + "/" + path;
                }
                path = ResourceUtil.normalize((String)path);
            }
            if (resource == null) {
                if (path == null) {
                    resource = slingHttpServletRequest.getResource();
                } else {
                    String resourceType = requestDispatcherOptions.getForceResourceType();
                    Resource tmp = slingHttpServletRequest.getResourceResolver().resolve(path);
                    if (tmp == null && resourceType != null) {
                        resource = new SyntheticResource(slingHttpServletRequest.getResourceResolver(), path, resourceType);
                        requestDispatcherOptions.remove((Object)"forceResourceType");
                    }
                }
            }
            try {
                RequestDispatcher dispatcher = resource != null ? slingHttpServletRequest.getRequestDispatcher(resource, requestDispatcherOptions) : slingHttpServletRequest.getRequestDispatcher(path, requestDispatcherOptions);
                if (dispatcher != null) {
                    try {
                        CaptureResponseWrapper wrapper = new CaptureResponseWrapper((HttpServletResponse)slingHttpServletResponse);
                        dispatcher.include((ServletRequest)slingHttpServletRequest, (ServletResponse)wrapper);
                        if (!wrapper.isBinaryResponse()) {
                            return wrapper.getCapturedCharacterResponse();
                        }
                        break block12;
                    }
                    catch (ServletException e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                    break block12;
                }
                this.logger.error("no request dispatcher: unable to include {}/'{}'", (Object)resource, (Object)path);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

