/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.resource;

import java.io.InputStream;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Servlet;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.scripting.spi.bundle.BundledRenderUnit;
import org.apache.sling.servlets.resolver.internal.ServletWrapperUtil;
import org.apache.sling.servlets.resolver.internal.bundle.BundledScriptServlet;
import org.apache.sling.servlets.resolver.internal.resource.ServletResourceProviderFactory;

public class ServletResource
extends AbstractResource {
    public static final String DEFAULT_RESOURCE_SUPER_TYPE = "sling/bundle/resource";
    private final ResourceResolver resourceResolver;
    private final jakarta.servlet.Servlet servlet;
    private final String path;
    private final String resourceType;
    private final String resourceSuperType;
    private final ResourceMetadata metadata;
    private AtomicReference<Resource> wrapped = new AtomicReference();

    public ServletResource(ResourceResolver resourceResolver, jakarta.servlet.Servlet servlet, String path) {
        this(resourceResolver, servlet, path, null);
    }

    ServletResource(ResourceResolver resourceResolver, jakarta.servlet.Servlet servlet, String path, String resourceSuperType) {
        this.resourceResolver = resourceResolver;
        this.servlet = servlet;
        this.path = path;
        this.resourceType = ServletResourceProviderFactory.ensureServletNameExtension(path);
        this.resourceSuperType = resourceSuperType == null || resourceSuperType.isEmpty() ? DEFAULT_RESOURCE_SUPER_TYPE : resourceSuperType;
        this.metadata = new ResourceMetadata();
        this.metadata.put("sling.servlet.resource", (Object)"true");
    }

    void setWrappedResource(Resource wrapped) {
        if (wrapped != null && !"sling:nonexisting".equals(wrapped.getResourceType())) {
            this.wrapped.set(wrapped);
        }
    }

    public ResourceMetadata getResourceMetadata() {
        return this.metadata;
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceSuperType() {
        return this.resourceSuperType;
    }

    public String getPath() {
        return this.path;
    }

    private String getServletName() {
        String servletName = null;
        if (this.servlet != null) {
            if (this.servlet.getServletConfig() != null) {
                servletName = this.servlet.getServletConfig().getServletName();
            }
            if (servletName == null) {
                servletName = this.servlet.getServletInfo();
            }
            if (servletName == null) {
                servletName = this.servlet.getClass().getName();
            }
        }
        return servletName;
    }

    private BundledScriptServlet isBundledScriptServlet() {
        Servlet w;
        if (this.servlet instanceof BundledScriptServlet) {
            return (BundledScriptServlet)this.servlet;
        }
        if (this.servlet instanceof ServletWrapperUtil.JakartaScriptServletWrapper && (w = ((ServletWrapperUtil.JakartaScriptServletWrapper)this.servlet).servlet) instanceof BundledScriptServlet) {
            return (BundledScriptServlet)w;
        }
        return null;
    }

    public <T> T adaptTo(Class<T> type) {
        Object result;
        Resource wrappedResource = this.wrapped.get();
        if (type == jakarta.servlet.Servlet.class && this.servlet != null) {
            return (T)this.servlet;
        }
        if (type == Servlet.class && this.servlet != null) {
            return (T)ServletWrapperUtil.toJavaxServlet(this.servlet);
        }
        if (type == InputStream.class && this.isBundledScriptServlet() != null && (result = this.isBundledScriptServlet().getInputStream()) != null) {
            return (T)result;
        }
        if (type == BundledRenderUnit.class && this.isBundledScriptServlet() != null) {
            return (T)this.isBundledScriptServlet().getBundledRenderUnit();
        }
        if (wrappedResource != null && (result = wrappedResource.adaptTo(type)) != null) {
            return (T)result;
        }
        if (type == ValueMap.class) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("sling:resourceType", this.getResourceType());
            props.put("sling:resourceSuperType", this.getResourceSuperType());
            if (this.servlet != null) {
                props.put("servletName", this.getServletName());
                props.put("servletClass", this.servlet.getClass().getName());
            }
            return (T)new ValueMapDecorator(props);
        }
        return (T)super.adaptTo(type);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ", servlet=" + this.getServletName() + ", path=" + this.getPath();
    }
}

