/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ConfigurationErrorHandler
implements ErrorHandler {
    private static Logger log = LoggerFactory.getLogger(ConfigurationErrorHandler.class);

    public void error(SAXParseException exception) throws SAXException {
        this.log("Warning", exception);
    }

    private void log(String type, SAXParseException exception) {
        log.warn(type + " parsing the configuration at line " + exception.getLineNumber() + " using system id " + exception.getSystemId() + ": " + exception.toString());
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this.log("Fatal error", exception);
        throw exception;
    }

    public void warning(SAXParseException exception) throws SAXException {
        this.log("Warning", exception);
    }
}

