/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.query.lucene.CachingMultiIndexReader;
import org.apache.jackrabbit.core.query.lucene.ConsistencyCheckError;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.FieldSelectors;
import org.apache.jackrabbit.core.query.lucene.MultiIndex;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.lucene.document.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsistencyCheck {
    private static final Logger log = LoggerFactory.getLogger(ConsistencyCheck.class);
    private final ItemStateManager stateMgr;
    private final MultiIndex index;
    private Set<NodeId> documentIds;
    private final List<ConsistencyCheckError> errors = new ArrayList<ConsistencyCheckError>();

    private ConsistencyCheck(MultiIndex index, ItemStateManager mgr) {
        this.index = index;
        this.stateMgr = mgr;
    }

    static ConsistencyCheck run(MultiIndex index, ItemStateManager mgr) throws IOException {
        ConsistencyCheck check = new ConsistencyCheck(index, mgr);
        check.run();
        return check;
    }

    public void repair(boolean ignoreFailure) throws IOException {
        if (this.errors.size() == 0) {
            log.info("No errors found.");
            return;
        }
        int notRepairable = 0;
        for (ConsistencyCheckError error : this.errors) {
            try {
                if (error.repairable()) {
                    error.repair();
                    continue;
                }
                log.warn("Not repairable: " + error);
                ++notRepairable;
            }
            catch (Exception e2) {
                IOException e2;
                if (ignoreFailure) {
                    log.warn("Exception while reparing: " + e2);
                    continue;
                }
                if (!(e2 instanceof IOException)) {
                    e2 = new IOException(e2.getMessage());
                }
                throw (IOException)e2;
            }
        }
        log.info("Repaired " + (this.errors.size() - notRepairable) + " errors.");
        if (notRepairable > 0) {
            log.warn("" + notRepairable + " error(s) not repairable.");
        }
    }

    public List<ConsistencyCheckError> getErrors() {
        return new ArrayList<ConsistencyCheckError>(this.errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() throws IOException {
        NodeId id;
        HashSet<NodeId> multipleEntries = new HashSet<NodeId>();
        this.documentIds = new HashSet<NodeId>();
        CachingMultiIndexReader reader = this.index.getIndexReader();
        try {
            for (int i = 0; i < reader.maxDoc(); ++i) {
                if (i > 10 && i % (reader.maxDoc() / 5) == 0) {
                    long progress = Math.round(100.0 * (double)i / (double)((float)reader.maxDoc() * 2.0f));
                    log.info("progress: " + progress + "%");
                }
                if (reader.isDeleted(i)) continue;
                Document d = reader.document(i, FieldSelectors.UUID);
                id = new NodeId(d.get(FieldNames.UUID));
                if (this.stateMgr.hasItemState(id)) {
                    if (this.documentIds.add(id)) continue;
                    multipleEntries.add(id);
                    continue;
                }
                this.errors.add(new NodeDeleted(id));
            }
        }
        finally {
            reader.release();
        }
        for (NodeId id2 : multipleEntries) {
            this.errors.add(new MultipleEntries(id2));
        }
        reader = this.index.getIndexReader();
        try {
            for (int i = 0; i < reader.maxDoc(); ++i) {
                if (i > 10 && i % (reader.maxDoc() / 5) == 0) {
                    long progress = Math.round(100.0 * (double)i / (double)((float)reader.maxDoc() * 2.0f));
                    log.info("progress: " + (progress + 50L) + "%");
                }
                if (reader.isDeleted(i)) continue;
                Document d = reader.document(i, FieldSelectors.UUID_AND_PARENT);
                id = new NodeId(d.get(FieldNames.UUID));
                String parentUUIDString = d.get(FieldNames.PARENT);
                NodeId parentId = null;
                if (parentUUIDString.length() > 0) {
                    parentId = new NodeId(parentUUIDString);
                }
                if (parentId == null || this.documentIds.contains(parentId)) continue;
                if (this.stateMgr.hasItemState(parentId)) {
                    this.errors.add(new MissingAncestor(id, parentId));
                    continue;
                }
                this.errors.add(new UnknownParent(id, parentId));
            }
        }
        finally {
            reader.release();
        }
    }

    private String getPath(NodeState node) {
        String uuid = node.getNodeId().toString();
        StringBuffer path = new StringBuffer();
        ArrayList<ChildNodeEntry> elements = new ArrayList<ChildNodeEntry>();
        try {
            while (node.getParentId() != null) {
                NodeId parentId = node.getParentId();
                NodeState parent = (NodeState)this.stateMgr.getItemState(parentId);
                ChildNodeEntry entry = parent.getChildNodeEntry(node.getNodeId());
                elements.add(entry);
                node = parent;
            }
            for (int i = elements.size() - 1; i > -1; --i) {
                ChildNodeEntry entry = (ChildNodeEntry)elements.get(i);
                path.append('/').append(entry.getName().getLocalName());
                if (entry.getIndex() <= 1) continue;
                path.append('[').append(entry.getIndex()).append(']');
            }
            if (path.length() == 0) {
                path.append('/');
            }
            return path.toString();
        }
        catch (ItemStateException e) {
            return uuid;
        }
    }

    private class NodeDeleted
    extends ConsistencyCheckError {
        NodeDeleted(NodeId id) {
            super("Node " + id + " does not longer exist.", id);
        }

        public boolean repairable() {
            return true;
        }

        public void repair() throws IOException {
            log.info("Removing deleted node from index: " + this.id);
            ConsistencyCheck.this.index.removeDocument(this.id);
        }
    }

    private class MultipleEntries
    extends ConsistencyCheckError {
        MultipleEntries(NodeId id) {
            super("Multiple entries found for node " + id, id);
        }

        public boolean repairable() {
            return true;
        }

        public void repair() throws IOException {
            ConsistencyCheck.this.index.removeAllDocuments(this.id);
            try {
                NodeState node = (NodeState)ConsistencyCheck.this.stateMgr.getItemState(this.id);
                log.info("Re-indexing duplicate node occurrences in index: " + ConsistencyCheck.this.getPath(node));
                Document d = ConsistencyCheck.this.index.createDocument(node);
                ConsistencyCheck.this.index.addDocument(d);
                ConsistencyCheck.this.documentIds.add(node.getNodeId());
            }
            catch (ItemStateException e) {
                throw new IOException(e.toString());
            }
            catch (RepositoryException e) {
                throw new IOException(e.toString());
            }
        }
    }

    private class UnknownParent
    extends ConsistencyCheckError {
        private UnknownParent(NodeId id, NodeId parentId) {
            super("Node " + id + " has unknown parent: " + parentId, id);
        }

        public boolean repairable() {
            return false;
        }

        public void repair() throws IOException {
            log.warn("Unknown parent for " + this.id + " cannot be repaired");
        }
    }

    private class MissingAncestor
    extends ConsistencyCheckError {
        private final NodeId parentId;

        private MissingAncestor(NodeId id, NodeId parentId) {
            super("Parent of " + id + " missing in index. Parent: " + parentId, id);
            this.parentId = parentId;
        }

        public boolean repairable() {
            return true;
        }

        public void repair() throws IOException {
            NodeId ancestorId = this.parentId;
            while (ancestorId != null && !ConsistencyCheck.this.documentIds.contains(ancestorId)) {
                try {
                    NodeState n = (NodeState)ConsistencyCheck.this.stateMgr.getItemState(ancestorId);
                    log.info("Reparing missing node " + ConsistencyCheck.this.getPath(n));
                    Document d = ConsistencyCheck.this.index.createDocument(n);
                    ConsistencyCheck.this.index.addDocument(d);
                    ConsistencyCheck.this.documentIds.add(n.getNodeId());
                    ancestorId = n.getParentId();
                }
                catch (ItemStateException e) {
                    throw new IOException(e.toString());
                }
                catch (RepositoryException e) {
                    throw new IOException(e.toString());
                }
            }
        }
    }
}

