/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.AbstractScoreDocComparator;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.SharedFieldCache;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreDocComparator;
import org.apache.lucene.search.SortComparatorSource;

public class LengthSortComparator
implements SortComparatorSource {
    private static final long serialVersionUID = 2513564768671391632L;
    private final NamespaceMappings nsMappings;

    public LengthSortComparator(NamespaceMappings nsMappings) {
        this.nsMappings = nsMappings;
    }

    public ScoreDocComparator newComparator(IndexReader reader, String fieldname) throws IOException {
        NameFactory factory = NameFactoryImpl.getInstance();
        try {
            return new Comparator(reader, this.nsMappings.translateName(factory.create(fieldname)));
        }
        catch (IllegalNameException e) {
            throw Util.createIOException((Throwable)((Object)e));
        }
    }

    private final class Comparator
    extends AbstractScoreDocComparator {
        protected final SharedFieldCache.ValueIndex[] indexes;

        public Comparator(IndexReader reader, String propertyName) throws IOException {
            super(reader);
            this.indexes = new SharedFieldCache.ValueIndex[this.readers.size()];
            String namedLength = FieldNames.createNamedValue(propertyName, "");
            for (int i = 0; i < this.readers.size(); ++i) {
                IndexReader r = (IndexReader)this.readers.get(i);
                this.indexes[i] = SharedFieldCache.INSTANCE.getValueIndex(r, FieldNames.PROPERTY_LENGTHS, namedLength, LengthSortComparator.this);
            }
        }

        public Comparable sortValue(ScoreDoc i) {
            int idx = this.readerIndex(i.doc);
            return this.indexes[idx].getValue(i.doc - this.starts[idx]);
        }
    }
}

