/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.nodetype.compact;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.NamespaceException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.version.OnParentVersionAction;
import org.apache.jackrabbit.commons.cnd.Lexer;
import org.apache.jackrabbit.commons.query.qom.Operator;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueConstraint;
import org.apache.jackrabbit.spi.commons.QNodeTypeDefinitionImpl;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.namespace.SessionNamespaceResolver;
import org.apache.jackrabbit.spi.commons.nodetype.InvalidConstraintException;
import org.apache.jackrabbit.spi.commons.nodetype.constraint.ValueConstraint;
import org.apache.jackrabbit.spi.commons.value.QValueFactoryImpl;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.util.ISO9075;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompactNodeTypeDefWriter {
    private static final String INDENT = "  ";
    private final NamespaceResolver resolver;
    private final NamePathResolver npResolver;
    private Writer out;
    private Writer nsWriter;
    private final Set<String> usedNamespaces = new HashSet<String>();

    public CompactNodeTypeDefWriter(Writer out, Session s, boolean includeNS) {
        this(out, new SessionNamespaceResolver(s), new DefaultNamePathResolver(s), includeNS);
    }

    public CompactNodeTypeDefWriter(Writer out, NamespaceResolver r, boolean includeNS) {
        this(out, r, new DefaultNamePathResolver(r), includeNS);
    }

    public CompactNodeTypeDefWriter(Writer out, NamespaceResolver r, NamePathResolver npResolver) {
        this(out, r, npResolver, false);
    }

    public CompactNodeTypeDefWriter(Writer out, NamespaceResolver r, NamePathResolver npResolver, boolean includeNS) {
        this.resolver = r;
        this.npResolver = npResolver;
        if (includeNS) {
            this.out = new StringWriter();
            this.nsWriter = out;
        } else {
            this.out = out;
            this.nsWriter = null;
        }
    }

    public static void write(Collection<? extends QNodeTypeDefinition> defs, NamespaceResolver r, NamePathResolver npResolver, Writer out) throws IOException {
        CompactNodeTypeDefWriter w = new CompactNodeTypeDefWriter(out, r, npResolver, true);
        for (QNodeTypeDefinition qNodeTypeDefinition : defs) {
            w.write(qNodeTypeDefinition);
        }
        w.close();
    }

    public void write(QNodeTypeDefinition ntd) throws IOException {
        this.writeName(ntd);
        this.writeSupertypes(ntd);
        this.writeOptions(ntd);
        this.writePropDefs(ntd);
        this.writeNodeDefs(ntd);
        this.out.write("\n\n");
    }

    public void write(Collection<? extends QNodeTypeDefinition> defs) throws IOException {
        for (QNodeTypeDefinition qNodeTypeDefinition : defs) {
            this.write(qNodeTypeDefinition);
        }
    }

    public void write(NodeTypeDefinition nt) throws IOException {
        try {
            this.write(new QNodeTypeDefinitionImpl(nt, this.npResolver, QValueFactoryImpl.getInstance()));
        }
        catch (RepositoryException e) {
            throw new IOException("Error during internal conversion of nodetype definition:" + e.toString());
        }
    }

    public void close() throws IOException {
        if (this.nsWriter != null) {
            this.nsWriter.write("\n");
            this.out.close();
            this.nsWriter.write(((StringWriter)this.out).getBuffer().toString());
            this.out = this.nsWriter;
            this.nsWriter = null;
        }
        this.out.flush();
        this.out = null;
    }

    private void writeName(QNodeTypeDefinition ntd) throws IOException {
        this.out.write("[");
        this.out.write(this.resolve(ntd.getName()));
        this.out.write("]");
    }

    private void writeSupertypes(QNodeTypeDefinition ntd) throws IOException {
        TreeSet<Name> supertypes = new TreeSet<Name>();
        for (Name name : ntd.getSupertypes()) {
            if (name.equals(NameConstants.NT_BASE)) continue;
            supertypes.add(name);
        }
        if (!supertypes.isEmpty()) {
            String delim = " > ";
            for (Name name : supertypes) {
                this.out.write(delim);
                this.out.write(this.resolve(name));
                delim = ", ";
            }
        }
    }

    private void writeOptions(QNodeTypeDefinition ntd) throws IOException {
        LinkedList<String> options = new LinkedList<String>();
        if (ntd.isAbstract()) {
            options.add(Lexer.ABSTRACT[0]);
        }
        if (ntd.hasOrderableChildNodes()) {
            options.add(Lexer.ORDERABLE[0]);
        }
        if (ntd.isMixin()) {
            options.add(Lexer.MIXIN[0]);
        }
        if (!ntd.isQueryable()) {
            options.add(Lexer.NOQUERY[0]);
        }
        if (ntd.getPrimaryItemName() != null) {
            options.add(Lexer.PRIMARYITEM[0]);
            options.add(this.resolve(ntd.getPrimaryItemName()));
        }
        for (int i = 0; i < options.size(); ++i) {
            if (i == 0) {
                this.out.write("\n  ");
            } else {
                this.out.write(" ");
            }
            this.out.write((String)options.get(i));
        }
    }

    private void writePropDefs(QNodeTypeDefinition ntd) throws IOException {
        for (QPropertyDefinition pd : ntd.getPropertyDefs()) {
            this.writePropDef(pd);
        }
    }

    private void writeNodeDefs(QNodeTypeDefinition ntd) throws IOException {
        for (QNodeDefinition nd : ntd.getChildNodeDefs()) {
            this.writeNodeDef(nd);
        }
    }

    private void writePropDef(QPropertyDefinition pd) throws IOException {
        List<String> defaultOps;
        ArrayList<String> opts;
        String[] qops;
        this.out.write("\n  - ");
        Name name = pd.getName();
        if (name.equals(NameConstants.ANY_NAME)) {
            this.out.write(42);
        } else {
            this.writeItemDefName(name);
        }
        this.out.write(" (");
        this.out.write(PropertyType.nameFromValue((int)pd.getRequiredType()).toLowerCase());
        this.out.write(")");
        this.writeDefaultValues(pd.getDefaultValues());
        if (pd.isMandatory()) {
            this.out.write(" mandatory");
        }
        if (pd.isAutoCreated()) {
            this.out.write(" autocreated");
        }
        if (pd.isProtected()) {
            this.out.write(" protected");
        }
        if (pd.isMultiple()) {
            this.out.write(" multiple");
        }
        if (pd.getOnParentVersion() != 1) {
            this.out.write(" ");
            this.out.write(OnParentVersionAction.nameFromValue((int)pd.getOnParentVersion()).toLowerCase());
        }
        if (!pd.isFullTextSearchable()) {
            this.out.write(" nofulltext");
        }
        if (!pd.isQueryOrderable()) {
            this.out.write(" noqueryorder");
        }
        if ((qops = pd.getAvailableQueryOperators()) != null && qops.length > 0 && !(opts = new ArrayList<String>(Arrays.asList(qops))).containsAll(defaultOps = Arrays.asList(Operator.getAllQueryOperators()))) {
            this.out.write(" queryops '");
            String delim = "";
            for (String opt : opts) {
                this.out.write(delim);
                delim = ", ";
                if (opt.equals("jcr.operator.equal.to")) {
                    this.out.write("=");
                    continue;
                }
                if (opt.equals("jcr.operator.not.equal.to")) {
                    this.out.write("<>");
                    continue;
                }
                if (opt.equals("jcr.operator.greater.than")) {
                    this.out.write(">");
                    continue;
                }
                if (opt.equals("jcr.operator.greater.than.or.equal.to")) {
                    this.out.write(">=");
                    continue;
                }
                if (opt.equals("jcr.operator.less.than")) {
                    this.out.write("<");
                    continue;
                }
                if (opt.equals("jcr.operator.less.than.or.equal.to")) {
                    this.out.write("<=");
                    continue;
                }
                if (!opt.equals("jcr.operator.like")) continue;
                this.out.write("LIKE");
            }
            this.out.write("'");
        }
        this.writeValueConstraints(pd.getValueConstraints(), pd.getRequiredType());
    }

    private void writeDefaultValues(QValue[] dva) throws IOException {
        if (dva != null && dva.length > 0) {
            String delim = " = '";
            for (QValue value : dva) {
                this.out.write(delim);
                try {
                    String str = ValueFormat.getJCRString(value, this.npResolver);
                    this.out.write(this.escape(str));
                }
                catch (RepositoryException e) {
                    this.out.write(this.escape(value.toString()));
                }
                this.out.write("'");
                delim = ", '";
            }
        }
    }

    private void writeValueConstraints(QValueConstraint[] vca, int type) throws IOException {
        if (vca != null && vca.length > 0) {
            String vc = this.convertConstraint(vca[0], type);
            this.out.write(" < '");
            this.out.write(this.escape(vc));
            this.out.write("'");
            for (int i = 1; i < vca.length; ++i) {
                vc = this.convertConstraint(vca[i], type);
                this.out.write(", '");
                this.out.write(this.escape(vc));
                this.out.write("'");
            }
        }
    }

    private String convertConstraint(QValueConstraint vc, int type) {
        try {
            ValueConstraint c = ValueConstraint.create(type, vc.getString());
            return c.getDefinition(this.npResolver);
        }
        catch (InvalidConstraintException e) {
            return vc.getString();
        }
    }

    private void writeNodeDef(QNodeDefinition nd) throws IOException {
        this.out.write("\n  + ");
        Name name = nd.getName();
        if (name.equals(NameConstants.ANY_NAME)) {
            this.out.write(42);
        } else {
            this.writeItemDefName(name);
        }
        this.writeRequiredTypes(nd.getRequiredPrimaryTypes());
        this.writeDefaultType(nd.getDefaultPrimaryType());
        if (nd.isMandatory()) {
            this.out.write(" mandatory");
        }
        if (nd.isAutoCreated()) {
            this.out.write(" autocreated");
        }
        if (nd.isProtected()) {
            this.out.write(" protected");
        }
        if (nd.allowsSameNameSiblings()) {
            this.out.write(" multiple");
        }
        if (nd.getOnParentVersion() != 1) {
            this.out.write(" ");
            this.out.write(OnParentVersionAction.nameFromValue((int)nd.getOnParentVersion()).toLowerCase());
        }
    }

    private void writeItemDefName(Name name) throws IOException {
        this.out.write(this.resolve(name));
    }

    private void writeRequiredTypes(Name[] reqTypes) throws IOException {
        if (reqTypes != null && reqTypes.length > 0) {
            String delim = " (";
            for (Name reqType : reqTypes) {
                this.out.write(delim);
                this.out.write(this.resolve(reqType));
                delim = ", ";
            }
            this.out.write(")");
        }
    }

    private void writeDefaultType(Name defType) throws IOException {
        if (defType != null && !defType.getLocalName().equals("*")) {
            this.out.write(" = ");
            this.out.write(this.resolve(defType));
        }
    }

    private String resolve(Name name) throws IOException {
        if (name == null) {
            return "";
        }
        try {
            String prefix = this.resolver.getPrefix(name.getNamespaceURI());
            if (prefix != null && !prefix.equals("")) {
                if (this.nsWriter != null && !this.usedNamespaces.contains(prefix)) {
                    this.usedNamespaces.add(prefix);
                    this.nsWriter.write("<'");
                    this.nsWriter.write(prefix);
                    this.nsWriter.write("'='");
                    this.nsWriter.write(this.escape(name.getNamespaceURI()));
                    this.nsWriter.write("'>\n");
                }
                prefix = prefix + ":";
            }
            String encLocalName = ISO9075.encode(name.getLocalName());
            String resolvedName = prefix + encLocalName;
            if (resolvedName.indexOf(45) >= 0 || resolvedName.indexOf(43) >= 0) {
                return "'" + resolvedName + "'";
            }
            return resolvedName;
        }
        catch (NamespaceException e) {
            return name.toString();
        }
    }

    private String escape(String s) {
        StringBuffer sb = new StringBuffer(s);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) == '\\') {
                sb.insert(i, '\\');
                ++i;
                continue;
            }
            if (sb.charAt(i) != '\'') continue;
            sb.insert(i, '\'');
            ++i;
        }
        return sb.toString();
    }
}

