/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.token;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.jcr.Credentials;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenInfo;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sling-mock-oak.com.google.common.collect.ImmutableList;

public final class CompositeTokenProvider
implements TokenProvider {
    private final List<TokenProvider> providers;
    private static final TokenProvider NULL_PROVIDER = new TokenProvider(){

        @Override
        public boolean doCreateToken(@NotNull Credentials credentials) {
            return false;
        }

        @Override
        @Nullable
        public TokenInfo createToken(@NotNull Credentials credentials) {
            return null;
        }

        @Override
        @Nullable
        public TokenInfo createToken(@NotNull String userId, @NotNull Map<String, ?> attributes) {
            return null;
        }

        @Override
        @Nullable
        public TokenInfo getTokenInfo(@NotNull String token) {
            return null;
        }
    };

    private CompositeTokenProvider(@NotNull List<? extends TokenProvider> providers) {
        this.providers = ImmutableList.copyOf(providers);
    }

    @NotNull
    public static TokenProvider newInstance(TokenProvider ... providers) {
        return CompositeTokenProvider.newInstance(Arrays.asList(providers));
    }

    @NotNull
    public static TokenProvider newInstance(@NotNull List<? extends TokenProvider> providers) {
        switch (providers.size()) {
            case 0: {
                return NULL_PROVIDER;
            }
            case 1: {
                return providers.iterator().next();
            }
        }
        return new CompositeTokenProvider(providers);
    }

    @Override
    public boolean doCreateToken(@NotNull Credentials credentials) {
        for (TokenProvider tp : this.providers) {
            if (!tp.doCreateToken(credentials)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public TokenInfo createToken(@NotNull Credentials credentials) {
        for (TokenProvider tp : this.providers) {
            TokenInfo info = tp.createToken(credentials);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    @Override
    @Nullable
    public TokenInfo createToken(@NotNull String userId, @NotNull Map<String, ?> attributes) {
        for (TokenProvider tp : this.providers) {
            TokenInfo info = tp.createToken(userId, attributes);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    @Override
    @Nullable
    public TokenInfo getTokenInfo(@NotNull String token) {
        for (TokenProvider tp : this.providers) {
            TokenInfo info = tp.getTokenInfo(token);
            if (info == null) continue;
            return info;
        }
        return null;
    }
}

