/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.thumbnails.internal.transformers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.filters.ImageFilter;
import net.coobird.thumbnailator.filters.Transparency;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.thumbnails.BadRequestException;
import org.apache.sling.thumbnails.TransformationHandlerConfig;
import org.apache.sling.thumbnails.extension.TransformationHandler;
import org.osgi.service.component.annotations.Component;

@Component(service={TransformationHandler.class}, immediate=true)
public class TransparencyHandler
implements TransformationHandler {
    public static final String RESOURCE_TYPE = "sling/thumbnails/transformers/transparency";

    @Override
    public String getResourceType() {
        return RESOURCE_TYPE;
    }

    @Override
    public void handle(InputStream inputStream, OutputStream outputStream, TransformationHandlerConfig config) throws IOException {
        Thumbnails.Builder builder = Thumbnails.of((InputStream[])new InputStream[]{inputStream});
        ValueMap properties = config.getProperties();
        double alpha = (Double)properties.get("alpha", (Object)0.0);
        if (alpha < 0.0 || alpha > 1.0) {
            throw new BadRequestException("Unable to make transparent, bad alpha value " + alpha);
        }
        builder.addFilter((ImageFilter)new Transparency(alpha));
        builder.scale(1.0);
        builder.toOutputStream(outputStream);
    }
}

