/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.tracer.internal;

import ch.qos.logback.classic.Level;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.sling.commons.osgi.ManifestHeader;
import org.apache.sling.tracer.internal.CallerFilter;
import org.apache.sling.tracer.internal.CallerStackReporter;
import org.apache.sling.tracer.internal.PrefixExcludeFilter;
import org.apache.sling.tracer.internal.TracerConfig;

class TracerSet {
    public static final String LEVEL = "level";
    public static final String CALLER = "caller";
    public static final String CALLER_PREFIX_FILTER = "caller-exclude-filter";
    private final String name;
    private final List<TracerConfig> configs;

    public TracerSet(String config) {
        int indexOfColon = config.indexOf(58);
        if (indexOfColon == -1) {
            throw new IllegalArgumentException("Invalid tracer config format. TracerSet name cannot be determined " + config);
        }
        this.name = config.substring(0, indexOfColon).toLowerCase().trim();
        this.configs = TracerSet.parseTracerConfigs(config.substring(indexOfColon + 1));
    }

    public TracerSet(String name, String config) {
        this.name = name;
        this.configs = TracerSet.parseTracerConfigs(config);
    }

    public TracerConfig getConfig(String category) {
        for (TracerConfig tc : this.configs) {
            if (!tc.match(category)) continue;
            return tc;
        }
        return null;
    }

    public List<TracerConfig> getConfigs() {
        return this.configs;
    }

    public String getName() {
        return this.name;
    }

    private static List<TracerConfig> parseTracerConfigs(String config) {
        ManifestHeader parsedConfig = ManifestHeader.parse((String)config);
        ArrayList<TracerConfig> result = new ArrayList<TracerConfig>(parsedConfig.getEntries().length);
        for (ManifestHeader.Entry e : parsedConfig.getEntries()) {
            String category = e.getValue();
            Level level = Level.valueOf((String)e.getAttributeValue(LEVEL));
            CallerStackReporter reporter = TracerSet.createReporter(e);
            result.add(new TracerConfig(category, level, reporter));
        }
        return Collections.unmodifiableList(result);
    }

    static CallerStackReporter createReporter(ManifestHeader.Entry e) {
        int depth;
        String caller = e.getAttributeValue(CALLER);
        if (caller == null) {
            return null;
        }
        if ("true".equals(caller)) {
            return new CallerStackReporter(0, Integer.MAX_VALUE, CallerFilter.ALL);
        }
        CallerFilter filter = CallerFilter.ALL;
        try {
            depth = Integer.parseInt(caller);
        }
        catch (NumberFormatException ignore) {
            return null;
        }
        String filterValue = e.getAttributeValue(CALLER_PREFIX_FILTER);
        if (filterValue != null) {
            filter = PrefixExcludeFilter.from(filterValue);
        }
        return new CallerStackReporter(0, depth, filter);
    }
}

