/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.html;

import java.io.File;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;
import org.owasp.validator.html.scan.AntiSamyDOMScanner;
import org.owasp.validator.html.scan.AntiSamySAXScanner;

public class AntiSamy {
    public static int DOM = 0;
    public static int SAX = 1;
    private Policy policy = null;

    public AntiSamy() {
    }

    public AntiSamy(Policy policy) {
        this.policy = policy;
    }

    public CleanResults scan(String taintedHTML) throws ScanException, PolicyException {
        if (this.policy == null) {
            throw new PolicyException("No policy loaded");
        }
        return this.scan(taintedHTML, this.policy, SAX);
    }

    public CleanResults scan(String taintedHTML, int scanType) throws ScanException, PolicyException {
        if (this.policy == null) {
            throw new PolicyException("No policy loaded");
        }
        return this.scan(taintedHTML, this.policy, scanType);
    }

    public CleanResults scan(String taintedHTML, Policy policy) throws ScanException, PolicyException {
        return new AntiSamyDOMScanner(policy).scan(taintedHTML);
    }

    public CleanResults scan(String taintedHTML, Policy policy, int scanType) throws ScanException, PolicyException {
        if (scanType == DOM) {
            return new AntiSamyDOMScanner(policy).scan(taintedHTML);
        }
        return new AntiSamySAXScanner(policy).scan(taintedHTML);
    }

    public CleanResults scan(String taintedHTML, String filename) throws ScanException, PolicyException {
        Policy policy = Policy.getInstance(filename);
        return this.scan(taintedHTML, policy);
    }

    public CleanResults scan(String taintedHTML, File policyFile) throws ScanException, PolicyException {
        Policy policy = Policy.getInstance(policyFile);
        return this.scan(taintedHTML, policy);
    }
}

