/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client.spring;

import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import org.apache.cxf.common.util.ClasspathScanner;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.client.spring.AbstractJaxRsClientConfiguration;
import org.apache.cxf.jaxrs.client.spring.JAXRSClientFactoryBeanDefinitionParser;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;

public class JaxRsWebClientConfiguration
extends AbstractJaxRsClientConfiguration {
    @Value(value="${cxf.jaxrs.client.classes-scan-packages:}")
    private String scanPackages;

    @Bean
    protected Client jaxRsWebClient() {
        return super.createClient();
    }

    @Override
    protected void setJaxrsResources(JAXRSClientFactoryBean factory) {
        factory.setServiceClass(WebClient.class);
        if (!StringUtils.isEmpty(this.scanPackages)) {
            try {
                Map<Class<Annotation>, Collection<Class<?>>> classes = ClasspathScanner.findClasses(this.scanPackages, Provider.class);
                factory.setProviders(JAXRSClientFactoryBeanDefinitionParser.getProviders(this.context, classes.get(Provider.class)));
            }
            catch (Exception ex) {
                throw new ServiceConstructionException(ex);
            }
        }
    }
}

