/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog.parser.jdom;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Attribute;
import org.jdom2.Comment;
import org.jdom2.DataConversionException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.CollectionType;
import thredds.catalog.DataFormatType;
import thredds.catalog.DataRootConfig;
import thredds.catalog.InvAccess;
import thredds.catalog.InvAccessImpl;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogConvertIF;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetFeatureCollection;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDatasetImplProxy;
import thredds.catalog.InvDatasetScan;
import thredds.catalog.InvDocumentation;
import thredds.catalog.InvMetadata;
import thredds.catalog.InvProperty;
import thredds.catalog.InvService;
import thredds.catalog.MetadataConverterIF;
import thredds.catalog.MetadataType;
import thredds.catalog.ThreddsMetadata;
import thredds.catalog.parser.jdom.FeatureCollectionReader;
import thredds.cataloggen.CatalogRefExpander;
import thredds.cataloggen.DatasetEnhancer;
import thredds.cataloggen.ProxyDatasetHandler;
import thredds.cataloggen.datasetenhancer.RegExpAndDurationTimeCoverageEnhancer;
import thredds.cataloggen.inserter.LatestCompleteProxyDsHandler;
import thredds.cataloggen.inserter.SimpleLatestProxyDsHandler;
import thredds.crawlabledataset.CrawlableDatasetFilter;
import thredds.crawlabledataset.CrawlableDatasetLabeler;
import thredds.crawlabledataset.CrawlableDatasetSorter;
import thredds.crawlabledataset.MultiLabeler;
import thredds.crawlabledataset.RegExpAndReplaceOnNameLabeler;
import thredds.crawlabledataset.RegExpAndReplaceOnPathLabeler;
import thredds.crawlabledataset.filter.LastModifiedLimitFilter;
import thredds.crawlabledataset.filter.LogicalFilterComposer;
import thredds.crawlabledataset.filter.MultiSelectorFilter;
import thredds.crawlabledataset.filter.RegExpMatchOnNameFilter;
import thredds.crawlabledataset.filter.WildcardMatchOnNameFilter;
import thredds.crawlabledataset.sorter.LexigraphicByNameSorter;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.util.PathAliasReplacement;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;
import ucar.unidata.util.Format;

public class InvCatalogFactory10
implements InvCatalogConvertIF,
MetadataConverterIF {
    private static Logger logger = LoggerFactory.getLogger(InvCatalogFactory10.class);
    public static final Namespace defNS = Namespace.getNamespace("http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0");
    public static final Namespace xlinkNS = Namespace.getNamespace("xlink", "http://www.w3.org/1999/xlink");
    public static final Namespace ncmlNS = Namespace.getNamespace("ncml", "http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2");
    private static boolean useBytesForDataSize = false;
    private InvCatalogFactory factory = null;
    private String version = "1.0.1";
    private boolean debugMetadataRead = false;
    private List<PathAliasReplacement> dataRootLocAliasExpanders = Collections.emptyList();
    private Map<MetadataType, MetadataConverterIF> metadataHash = new HashMap<MetadataType, MetadataConverterIF>(10);
    private SAXBuilder saxBuilder;
    private boolean raw = false;

    public static void useBytesForDataSize(boolean b) {
        useBytesForDataSize = b;
    }

    public void setDataRootLocationAliasExpanders(List<PathAliasReplacement> dataRootLocAliasExpanders) {
        this.dataRootLocAliasExpanders = dataRootLocAliasExpanders == null ? Collections.emptyList() : new ArrayList<PathAliasReplacement>(dataRootLocAliasExpanders);
    }

    public List<PathAliasReplacement> getDataRootLocationAliasExpanders() {
        return Collections.unmodifiableList(this.dataRootLocAliasExpanders);
    }

    private String expandAliasForPath(String location) {
        for (PathAliasReplacement par : this.dataRootLocAliasExpanders) {
            if (!par.containsPathAlias(location)) continue;
            return par.replacePathAlias(location);
        }
        return location;
    }

    private String expandAliasForCollectionSpec(String location) {
        for (PathAliasReplacement par : this.dataRootLocAliasExpanders) {
            String result = par.replaceIfMatch(location);
            if (result == null) continue;
            return result;
        }
        return location;
    }

    @Override
    public InvCatalogImpl parseXML(InvCatalogFactory fac, Document jdomDoc, URI uri) {
        this.factory = fac;
        return this.readCatalog(jdomDoc.getRootElement(), uri);
    }

    public void registerMetadataConverter(MetadataType type, MetadataConverterIF converter) {
        this.metadataHash.put(type, converter);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    protected InvAccessImpl readAccess(InvDatasetImpl dataset, Element accessElem) {
        String urlPath = accessElem.getAttributeValue("urlPath");
        String serviceName = accessElem.getAttributeValue("serviceName");
        String dataFormat = accessElem.getAttributeValue("dataFormat");
        return new InvAccessImpl(dataset, urlPath, serviceName, null, dataFormat, this.readDataSize(accessElem));
    }

    protected InvCatalogImpl readCatalog(Element catalogElem, URI docBaseURI) {
        String name = catalogElem.getAttributeValue("name");
        String catSpecifiedBaseURL = catalogElem.getAttributeValue("base");
        String expires = catalogElem.getAttributeValue("expires");
        String version = catalogElem.getAttributeValue("version");
        URI baseURI = docBaseURI;
        if (catSpecifiedBaseURL != null) {
            try {
                baseURI = new URI(catSpecifiedBaseURL);
            }
            catch (URISyntaxException e) {
                logger.debug("readCatalog(): bad catalog specified base URI <" + catSpecifiedBaseURL + ">: " + e.getMessage(), e);
                baseURI = docBaseURI;
            }
        }
        InvCatalogImpl catalog = new InvCatalogImpl(name, version, this.makeDateType(expires, null, null), baseURI);
        List<Element> sList = catalogElem.getChildren("service", defNS);
        for (Element e : sList) {
            InvService s = this.readService(e, baseURI);
            catalog.addService(s);
        }
        List<Element> pList = catalogElem.getChildren("property", defNS);
        for (Element e : pList) {
            InvProperty s = this.readProperty(e);
            catalog.addProperty(s);
        }
        List<Element> rootList = catalogElem.getChildren("datasetRoot", defNS);
        for (Element e : rootList) {
            DataRootConfig root = this.readDatasetRoot(e);
            catalog.addDatasetRoot(root);
        }
        List<Element> allChildren = catalogElem.getChildren();
        for (Element e : allChildren) {
            if (e.getName().equals("dataset")) {
                catalog.addDataset(this.readDataset(catalog, null, e, baseURI));
                continue;
            }
            if (e.getName().equals("featureCollection")) {
                catalog.addDataset(this.readFeatureCollection(catalog, null, e, baseURI));
                continue;
            }
            if (e.getName().equals("datasetScan")) {
                catalog.addDataset(this.readDatasetScan(catalog, null, e, baseURI));
                continue;
            }
            if (!e.getName().equals("catalogRef")) continue;
            catalog.addDataset(this.readCatalogRef(catalog, null, e, baseURI));
        }
        return catalog;
    }

    protected InvCatalogRef readCatalogRef(InvCatalogImpl cat, InvDatasetImpl parent, Element catRefElem, URI baseURI) {
        String title = catRefElem.getAttributeValue("title", xlinkNS);
        if (title == null) {
            title = catRefElem.getAttributeValue("name");
        }
        String href = catRefElem.getAttributeValue("href", xlinkNS);
        String useRemCatSerStr = catRefElem.getAttributeValue("useRemoteCatalogService");
        Boolean useRemoteCatalogService = null;
        if (useRemCatSerStr != null) {
            useRemoteCatalogService = Boolean.parseBoolean(useRemCatSerStr);
        }
        InvCatalogRef catRef = new InvCatalogRef(parent, title, href, useRemoteCatalogService);
        this.readDatasetInfo(cat, catRef, catRefElem, baseURI);
        return catRef;
    }

    protected ThreddsMetadata.Contributor readContributor(Element elem) {
        if (elem == null) {
            return null;
        }
        return new ThreddsMetadata.Contributor(elem.getText(), elem.getAttributeValue("role"));
    }

    protected ThreddsMetadata.Vocab readControlledVocabulary(Element elem) {
        if (elem == null) {
            return null;
        }
        return new ThreddsMetadata.Vocab(elem.getText(), elem.getAttributeValue("vocabulary"));
    }

    protected InvDatasetImpl readDataset(InvCatalogImpl catalog, InvDatasetImpl parent, Element dsElem, URI base) {
        String name = dsElem.getAttributeValue("name");
        String alias = dsElem.getAttributeValue("alias");
        if (alias != null) {
            InvDatasetImpl ds = (InvDatasetImpl)catalog.findDatasetByID(alias);
            if (ds == null) {
                this.factory.appendErr(" ** Parse error: dataset named " + name + " has illegal alias = " + alias + "\n");
                return null;
            }
            return new InvDatasetImplProxy(name, ds);
        }
        InvDatasetImpl dataset = new InvDatasetImpl(parent, name);
        this.readDatasetInfo(catalog, dataset, dsElem, base);
        if (InvCatalogFactory.debugXML) {
            System.out.println(" Dataset added: " + dataset.dump());
        }
        return dataset;
    }

    protected void readDatasetInfo(InvCatalogImpl catalog, InvDatasetImpl dataset, Element dsElem, URI base) {
        String authority = dsElem.getAttributeValue("authority");
        String collectionTypeName = dsElem.getAttributeValue("collectionType");
        String dataTypeName = dsElem.getAttributeValue("dataType");
        String harvest = dsElem.getAttributeValue("harvest");
        String id = dsElem.getAttributeValue("ID");
        String serviceName = dsElem.getAttributeValue("serviceName");
        String urlPath = dsElem.getAttributeValue("urlPath");
        String restrictAccess = dsElem.getAttributeValue("restrictAccess");
        FeatureType dataType = null;
        if (dataTypeName != null && (dataType = FeatureType.getType(dataTypeName.toUpperCase())) == null) {
            this.factory.appendWarning(" ** warning: non-standard data type = " + dataTypeName + "\n");
        }
        if (dataType != null) {
            dataset.setDataType(dataType);
        }
        if (serviceName != null) {
            dataset.setServiceName(serviceName);
        }
        if (urlPath != null) {
            dataset.setUrlPath(urlPath);
        }
        if (authority != null) {
            dataset.setAuthority(authority);
        }
        if (id != null) {
            dataset.setID(id);
        }
        if (harvest != null) {
            dataset.setHarvest(harvest.equalsIgnoreCase("true"));
        }
        if (restrictAccess != null) {
            dataset.setResourceControl(restrictAccess);
        }
        if (collectionTypeName != null) {
            CollectionType collectionType = CollectionType.findType(collectionTypeName);
            if (collectionType == null) {
                collectionType = CollectionType.getType(collectionTypeName);
                this.factory.appendWarning(" ** warning: non-standard collection type = " + collectionTypeName + "\n");
            }
            dataset.setCollectionType(collectionType);
        }
        catalog.addDatasetByID(dataset);
        List<Element> serviceList = dsElem.getChildren("service", defNS);
        for (Element curElem : serviceList) {
            InvService s = this.readService(curElem, base);
            dataset.addService(s);
        }
        ThreddsMetadata tmg = dataset.getLocalMetadata();
        this.readThreddsMetadata(catalog, dataset, dsElem, tmg);
        List<Element> aList = dsElem.getChildren("access", defNS);
        for (Element e : aList) {
            InvAccessImpl a = this.readAccess(dataset, e);
            dataset.addAccess(a);
        }
        Element ncmlElem = dsElem.getChild("netcdf", ncmlNS);
        if (ncmlElem != null) {
            ncmlElem.detach();
            dataset.setNcmlElement(ncmlElem);
        }
        List<Element> allChildren = dsElem.getChildren();
        for (Element e : allChildren) {
            InvDatasetImpl ds;
            if (e.getName().equals("dataset")) {
                ds = this.readDataset(catalog, dataset, e, base);
                if (ds == null) continue;
                dataset.addDataset(ds);
                continue;
            }
            if (e.getName().equals("catalogRef")) {
                ds = this.readCatalogRef(catalog, dataset, e, base);
                dataset.addDataset(ds);
                continue;
            }
            if (e.getName().equals("datasetScan")) {
                dataset.addDataset(this.readDatasetScan(catalog, dataset, e, base));
                continue;
            }
            if (!e.getName().equals("featureCollection") || (ds = this.readFeatureCollection(catalog, dataset, e, base)) == null) continue;
            dataset.addDataset(ds);
        }
    }

    protected InvDatasetImpl readFeatureCollection(InvCatalogImpl catalog, InvDatasetImpl parent, Element dsElem, URI base) {
        FeatureCollectionConfig config = FeatureCollectionReader.readFeatureCollection(dsElem);
        config.spec = this.expandAliasForCollectionSpec(config.spec);
        try {
            InvDatasetFeatureCollection ds = InvDatasetFeatureCollection.factory(parent, config.name, config.path, config.type, config);
            if (ds == null) {
                logger.error("featureCollection " + config.name + " has fatal error ");
                return null;
            }
            this.readDatasetInfo(catalog, ds, dsElem, base);
            return ds;
        }
        catch (Exception e) {
            logger.error("featureCollection " + config.name + " has fatal error, skipping ", e);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected InvDatasetScan readDatasetScan(InvCatalogImpl catalog, InvDatasetImpl parent, Element dsElem, URI base) {
        int last;
        if (dsElem.getAttributeValue("dirLocation") == null) {
            if (dsElem.getAttributeValue("location") != null) return this.readDatasetScanNew(catalog, parent, dsElem, base);
            logger.error("readDatasetScan(): datasetScan has neither a \"location\" nor a \"dirLocation\" attribute.");
            return null;
        }
        String name = dsElem.getAttributeValue("name");
        this.factory.appendWarning("**Warning: Dataset " + name + " using old form of DatasetScan (dirLocation instead of location)\n");
        String path = dsElem.getAttributeValue("path");
        String scanDir = this.expandAliasForPath(dsElem.getAttributeValue("dirLocation"));
        String filter = dsElem.getAttributeValue("filter");
        String addDatasetSizeString = dsElem.getAttributeValue("addDatasetSize");
        String addLatest = dsElem.getAttributeValue("addLatest");
        String sortOrderIncreasingString = dsElem.getAttributeValue("sortOrderIncreasing");
        boolean sortOrderIncreasing = false;
        if (sortOrderIncreasingString != null && sortOrderIncreasingString.equalsIgnoreCase("true")) {
            sortOrderIncreasing = true;
        }
        boolean addDatasetSize = true;
        if (addDatasetSizeString != null && addDatasetSizeString.equalsIgnoreCase("false")) {
            addDatasetSize = false;
        }
        if (path != null) {
            if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            if (path.charAt(last = path.length() - 1) == '/') {
                path = path.substring(0, last);
            }
        }
        if (scanDir != null && scanDir.charAt(last = scanDir.length() - 1) != '/') {
            scanDir = scanDir + '/';
        }
        Element atcElem = dsElem.getChild("addTimeCoverage", defNS);
        String dsNameMatchPattern = null;
        String startTimeSubstitutionPattern = null;
        String duration = null;
        if (atcElem != null) {
            dsNameMatchPattern = atcElem.getAttributeValue("datasetNameMatchPattern");
            startTimeSubstitutionPattern = atcElem.getAttributeValue("startTimeSubstitutionPattern");
            duration = atcElem.getAttributeValue("duration");
        }
        try {
            InvDatasetScan datasetScan = new InvDatasetScan(catalog, parent, name, path, scanDir, filter, addDatasetSize, addLatest, sortOrderIncreasing, dsNameMatchPattern, startTimeSubstitutionPattern, duration);
            this.readDatasetInfo(catalog, datasetScan, dsElem, base);
            if (!InvCatalogFactory.debugXML) return datasetScan;
            System.out.println(" Dataset added: " + datasetScan.dump());
            return datasetScan;
        }
        catch (Exception e) {
            logger.error("Reading DatasetScan", e);
            return null;
        }
    }

    protected InvDatasetScan readDatasetScanNew(InvCatalogImpl catalog, InvDatasetImpl parent, Element dsElem, URI base) {
        InvDatasetScan datasetScan;
        DatasetEnhancer addTimeCovEnhancer;
        String name = dsElem.getAttributeValue("name");
        String path = dsElem.getAttributeValue("path");
        String scanDir = this.expandAliasForPath(dsElem.getAttributeValue("location"));
        String configClassName = null;
        Element configObj = null;
        Element dsConfigElem = dsElem.getChild("crawlableDatasetImpl", defNS);
        if (dsConfigElem != null) {
            configClassName = dsConfigElem.getAttributeValue("className");
            List<Element> children = dsConfigElem.getChildren();
            if (children.size() == 1) {
                configObj = children.get(0);
            } else if (children.size() != 0) {
                logger.warn("readDatasetScanNew(): content of datasetConfig element not a single element, using first element.");
                configObj = children.get(0);
            } else {
                logger.debug("readDatasetScanNew(): datasetConfig element has no children.");
                configObj = null;
            }
        }
        Element filterElem = dsElem.getChild("filter", defNS);
        CrawlableDatasetFilter filter = null;
        if (filterElem != null) {
            filter = this.readDatasetScanFilter(filterElem);
        }
        Element identifierElem = dsElem.getChild("addID", defNS);
        CrawlableDatasetLabeler identifier = null;
        if (identifierElem != null) {
            identifier = this.readDatasetScanIdentifier(identifierElem);
        }
        Element namerElem = dsElem.getChild("namer", defNS);
        CrawlableDatasetLabeler namer = null;
        if (namerElem != null) {
            namer = this.readDatasetScanNamer(namerElem);
        }
        Element sorterElem = dsElem.getChild("sort", defNS);
        CrawlableDatasetSorter sorter = new LexigraphicByNameSorter(false);
        if (sorterElem != null) {
            sorter = this.readDatasetScanSorter(sorterElem);
        }
        Element addLatestElem = dsElem.getChild("addLatest", defNS);
        Element addProxiesElem = dsElem.getChild("addProxies", defNS);
        Map<Object, Object> allProxyDsHandlers = addLatestElem != null || addProxiesElem != null ? this.readDatasetScanAddProxies(addProxiesElem, addLatestElem, catalog) : new HashMap();
        Element addDsSizeElem = dsElem.getChild("addDatasetSize", defNS);
        boolean addDatasetSize = true;
        if (addDsSizeElem != null && addDsSizeElem.getTextNormalize().equalsIgnoreCase("false")) {
            addDatasetSize = false;
        }
        ArrayList<DatasetEnhancer> childEnhancerList = new ArrayList<DatasetEnhancer>();
        Element addTimeCovElem = dsElem.getChild("addTimeCoverage", defNS);
        if (addTimeCovElem != null && (addTimeCovEnhancer = this.readDatasetScanAddTimeCoverage(addTimeCovElem)) != null) {
            childEnhancerList.add(addTimeCovEnhancer);
        }
        List<Element> dsEnhancerElemList = dsElem.getChildren("datasetEnhancerImpl", defNS);
        for (Element elem : dsEnhancerElemList) {
            DatasetEnhancer o = this.readDatasetScanUserDefined(elem, DatasetEnhancer.class);
            if (o == null) continue;
            childEnhancerList.add(o);
        }
        CatalogRefExpander catalogRefExpander = null;
        try {
            datasetScan = new InvDatasetScan(parent, name, path, scanDir, configClassName, configObj, filter, identifier, namer, addDatasetSize, sorter, allProxyDsHandlers, childEnhancerList, catalogRefExpander);
            this.readDatasetInfo(catalog, datasetScan, dsElem, base);
            if (InvCatalogFactory.debugXML) {
                System.out.println(" Dataset added: " + datasetScan.dump());
            }
        }
        catch (Exception e) {
            logger.error("readDatasetScanNew(): failed to create DatasetScan", e);
            datasetScan = null;
        }
        return datasetScan;
    }

    CrawlableDatasetFilter readDatasetScanFilter(Element filterElem) {
        CrawlableDatasetFilter filter = null;
        Attribute lastModLimitAtt = filterElem.getAttribute("lastModifiedLimit");
        if (lastModLimitAtt != null) {
            long lastModLimit;
            try {
                lastModLimit = lastModLimitAtt.getLongValue();
            }
            catch (DataConversionException e) {
                String tmpMsg = "readDatasetScanFilter(): bad lastModifedLimit value <" + lastModLimitAtt.getValue() + ">, couldn't parse into long: " + e.getMessage();
                this.factory.appendErr(tmpMsg);
                logger.warn(tmpMsg);
                return null;
            }
            return new LastModifiedLimitFilter(lastModLimit);
        }
        String compType = filterElem.getAttributeValue("logicalComp");
        if (compType != null) {
            List<Element> filters = filterElem.getChildren("filter", defNS);
            if (compType.equalsIgnoreCase("AND")) {
                if (filters.size() != 2) {
                    String tmpMsg = "readDatasetScanFilter(): wrong number of filters <" + filters.size() + "> for AND (2 expected).";
                    this.factory.appendErr(tmpMsg);
                    logger.warn(tmpMsg);
                    return null;
                }
                filter = LogicalFilterComposer.getAndFilter(this.readDatasetScanFilter(filters.get(0)), this.readDatasetScanFilter(filters.get(1)));
            } else if (compType.equalsIgnoreCase("OR")) {
                if (filters.size() != 2) {
                    String tmpMsg = "readDatasetScanFilter(): wrong number of filters <" + filters.size() + "> for OR (2 expected).";
                    this.factory.appendErr(tmpMsg);
                    logger.warn(tmpMsg);
                    return null;
                }
                filter = LogicalFilterComposer.getOrFilter(this.readDatasetScanFilter(filters.get(0)), this.readDatasetScanFilter(filters.get(1)));
            } else if (compType.equalsIgnoreCase("NOT")) {
                if (filters.size() != 1) {
                    String tmpMsg = "readDatasetScanFilter(): wrong number of filters <" + filters.size() + "> for NOT (1 expected).";
                    this.factory.appendErr(tmpMsg);
                    logger.warn(tmpMsg);
                    return null;
                }
                filter = LogicalFilterComposer.getNotFilter(this.readDatasetScanFilter(filters.get(0)));
            }
            return filter;
        }
        Element userDefElem = filterElem.getChild("crawlableDatasetFilterImpl", defNS);
        if (userDefElem != null) {
            filter = (CrawlableDatasetFilter)((Object)this.readDatasetScanUserDefined(userDefElem, CrawlableDatasetFilter.class));
        } else {
            ArrayList<MultiSelectorFilter.Selector> selectorList = new ArrayList<MultiSelectorFilter.Selector>();
            for (Element curElem : filterElem.getChildren()) {
                String regExpAttVal = curElem.getAttributeValue("regExp");
                String wildcardAttVal = curElem.getAttributeValue("wildcard");
                String lastModLimitAttVal = curElem.getAttributeValue("lastModLimitInMillis");
                if (regExpAttVal == null && wildcardAttVal == null && lastModLimitAttVal == null) {
                    logger.warn("readDatasetScanFilter(): no regExp, wildcard, or lastModLimitInMillis attribute in filter child <" + curElem.getName() + ">.");
                    continue;
                }
                boolean atomic = true;
                String atomicAttVal = curElem.getAttributeValue("atomic");
                if (atomicAttVal != null && !atomicAttVal.equalsIgnoreCase("true")) {
                    atomic = false;
                }
                boolean collection = false;
                String collectionAttVal = curElem.getAttributeValue("collection");
                if (collectionAttVal != null && !collectionAttVal.equalsIgnoreCase("false")) {
                    collection = true;
                }
                boolean includer = true;
                if (curElem.getName().equals("exclude")) {
                    includer = false;
                } else if (!curElem.getName().equals("include")) {
                    logger.warn("readDatasetScanFilter(): unhandled filter child <" + curElem.getName() + ">.");
                    continue;
                }
                if (regExpAttVal != null) {
                    selectorList.add(new MultiSelectorFilter.Selector(new RegExpMatchOnNameFilter(regExpAttVal), includer, atomic, collection));
                    continue;
                }
                if (wildcardAttVal != null) {
                    selectorList.add(new MultiSelectorFilter.Selector(new WildcardMatchOnNameFilter(wildcardAttVal), includer, atomic, collection));
                    continue;
                }
                if (lastModLimitAttVal == null) continue;
                selectorList.add(new MultiSelectorFilter.Selector(new LastModifiedLimitFilter(Long.parseLong(lastModLimitAttVal)), includer, atomic, collection));
            }
            filter = new MultiSelectorFilter(selectorList);
        }
        return filter;
    }

    protected CrawlableDatasetLabeler readDatasetScanIdentifier(Element identifierElem) {
        Element userDefElem = identifierElem.getChild("crawlableDatasetLabelerImpl", defNS);
        if (userDefElem == null) {
            return null;
        }
        CrawlableDatasetLabeler identifier = (CrawlableDatasetLabeler)((Object)this.readDatasetScanUserDefined(userDefElem, CrawlableDatasetLabeler.class));
        return identifier;
    }

    protected CrawlableDatasetLabeler readDatasetScanNamer(Element namerElem) {
        ArrayList<CrawlableDatasetLabeler> labelerList = new ArrayList<CrawlableDatasetLabeler>();
        for (Element curElem : namerElem.getChildren()) {
            CrawlableDatasetLabeler curLabeler;
            String regExp = curElem.getAttributeValue("regExp");
            String replaceString = curElem.getAttributeValue("replaceString");
            if (curElem.getName().equals("regExpOnName")) {
                curLabeler = new RegExpAndReplaceOnNameLabeler(regExp, replaceString);
            } else if (curElem.getName().equals("regExpOnPath")) {
                curLabeler = new RegExpAndReplaceOnPathLabeler(regExp, replaceString);
            } else {
                logger.warn("readDatasetScanNamer(): unhandled namer child <" + curElem.getName() + ">.");
                continue;
            }
            labelerList.add(curLabeler);
        }
        MultiLabeler namer = new MultiLabeler(labelerList);
        return namer;
    }

    protected CrawlableDatasetSorter readDatasetScanSorter(Element sorterElem) {
        CrawlableDatasetSorter sorter = null;
        Element userDefElem = sorterElem.getChild("crawlableDatasetSorterImpl", defNS);
        if (userDefElem != null) {
            sorter = (CrawlableDatasetSorter)((Object)this.readDatasetScanUserDefined(userDefElem, CrawlableDatasetSorter.class));
        } else {
            Element lexSortElem = sorterElem.getChild("lexigraphicByName", defNS);
            if (lexSortElem != null) {
                String increasingString = lexSortElem.getAttributeValue("increasing");
                boolean increasing = increasingString.equalsIgnoreCase("true");
                sorter = new LexigraphicByNameSorter(increasing);
            }
        }
        return sorter;
    }

    protected Map<String, ProxyDatasetHandler> readDatasetScanAddProxies(Element addProxiesElem, Element addLatestElem, InvCatalogImpl catalog) {
        Element simpleLatestElem;
        ProxyDatasetHandler pdh;
        HashMap<String, ProxyDatasetHandler> allProxyDsHandlers = new HashMap<String, ProxyDatasetHandler>();
        if (addLatestElem != null && (pdh = this.readDatasetScanAddLatest(simpleLatestElem = addLatestElem.getChild("simpleLatest", defNS), catalog)) != null) {
            allProxyDsHandlers.put(pdh.getProxyDatasetName(), pdh);
        }
        if (addProxiesElem != null) {
            for (Element curChildElem : addProxiesElem.getChildren()) {
                ProxyDatasetHandler curPdh;
                if (curChildElem.getName().equals("simpleLatest") && curChildElem.getNamespace().equals(defNS)) {
                    curPdh = this.readDatasetScanAddLatest(curChildElem, catalog);
                } else if (curChildElem.getName().equals("latestComplete") && curChildElem.getNamespace().equals(defNS)) {
                    String serviceName;
                    String latestName = curChildElem.getAttributeValue("name");
                    if (latestName == null) {
                        logger.warn("readDatasetScanAddProxies(): unnamed latestComplete, skipping.");
                        continue;
                    }
                    Attribute topAtt = curChildElem.getAttribute("top");
                    boolean latestOnTop = true;
                    if (topAtt != null) {
                        try {
                            latestOnTop = topAtt.getBooleanValue();
                        }
                        catch (DataConversionException e) {
                            latestOnTop = true;
                        }
                    }
                    if ((serviceName = curChildElem.getAttributeValue("serviceName")) == null) {
                        logger.warn("readDatasetScanAddProxies(): no service name given in latestComplete.");
                        continue;
                    }
                    InvService service = catalog.findService(serviceName);
                    if (service == null) {
                        logger.warn("readDatasetScanAddProxies(): named service <" + serviceName + "> not found.");
                        continue;
                    }
                    String lastModLimitVal = curChildElem.getAttributeValue("lastModifiedLimit");
                    long lastModLimit = lastModLimitVal == null ? 60L : Long.parseLong(lastModLimitVal);
                    String isResolverString = curChildElem.getAttributeValue("isResolver");
                    boolean isResolver = true;
                    if (isResolverString != null && isResolverString.equalsIgnoreCase("false")) {
                        isResolver = false;
                    }
                    curPdh = new LatestCompleteProxyDsHandler(latestName, latestOnTop, service, isResolver, lastModLimit);
                } else {
                    curPdh = null;
                }
                if (curPdh == null) continue;
                if (allProxyDsHandlers.containsKey(curPdh.getProxyDatasetName())) {
                    logger.warn("readDatasetScanAddProxies(): proxy map already contains key <" + curPdh.getProxyDatasetName() + ">, skipping.");
                    continue;
                }
                allProxyDsHandlers.put(curPdh.getProxyDatasetName(), curPdh);
            }
        }
        return allProxyDsHandlers;
    }

    private ProxyDatasetHandler readDatasetScanAddLatest(Element simpleLatestElem, InvCatalogImpl catalog) {
        InvService service;
        SimpleLatestProxyDsHandler latestAdder = null;
        String latestName = "latest.xml";
        boolean latestOnTop = true;
        String latestServiceName = "latest";
        boolean isResolver = true;
        if (simpleLatestElem != null) {
            String isResolverString;
            String tmpLatestServiceName;
            Attribute topAtt;
            String tmpLatestName = simpleLatestElem.getAttributeValue("name");
            if (tmpLatestName != null) {
                latestName = tmpLatestName;
            }
            if ((topAtt = simpleLatestElem.getAttribute("top")) != null) {
                try {
                    latestOnTop = topAtt.getBooleanValue();
                }
                catch (DataConversionException e) {
                    latestOnTop = true;
                }
            }
            if ((tmpLatestServiceName = simpleLatestElem.getAttributeValue("serviceName")) != null) {
                latestServiceName = tmpLatestServiceName;
            }
            if ((isResolverString = simpleLatestElem.getAttributeValue("isResolver")) != null && isResolverString.equalsIgnoreCase("false")) {
                isResolver = false;
            }
        }
        if ((service = catalog.findService(latestServiceName)) == null) {
            logger.warn("readDatasetScanAddLatest(): named service <" + latestServiceName + "> not found.");
        } else {
            latestAdder = new SimpleLatestProxyDsHandler(latestName, latestOnTop, service, isResolver);
        }
        return latestAdder;
    }

    protected DatasetEnhancer readDatasetScanAddTimeCoverage(Element addTimeCovElem) {
        RegExpAndDurationTimeCoverageEnhancer timeCovEnhancer = null;
        String matchName = addTimeCovElem.getAttributeValue("datasetNameMatchPattern");
        String matchPath = addTimeCovElem.getAttributeValue("datasetPathMatchPattern");
        String subst = addTimeCovElem.getAttributeValue("startTimeSubstitutionPattern");
        String duration = addTimeCovElem.getAttributeValue("duration");
        if (matchName != null && subst != null && duration != null) {
            timeCovEnhancer = RegExpAndDurationTimeCoverageEnhancer.getInstanceToMatchOnDatasetName(matchName, subst, duration);
        } else if (matchPath != null && subst != null && duration != null) {
            timeCovEnhancer = RegExpAndDurationTimeCoverageEnhancer.getInstanceToMatchOnDatasetPath(matchPath, subst, duration);
        }
        return timeCovEnhancer;
    }

    private DatasetEnhancer readDatasetScanUserDefined(Element userDefElem, Class targetClass) {
        Element configElem;
        String className = userDefElem.getAttributeValue("className");
        List<Element> childrenElemList = userDefElem.getChildren();
        if (childrenElemList.size() == 1) {
            configElem = childrenElemList.get(0);
        } else if (childrenElemList.size() != 0) {
            logger.warn("readDatasetScanUserDefined(): config XML not a single element, using first element.");
            configElem = childrenElemList.get(0);
        } else {
            logger.debug("readDatasetScanUserDefined(): no config XML elements.");
            configElem = null;
        }
        try {
            Class<?> requestedClass = Class.forName(className);
            if (!targetClass.isAssignableFrom(requestedClass)) {
                throw new IllegalArgumentException("Requested class <" + className + "> not an implementation of " + targetClass.getName() + ".");
            }
            Class[] argTypes = new Class[]{Object.class};
            Object[] args = new Object[]{configElem};
            Constructor<?> constructor = requestedClass.getConstructor(argTypes);
            return (DatasetEnhancer)constructor.newInstance(args);
        }
        catch (ClassNotFoundException e) {
            logger.warn("readDatasetScanUserDefined(): exception creating user defined object <" + className + ">", e);
            return null;
        }
        catch (NoSuchMethodException e) {
            logger.warn("readDatasetScanUserDefined(): exception creating user defined object <" + className + ">", e);
            return null;
        }
        catch (InstantiationException e) {
            logger.warn("readDatasetScanUserDefined(): exception creating user defined object <" + className + ">", e);
            return null;
        }
        catch (IllegalAccessException e) {
            logger.warn("readDatasetScanUserDefined(): exception creating user defined object <" + className + ">", e);
            return null;
        }
        catch (InvocationTargetException e) {
            logger.warn("readDatasetScanUserDefined(): exception creating user defined object <" + className + ">", e);
            return null;
        }
    }

    protected DataRootConfig readDatasetRoot(Element s) {
        int last;
        String path = s.getAttributeValue("path");
        String dirLocation = s.getAttributeValue("location");
        if (dirLocation == null) {
            dirLocation = s.getAttributeValue("dirLocation");
        }
        dirLocation = this.expandAliasForPath(dirLocation);
        if (path != null) {
            if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            if (path.charAt(last = path.length() - 1) == '/') {
                path = path.substring(0, last);
            }
        }
        if (dirLocation != null && dirLocation.charAt(last = dirLocation.length() - 1) != '/') {
            dirLocation = dirLocation + '/';
        }
        return new DataRootConfig(path, dirLocation, s.getAttributeValue("cache"));
    }

    protected DateType readDate(Element elem) {
        if (elem == null) {
            return null;
        }
        String format = elem.getAttributeValue("format");
        String type = elem.getAttributeValue("type");
        return this.makeDateType(elem.getText(), format, type);
    }

    protected DateType makeDateType(String text, String format, String type) {
        if (text == null) {
            return null;
        }
        try {
            return new DateType(text, format, type);
        }
        catch (ParseException e) {
            this.factory.appendErr(" ** Parse error: Bad date format = " + text + "\n");
            return null;
        }
    }

    protected TimeDuration readDuration(Element elem) {
        if (elem == null) {
            return null;
        }
        String text = null;
        try {
            text = elem.getText();
            return new TimeDuration(text);
        }
        catch (ParseException e) {
            this.factory.appendErr(" ** Parse error: Bad duration format = " + text + "\n");
            return null;
        }
    }

    protected InvDocumentation readDocumentation(InvCatalog cat, Element s) {
        String href = s.getAttributeValue("href", xlinkNS);
        String title = s.getAttributeValue("title", xlinkNS);
        String type = s.getAttributeValue("type");
        String content = s.getTextNormalize();
        URI uri = null;
        if (href != null) {
            try {
                uri = cat.resolveUri(href);
            }
            catch (Exception e) {
                this.factory.appendErr(" ** Invalid documentation href = " + href + " " + e.getMessage() + "\n");
            }
        }
        InvDocumentation doc = new InvDocumentation(href, uri, title, type, content);
        if (InvCatalogFactory.debugXML) {
            System.out.println(" Documentation added: " + doc);
        }
        return doc;
    }

    protected double readDouble(Element elem) {
        if (elem == null) {
            return Double.NaN;
        }
        String text = elem.getText();
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            this.factory.appendErr(" ** Parse error: Bad double format = " + text + "\n");
            return Double.NaN;
        }
    }

    protected ThreddsMetadata.GeospatialCoverage readGeospatialCoverage(Element gcElem) {
        if (gcElem == null) {
            return null;
        }
        String zpositive = gcElem.getAttributeValue("zpositive");
        ThreddsMetadata.Range northsouth = this.readGeospatialRange(gcElem.getChild("northsouth", defNS), "degrees_north");
        ThreddsMetadata.Range eastwest = this.readGeospatialRange(gcElem.getChild("eastwest", defNS), "degrees_east");
        ThreddsMetadata.Range updown = this.readGeospatialRange(gcElem.getChild("updown", defNS), "m");
        ArrayList<ThreddsMetadata.Vocab> names = new ArrayList<ThreddsMetadata.Vocab>();
        List<Element> list = gcElem.getChildren("name", defNS);
        for (Element e : list) {
            ThreddsMetadata.Vocab name = this.readControlledVocabulary(e);
            names.add(name);
        }
        return new ThreddsMetadata.GeospatialCoverage(eastwest, northsouth, updown, names, zpositive);
    }

    protected ThreddsMetadata.Range readGeospatialRange(Element spElem, String defUnits) {
        if (spElem == null) {
            return null;
        }
        double start = this.readDouble(spElem.getChild("start", defNS));
        double size = this.readDouble(spElem.getChild("size", defNS));
        double resolution = this.readDouble(spElem.getChild("resolution", defNS));
        String units = spElem.getChildText("units", defNS);
        if (units == null) {
            units = defUnits;
        }
        return new ThreddsMetadata.Range(start, size, resolution, units);
    }

    protected InvMetadata readMetadata(InvCatalog catalog, InvDatasetImpl dataset, Element mdataElement) {
        List<Element> inlineElements = mdataElement.getChildren();
        Namespace namespace = inlineElements.size() > 0 ? inlineElements.get(0).getNamespace() : mdataElement.getNamespace();
        String mtype = mdataElement.getAttributeValue("metadataType");
        String href = mdataElement.getAttributeValue("href", xlinkNS);
        String title = mdataElement.getAttributeValue("title", xlinkNS);
        String inheritedS = mdataElement.getAttributeValue("inherited");
        boolean inherited = inheritedS != null && inheritedS.equalsIgnoreCase("true");
        boolean isThreddsNamespace = (mtype == null || mtype.equalsIgnoreCase("THREDDS")) && namespace.getURI().equals("http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0");
        MetadataConverterIF metaConverter = this.factory.getMetadataConverter(namespace.getURI());
        if (metaConverter == null) {
            metaConverter = this.factory.getMetadataConverter(mtype);
        }
        if (metaConverter != null) {
            if (this.debugMetadataRead) {
                System.out.println("found factory for metadata type = " + mtype + " namespace = " + namespace + "=" + metaConverter.getClass().getName());
            }
            if (inlineElements.size() > 0) {
                Object contentObj = metaConverter.readMetadataContent(dataset, mdataElement);
                return new InvMetadata(dataset, mtype, namespace.getURI(), namespace.getPrefix(), inherited, false, metaConverter, contentObj);
            }
            return new InvMetadata(dataset, href, title, mtype, namespace.getURI(), namespace.getPrefix(), inherited, false, metaConverter);
        }
        if (!isThreddsNamespace) {
            if (inlineElements.size() > 0) {
                return new InvMetadata(dataset, mtype, namespace.getURI(), namespace.getPrefix(), inherited, false, this, mdataElement);
            }
            return new InvMetadata(dataset, href, title, mtype, namespace.getURI(), namespace.getPrefix(), inherited, false, null);
        }
        if (inlineElements.size() > 0) {
            ThreddsMetadata tmg = new ThreddsMetadata(false);
            this.readThreddsMetadata(catalog, dataset, mdataElement, tmg);
            return new InvMetadata(dataset, mtype, namespace.getURI(), namespace.getPrefix(), inherited, true, this, tmg);
        }
        return new InvMetadata(dataset, href, title, mtype, namespace.getURI(), namespace.getPrefix(), inherited, true, this);
    }

    @Override
    public Object readMetadataContent(InvDataset dataset, Element mdataElement) {
        InvMetadata m = this.readMetadata(dataset.getParentCatalog(), (InvDatasetImpl)dataset, mdataElement);
        return m.getThreddsMetadata();
    }

    private Element readContentFromURL(URI uri) throws IOException {
        Document doc;
        if (this.saxBuilder == null) {
            this.saxBuilder = new SAXBuilder();
        }
        try {
            doc = this.saxBuilder.build(uri.toURL());
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        return doc.getRootElement();
    }

    @Override
    public Object readMetadataContentFromURL(InvDataset dataset, URI uri) throws IOException {
        Element elem = this.readContentFromURL(uri);
        Object contentObject = this.readMetadataContent(dataset, elem);
        if (this.debugMetadataRead) {
            System.out.println(" convert to " + contentObject.getClass().getName());
        }
        return contentObject;
    }

    @Override
    public boolean validateMetadataContent(Object contentObject, StringBuilder out) {
        return true;
    }

    @Override
    public void addMetadataContent(Element mdataElement, Object contentObject) {
    }

    protected InvProperty readProperty(Element s) {
        String name = s.getAttributeValue("name");
        String value = s.getAttributeValue("value");
        return new InvProperty(name, value);
    }

    protected ThreddsMetadata.Source readSource(Element elem) {
        if (elem == null) {
            return null;
        }
        ThreddsMetadata.Vocab name = this.readControlledVocabulary(elem.getChild("name", defNS));
        Element contact = elem.getChild("contact", defNS);
        if (contact == null) {
            this.factory.appendErr(" ** Parse error: Missing contact element in = " + elem.getName() + "\n");
            return null;
        }
        return new ThreddsMetadata.Source(name, contact.getAttributeValue("url"), contact.getAttributeValue("email"));
    }

    protected InvService readService(Element s, URI baseURI) {
        String name = s.getAttributeValue("name");
        String type = s.getAttributeValue("serviceType");
        String serviceBase = s.getAttributeValue("base");
        String suffix = s.getAttributeValue("suffix");
        String desc = s.getAttributeValue("desc");
        InvService service = new InvService(name, type, serviceBase, suffix, desc);
        List<Element> propertyList = s.getChildren("property", defNS);
        for (Element e : propertyList) {
            InvProperty p = this.readProperty(e);
            service.addProperty(p);
        }
        List<Element> rootList = s.getChildren("datasetRoot", defNS);
        for (Element e : rootList) {
            DataRootConfig root = this.readDatasetRoot(e);
            service.addDatasetRoot(root);
        }
        List<Element> serviceList = s.getChildren("service", defNS);
        for (Element e : serviceList) {
            InvService ss = this.readService(e, baseURI);
            service.addService(ss);
        }
        if (InvCatalogFactory.debugXML) {
            System.out.println(" Service added: " + service);
        }
        return service;
    }

    protected double readDataSize(Element parent) {
        double size;
        Element elem = parent.getChild("dataSize", defNS);
        if (elem == null) {
            return Double.NaN;
        }
        String sizeS = elem.getText();
        try {
            size = Double.parseDouble(sizeS);
        }
        catch (NumberFormatException e) {
            this.factory.appendErr(" ** Parse error: Bad double format in size element = " + sizeS + "\n");
            return Double.NaN;
        }
        String units = elem.getAttributeValue("units");
        char c = Character.toUpperCase(units.charAt(0));
        if (c == 'K') {
            size *= 1000.0;
        } else if (c == 'M') {
            size *= 1000000.0;
        } else if (c == 'G') {
            size *= 1.0E9;
        } else if (c == 'T') {
            size *= 1.0E12;
        } else if (c == 'P') {
            size *= 1.0E15;
        }
        return size;
    }

    protected DateRange readTimeCoverage(Element tElem) {
        if (tElem == null) {
            return null;
        }
        DateType start = this.readDate(tElem.getChild("start", defNS));
        DateType end = this.readDate(tElem.getChild("end", defNS));
        TimeDuration duration = this.readDuration(tElem.getChild("duration", defNS));
        TimeDuration resolution = this.readDuration(tElem.getChild("resolution", defNS));
        try {
            return new DateRange(start, end, duration, resolution);
        }
        catch (IllegalArgumentException e) {
            this.factory.appendWarning(" ** warning: TimeCoverage error = " + e.getMessage() + "\n");
            return null;
        }
    }

    protected void readThreddsMetadata(InvCatalog catalog, InvDatasetImpl dataset, Element parent, ThreddsMetadata tmg) {
        double size;
        String dataFormatTypeName;
        Element dataFormatElem;
        String dataTypeName;
        Element dataTypeElem;
        Element authElem;
        Element serviceNameElem;
        DateRange tc;
        List<Element> list = parent.getChildren("creator", defNS);
        for (Element e : list) {
            tmg.addCreator(this.readSource(e));
        }
        list = parent.getChildren("contributor", defNS);
        for (Element e : list) {
            tmg.addContributor(this.readContributor(e));
        }
        list = parent.getChildren("date", defNS);
        for (Element e : list) {
            DateType d = this.readDate(e);
            tmg.addDate(d);
        }
        list = parent.getChildren("documentation", defNS);
        for (Element e : list) {
            InvDocumentation doc = this.readDocumentation(catalog, e);
            tmg.addDocumentation(doc);
        }
        list = parent.getChildren("keyword", defNS);
        for (Element e : list) {
            tmg.addKeyword(this.readControlledVocabulary(e));
        }
        List<Element> mList = parent.getChildren("metadata", defNS);
        for (Element e : mList) {
            InvMetadata m = this.readMetadata(catalog, dataset, e);
            if (m == null) continue;
            tmg.addMetadata(m);
        }
        list = parent.getChildren("project", defNS);
        for (Element e : list) {
            tmg.addProject(this.readControlledVocabulary(e));
        }
        list = parent.getChildren("property", defNS);
        for (Element e : list) {
            InvProperty p = this.readProperty(e);
            tmg.addProperty(p);
        }
        list = parent.getChildren("publisher", defNS);
        for (Element e : list) {
            tmg.addPublisher(this.readSource(e));
        }
        list = parent.getChildren("variables", defNS);
        for (Element e : list) {
            ThreddsMetadata.Variables vars = this.readVariables(catalog, dataset, e);
            tmg.addVariables(vars);
        }
        ThreddsMetadata.GeospatialCoverage gc = this.readGeospatialCoverage(parent.getChild("geospatialCoverage", defNS));
        if (gc != null) {
            tmg.setGeospatialCoverage(gc);
        }
        if ((tc = this.readTimeCoverage(parent.getChild("timeCoverage", defNS))) != null) {
            tmg.setTimeCoverage(tc);
        }
        if ((serviceNameElem = parent.getChild("serviceName", defNS)) != null) {
            tmg.setServiceName(serviceNameElem.getText());
        }
        if ((authElem = parent.getChild("authority", defNS)) != null) {
            tmg.setAuthority(authElem.getText());
        }
        if ((dataTypeElem = parent.getChild("dataType", defNS)) != null && (dataTypeName = dataTypeElem.getText()) != null && dataTypeName.length() > 0) {
            FeatureType dataType = FeatureType.getType(dataTypeName.toUpperCase());
            if (dataType == null) {
                this.factory.appendWarning(" ** warning: non-standard data type = " + dataTypeName + "\n");
            }
            tmg.setDataType(dataType);
        }
        if ((dataFormatElem = parent.getChild("dataFormat", defNS)) != null && (dataFormatTypeName = dataFormatElem.getText()) != null && dataFormatTypeName.length() > 0) {
            DataFormatType dataFormatType = DataFormatType.findType(dataFormatTypeName);
            if (dataFormatType == null) {
                dataFormatType = DataFormatType.getType(dataFormatTypeName);
                this.factory.appendWarning(" ** warning: non-standard dataFormat type = " + dataFormatTypeName + "\n");
            }
            tmg.setDataFormatType(dataFormatType);
        }
        if (!Double.isNaN(size = this.readDataSize(parent))) {
            tmg.setDataSize(size);
        }
    }

    protected ThreddsMetadata.Variable readVariable(Element varElem) {
        if (varElem == null) {
            return null;
        }
        String name = varElem.getAttributeValue("name");
        String desc = varElem.getText();
        String vocabulary_name = varElem.getAttributeValue("vocabulary_name");
        String units = varElem.getAttributeValue("units");
        String id = varElem.getAttributeValue("vocabulary_id");
        return new ThreddsMetadata.Variable(name, desc, vocabulary_name, units, id);
    }

    protected ThreddsMetadata.Variables readVariables(InvCatalog cat, InvDataset ds, Element varsElem) {
        if (varsElem == null) {
            return null;
        }
        String vocab = varsElem.getAttributeValue("vocabulary");
        String vocabHref = varsElem.getAttributeValue("href", xlinkNS);
        URI vocabUri = null;
        if (vocabHref != null) {
            try {
                vocabUri = cat.resolveUri(vocabHref);
            }
            catch (Exception e) {
                this.factory.appendErr(" ** Invalid Variables vocabulary URI = " + vocabHref + " " + e.getMessage() + "\n");
            }
        }
        List<Element> vlist = varsElem.getChildren("variable", defNS);
        String mapHref = null;
        URI mapUri = null;
        Element map = varsElem.getChild("variableMap", defNS);
        if (map != null) {
            mapHref = map.getAttributeValue("href", xlinkNS);
            try {
                mapUri = cat.resolveUri(mapHref);
            }
            catch (Exception e) {
                this.factory.appendErr(" ** Invalid Variables map URI = " + mapHref + " " + e.getMessage() + "\n");
            }
        }
        if (mapUri != null && vlist.size() > 0) {
            this.factory.appendErr(" ** Catalog error: cant have variableMap and variable in same element (dataset = " + ds.getName() + "\n");
            mapUri = null;
        }
        ThreddsMetadata.Variables variables = new ThreddsMetadata.Variables(vocab, vocabHref, vocabUri, mapHref, mapUri);
        for (Element e : vlist) {
            ThreddsMetadata.Variable v = this.readVariable(e);
            variables.addVariable(v);
        }
        if (mapUri != null) {
            try {
                Element varsElement = this.readContentFromURL(mapUri);
                List<Element> list = varsElement.getChildren("variable", defNS);
                for (Element e : list) {
                    ThreddsMetadata.Variable v = this.readVariable(e);
                    variables.addVariable(v);
                }
            }
            catch (IOException e) {
                logger.warn("Failure reading vaiable mapUri ", e);
            }
        }
        return variables;
    }

    @Override
    public void writeXML(InvCatalogImpl catalog, OutputStream os, boolean raw) throws IOException {
        this.raw = raw;
        this.writeXML(catalog, os);
        this.raw = false;
    }

    @Override
    public void writeXML(InvCatalogImpl catalog, OutputStream os) throws IOException {
        XMLOutputter fmt = new XMLOutputter(org.jdom2.output.Format.getPrettyFormat());
        fmt.output(this.writeCatalog(catalog), os);
    }

    public Document writeCatalog(InvCatalogImpl cat) {
        Element rootElem = new Element("catalog", defNS);
        Document doc = new Document(rootElem);
        if (cat.getName() != null) {
            rootElem.setAttribute("name", cat.getName());
        }
        rootElem.setAttribute("version", this.version);
        rootElem.addNamespaceDeclaration(xlinkNS);
        if (cat.getExpires() != null) {
            rootElem.setAttribute("expires", cat.getExpires().toString());
        }
        for (InvService invService : cat.getServices()) {
            rootElem.addContent(this.writeService(invService));
        }
        if (this.raw) {
            for (InvProperty invProperty : cat.getDatasetRoots()) {
                rootElem.addContent(this.writeDatasetRoot(invProperty));
            }
        }
        for (InvProperty invProperty : cat.getProperties()) {
            rootElem.addContent(this.writeProperty(invProperty));
        }
        for (InvDatasetImpl invDatasetImpl : cat.getDatasets()) {
            if (invDatasetImpl instanceof InvDatasetScan) {
                rootElem.addContent(this.writeDatasetScan((InvDatasetScan)invDatasetImpl));
                continue;
            }
            if (invDatasetImpl instanceof InvCatalogRef) {
                rootElem.addContent(this.writeCatalogRef((InvCatalogRef)invDatasetImpl));
                continue;
            }
            rootElem.addContent(this.writeDataset(invDatasetImpl));
        }
        return doc;
    }

    private Element writeAccess(InvAccessImpl access) {
        Element accessElem = new Element("access", defNS);
        accessElem.setAttribute("urlPath", access.getUrlPath());
        if (access.getServiceName() != null) {
            accessElem.setAttribute("serviceName", access.getServiceName());
        }
        if (access.getDataFormatType() != null) {
            accessElem.setAttribute("dataFormat", access.getDataFormatType().toString());
        }
        if (access.hasDataSize()) {
            accessElem.addContent(this.writeDataSize(access.getDataSize()));
        }
        return accessElem;
    }

    private Element writeCatalogRef(InvCatalogRef catRef) {
        Element catrefElem = new Element("catalogRef", defNS);
        catrefElem.setAttribute("href", catRef.getXlinkHref(), xlinkNS);
        String name = catRef.getName() == null ? "" : catRef.getName();
        catrefElem.setAttribute("title", name, xlinkNS);
        if (catRef.getID() != null) {
            catrefElem.setAttribute("ID", catRef.getID());
        }
        if (catRef.getRestrictAccess() != null) {
            catrefElem.setAttribute("restrictAccess", catRef.getRestrictAccess());
        }
        catrefElem.setAttribute("name", "");
        return catrefElem;
    }

    protected Element writeContributor(ThreddsMetadata.Contributor c) {
        Element elem = new Element("contributor", defNS);
        if (c.getRole() != null) {
            elem.setAttribute("role", c.getRole());
        }
        elem.setText(c.getName());
        return elem;
    }

    private Element writeControlledVocabulary(ThreddsMetadata.Vocab v, String name) {
        Element elem = new Element(name, defNS);
        if (v.getVocabulary() != null) {
            elem.setAttribute("vocabulary", v.getVocabulary());
        }
        elem.addContent(v.getText());
        return elem;
    }

    private Element writeDataset(InvDatasetImpl ds) {
        Element dsElem = new Element("dataset", defNS);
        if (ds instanceof InvDatasetImplProxy) {
            dsElem.setAttribute("name", ((InvDatasetImplProxy)ds).getAliasName());
            dsElem.setAttribute("alias", ds.getID());
            return dsElem;
        }
        this.writeDatasetInfo(ds, dsElem, true, this.raw);
        return dsElem;
    }

    private Element writeDatasetRoot(InvProperty prop) {
        Element drootElem = new Element("datasetRoot", defNS);
        drootElem.setAttribute("path", prop.getName());
        drootElem.setAttribute("location", prop.getValue());
        return drootElem;
    }

    private Element writeDatasetScan(InvDatasetScan ds) {
        Element dsElem;
        if (this.raw) {
            dsElem = new Element("datasetScan", defNS);
            this.writeDatasetInfo(ds, dsElem, false, true);
            dsElem.setAttribute("path", ds.getPath());
            dsElem.setAttribute("location", ds.getScanLocation());
            if (ds.getCrDsClassName() != null) {
                Element configElem = new Element("crawlableDatasetImpl", defNS);
                configElem.setAttribute("className", ds.getCrDsClassName());
                if (ds.getCrDsConfigObj() != null && ds.getCrDsConfigObj() instanceof Element) {
                    configElem.addContent((Element)ds.getCrDsConfigObj());
                }
            }
            if (ds.getFilter() != null) {
                dsElem.addContent(this.writeDatasetScanFilter(ds.getFilter()));
            }
            dsElem.addContent(this.writeDatasetScanIdentifier(ds.getIdentifier()));
            if (ds.getNamer() != null) {
                dsElem.addContent(this.writeDatasetScanNamer(ds.getNamer()));
            }
            if (ds.getSorter() != null) {
                dsElem.addContent(this.writeDatasetScanSorter(ds.getSorter()));
            }
            if (!ds.getProxyDatasetHandlers().isEmpty()) {
                dsElem.addContent(this.writeDatasetScanAddProxies(ds.getProxyDatasetHandlers()));
            }
            if (ds.getAddDatasetSize()) {
                dsElem.addContent(new Element("addDatasetSize", defNS));
            }
            if (ds.getChildEnhancerList() != null) {
                dsElem.addContent(this.writeDatasetScanEnhancer(ds.getChildEnhancerList()));
            }
        } else if (ds.isValid()) {
            dsElem = new Element("catalogRef", defNS);
            this.writeDatasetInfo(ds, dsElem, false, false);
            dsElem.setAttribute("href", ds.getXlinkHref(), xlinkNS);
            dsElem.setAttribute("title", ds.getName(), xlinkNS);
            dsElem.setAttribute("name", "");
            dsElem.addContent(this.writeProperty(new InvProperty("DatasetScan", "true")));
        } else {
            dsElem = new Element("dataset", defNS);
            dsElem.setAttribute("name", "** Misconfigured DatasetScan <" + ds.getPath() + "> **");
            dsElem.addContent(new Comment(ds.getInvalidMessage()));
        }
        return dsElem;
    }

    Element writeDatasetScanFilter(CrawlableDatasetFilter filter) {
        Element filterElem = new Element("filter", defNS);
        if (filter.getClass().isAssignableFrom(MultiSelectorFilter.class) && filter.getConfigObject() != null) {
            for (Object o : (List)filter.getConfigObject()) {
                MultiSelectorFilter.Selector curSelector = (MultiSelectorFilter.Selector)o;
                Element curSelectorElem = curSelector.isIncluder() ? new Element("include", defNS) : new Element("exclude", defNS);
                CrawlableDatasetFilter curFilter = curSelector.getFilter();
                if (curFilter instanceof WildcardMatchOnNameFilter) {
                    curSelectorElem.setAttribute("wildcard", ((WildcardMatchOnNameFilter)curFilter).getWildcardString());
                    curSelectorElem.setAttribute("atomic", curSelector.isApplyToAtomicDataset() ? "true" : "false");
                    curSelectorElem.setAttribute("collection", curSelector.isApplyToCollectionDataset() ? "true" : "false");
                } else if (curFilter instanceof RegExpMatchOnNameFilter) {
                    curSelectorElem.setAttribute("regExp", ((RegExpMatchOnNameFilter)curFilter).getRegExpString());
                    curSelectorElem.setAttribute("atomic", curSelector.isApplyToAtomicDataset() ? "true" : "false");
                    curSelectorElem.setAttribute("collection", curSelector.isApplyToCollectionDataset() ? "true" : "false");
                } else if (curFilter instanceof LastModifiedLimitFilter) {
                    curSelectorElem.setAttribute("lastModLimitInMillis", Long.toString(((LastModifiedLimitFilter)curFilter).getLastModifiedLimitInMillis()));
                    curSelectorElem.setAttribute("atomic", curSelector.isApplyToAtomicDataset() ? "true" : "false");
                    curSelectorElem.setAttribute("collection", curSelector.isApplyToCollectionDataset() ? "true" : "false");
                } else {
                    curSelectorElem.addContent(new Comment("Unknown selector type <" + curSelector.getClass().getName() + ">."));
                }
                filterElem.addContent(curSelectorElem);
            }
        } else {
            filterElem.addContent(this.writeDatasetScanUserDefined("crawlableDatasetFilterImpl", filter.getClass().getName(), filter.getConfigObject()));
        }
        return filterElem;
    }

    private Element writeDatasetScanNamer(CrawlableDatasetLabeler namer) {
        Element namerElem = null;
        if (namer != null) {
            namerElem = new Element("namer", defNS);
            if (namer instanceof MultiLabeler) {
                for (CrawlableDatasetLabeler curNamer : ((MultiLabeler)namer).getLabelerList()) {
                    Element curNamerElem;
                    if (curNamer instanceof RegExpAndReplaceOnNameLabeler) {
                        curNamerElem = new Element("regExpOnName", defNS);
                        curNamerElem.setAttribute("regExp", ((RegExpAndReplaceOnNameLabeler)curNamer).getRegExp());
                        curNamerElem.setAttribute("replaceString", ((RegExpAndReplaceOnNameLabeler)curNamer).getReplaceString());
                        namerElem.addContent(curNamerElem);
                        continue;
                    }
                    if (curNamer instanceof RegExpAndReplaceOnPathLabeler) {
                        curNamerElem = new Element("regExpOnPath", defNS);
                        curNamerElem.setAttribute("regExp", ((RegExpAndReplaceOnPathLabeler)curNamer).getRegExp());
                        curNamerElem.setAttribute("replaceString", ((RegExpAndReplaceOnPathLabeler)curNamer).getReplaceString());
                        namerElem.addContent(curNamerElem);
                        continue;
                    }
                    String tmpMsg = "writeDatasetScanNamer(): unsupported namer <" + curNamer.getClass().getName() + ">.";
                    logger.warn(tmpMsg);
                    namerElem.addContent(new Comment(tmpMsg));
                }
            } else {
                namerElem.addContent(this.writeDatasetScanUserDefined("crawlableDatasetLabelerImpl", namer.getClass().getName(), namer.getConfigObject()));
            }
        }
        return namerElem;
    }

    private Element writeDatasetScanIdentifier(CrawlableDatasetLabeler identifier) {
        Element identifierElem = new Element("addID", defNS);
        if (identifier != null) {
            if (identifier instanceof SimpleLatestProxyDsHandler) {
                return identifierElem;
            }
            identifierElem = new Element("addID", defNS);
            identifierElem.addContent(this.writeDatasetScanUserDefined("crawlableDatasetLabelerImpl", identifier.getClass().getName(), identifier.getConfigObject()));
        }
        return identifierElem;
    }

    private Element writeDatasetScanAddProxies(Map<String, ProxyDatasetHandler> proxyDsHandlers) {
        ProxyDatasetHandler o;
        if (proxyDsHandlers.size() == 1 && proxyDsHandlers.containsKey("latest.xml") && (o = proxyDsHandlers.get("latest.xml")) instanceof SimpleLatestProxyDsHandler) {
            SimpleLatestProxyDsHandler pdh = (SimpleLatestProxyDsHandler)o;
            String name = pdh.getProxyDatasetName();
            boolean top = pdh.isLocateAtTopOrBottom();
            String serviceName = pdh.getProxyDatasetService(null).getName();
            Element addProxiesElem = new Element("addLatest", defNS);
            if (name.equals("latest.xml") && top && serviceName.equals("latest")) {
                return addProxiesElem;
            }
            Element simpleLatestElem = new Element("simpleLatest", defNS);
            simpleLatestElem.setAttribute("name", name);
            simpleLatestElem.setAttribute("top", top ? "true" : "false");
            simpleLatestElem.setAttribute("servicName", serviceName);
            addProxiesElem.addContent(simpleLatestElem);
            return addProxiesElem;
        }
        Element addProxiesElem = new Element("addProxies", defNS);
        for (Map.Entry<String, ProxyDatasetHandler> entry : proxyDsHandlers.entrySet()) {
            String curName = entry.getKey();
            ProxyDatasetHandler curPdh = entry.getValue();
            if (curPdh instanceof SimpleLatestProxyDsHandler) {
                SimpleLatestProxyDsHandler sPdh = (SimpleLatestProxyDsHandler)curPdh;
                Element simpleLatestElem = new Element("simpleLatest", defNS);
                simpleLatestElem.setAttribute("name", sPdh.getProxyDatasetName());
                simpleLatestElem.setAttribute("top", sPdh.isLocateAtTopOrBottom() ? "true" : "false");
                simpleLatestElem.setAttribute("servicName", sPdh.getProxyDatasetService(null).getName());
                addProxiesElem.addContent(simpleLatestElem);
                continue;
            }
            if (curPdh instanceof LatestCompleteProxyDsHandler) {
                LatestCompleteProxyDsHandler lcPdh = (LatestCompleteProxyDsHandler)curPdh;
                Element latestElem = new Element("latestComplete", defNS);
                latestElem.setAttribute("name", lcPdh.getProxyDatasetName());
                latestElem.setAttribute("top", lcPdh.isLocateAtTopOrBottom() ? "true" : "false");
                latestElem.setAttribute("servicName", lcPdh.getProxyDatasetService(null).getName());
                latestElem.setAttribute("lastModifiedLimit", Long.toString(lcPdh.getLastModifiedLimit()));
                addProxiesElem.addContent(latestElem);
                continue;
            }
            logger.warn("writeDatasetScanAddProxies(): unknown type of ProxyDatasetHandler <" + curPdh.getProxyDatasetName() + ">.");
        }
        return addProxiesElem;
    }

    private Element writeDatasetScanSorter(CrawlableDatasetSorter sorter) {
        Element sorterElem = new Element("sort", defNS);
        if (sorter instanceof LexigraphicByNameSorter) {
            Element lexElem = new Element("lexigraphicByName", defNS);
            lexElem.setAttribute("increasing", ((LexigraphicByNameSorter)sorter).isIncreasing() ? "true" : "false");
            sorterElem.addContent(lexElem);
        } else {
            sorterElem.addContent(this.writeDatasetScanUserDefined("crawlableDatasetSorterImpl", sorter.getClass().getName(), sorter.getConfigObject()));
        }
        return sorterElem;
    }

    private List<Element> writeDatasetScanEnhancer(List<DatasetEnhancer> enhancerList) {
        ArrayList<Element> enhancerElemList = new ArrayList<Element>();
        int timeCovCount = 0;
        for (DatasetEnhancer curEnhancer : enhancerList) {
            if (curEnhancer instanceof RegExpAndDurationTimeCoverageEnhancer) {
                if (timeCovCount > 0) {
                    logger.warn("writeDatasetScanEnhancer(): More than one addTimeCoverage element, skipping.");
                    continue;
                }
                ++timeCovCount;
                Element timeCovElem = new Element("addTimeCoverage", defNS);
                RegExpAndDurationTimeCoverageEnhancer timeCovEnhancer = (RegExpAndDurationTimeCoverageEnhancer)curEnhancer;
                timeCovElem.setAttribute("datasetNameMatchPattern", timeCovEnhancer.getMatchPattern());
                timeCovElem.setAttribute("startTimeSubstitutionPattern", timeCovEnhancer.getSubstitutionPattern());
                timeCovElem.setAttribute("duration", timeCovEnhancer.getDuration());
                enhancerElemList.add(timeCovElem);
                continue;
            }
            enhancerElemList.add(this.writeDatasetScanUserDefined("datasetEnhancerImpl", curEnhancer.getClass().getName(), curEnhancer.getConfigObject()));
        }
        return enhancerElemList;
    }

    private Element writeDatasetScanUserDefined(String userDefName, String className, Object configObj) {
        Element userDefElem = new Element(userDefName, defNS);
        userDefElem.setAttribute("className", className);
        if (configObj != null) {
            if (configObj instanceof Element) {
                userDefElem.addContent((Element)configObj);
            } else {
                userDefElem.addContent(new Comment("This class <" + className + "> not yet supported. This XML is missing configuration information (of type " + configObj.getClass().getName() + ")."));
            }
        }
        return userDefElem;
    }

    private void writeDatasetInfo(InvDatasetImpl ds, Element dsElem, boolean doNestedDatasets, boolean showNcML) {
        dsElem.setAttribute("name", ds.getName());
        if (ds.getCollectionType() != null && ds.getCollectionType() != CollectionType.NONE) {
            dsElem.setAttribute("collectionType", ds.getCollectionType().toString());
        }
        if (ds.isHarvest()) {
            dsElem.setAttribute("harvest", "true");
        }
        if (ds.getID() != null) {
            dsElem.setAttribute("ID", ds.getID());
        }
        if (ds.getUrlPath() != null) {
            dsElem.setAttribute("urlPath", ds.getUrlPath());
        }
        if (ds.getRestrictAccess() != null) {
            dsElem.setAttribute("restrictAccess", ds.getRestrictAccess());
        }
        for (InvService service : ds.getServicesLocal()) {
            dsElem.addContent(this.writeService(service));
        }
        this.writeThreddsMetadata(dsElem, ds.getLocalMetadata());
        this.writeInheritedMetadata(dsElem, ds.getLocalMetadataInheritable());
        for (InvAccess a : ds.getAccessLocal()) {
            dsElem.addContent(this.writeAccess((InvAccessImpl)a));
        }
        if (showNcML && ds.getNcmlElement() != null) {
            Element ncml = ds.getNcmlElement().clone();
            ncml.detach();
            dsElem.addContent(ncml);
        }
        if (!doNestedDatasets) {
            return;
        }
        for (InvDataset nested : ds.getDatasets()) {
            if (nested instanceof InvDatasetScan) {
                dsElem.addContent(this.writeDatasetScan((InvDatasetScan)nested));
                continue;
            }
            if (nested instanceof InvCatalogRef) {
                dsElem.addContent(this.writeCatalogRef((InvCatalogRef)nested));
                continue;
            }
            dsElem.addContent(this.writeDataset((InvDatasetImpl)nested));
        }
    }

    protected Element writeDate(String name, DateType date) {
        Element dateElem = new Element(name, defNS);
        dateElem.addContent(date.getText());
        if (date.getType() != null) {
            dateElem.setAttribute("type", date.getType());
        }
        if (date.getFormat() != null) {
            dateElem.setAttribute("format", date.getFormat());
        }
        return dateElem;
    }

    private Element writeDocumentation(InvDocumentation doc, String name) {
        String inline;
        Element docElem = new Element(name, defNS);
        if (doc.getType() != null) {
            docElem.setAttribute("type", doc.getType());
        }
        if (doc.hasXlink()) {
            docElem.setAttribute("href", doc.getXlinkHref(), xlinkNS);
            if (!doc.getXlinkTitle().equals(doc.getURI().toString())) {
                docElem.setAttribute("title", doc.getXlinkTitle(), xlinkNS);
            }
        }
        if ((inline = doc.getInlineContent()) != null) {
            docElem.addContent(inline);
        }
        return docElem;
    }

    public Element writeGeospatialCoverage(ThreddsMetadata.GeospatialCoverage gc) {
        Element elem = new Element("geospatialCoverage", defNS);
        if (gc.getZPositive().equals("down")) {
            elem.setAttribute("zpositive", gc.getZPositive());
        }
        if (gc.getNorthSouthRange() != null) {
            this.writeGeospatialRange(elem, new Element("northsouth", defNS), gc.getNorthSouthRange());
        }
        if (gc.getEastWestRange() != null) {
            this.writeGeospatialRange(elem, new Element("eastwest", defNS), gc.getEastWestRange());
        }
        if (gc.getUpDownRange() != null) {
            this.writeGeospatialRange(elem, new Element("updown", defNS), gc.getUpDownRange());
        }
        List<ThreddsMetadata.Vocab> names = gc.getNames();
        ThreddsMetadata.Vocab global = new ThreddsMetadata.Vocab("global", null);
        if (gc.isGlobal() && !names.contains(global)) {
            names.add(global);
        } else if (!gc.isGlobal() && names.contains(global)) {
            names.remove(global);
        }
        for (ThreddsMetadata.Vocab name : names) {
            elem.addContent(this.writeControlledVocabulary(name, "name"));
        }
        return elem;
    }

    private void writeGeospatialRange(Element parent, Element elem, ThreddsMetadata.Range r) {
        if (r == null) {
            return;
        }
        elem.addContent(new Element("start", defNS).setText(Double.toString(r.getStart())));
        elem.addContent(new Element("size", defNS).setText(Double.toString(r.getSize())));
        if (r.hasResolution()) {
            elem.addContent(new Element("resolution", defNS).setText(Double.toString(r.getResolution())));
        }
        if (r.getUnits() != null) {
            elem.addContent(new Element("units", defNS).setText(r.getUnits()));
        }
        parent.addContent(elem);
    }

    private Element writeMetadata(InvMetadata mdata) {
        String ns;
        Element mdataElem = new Element("metadata", defNS);
        if (mdata.getMetadataType() != null) {
            mdataElem.setAttribute("metadataType", mdata.getMetadataType());
        }
        if (mdata.isInherited()) {
            mdataElem.setAttribute("inherited", "true");
        }
        if ((ns = mdata.getNamespaceURI()) != null && !ns.equals("http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0")) {
            Namespace mdataNS = Namespace.getNamespace(mdata.getNamespacePrefix(), ns);
            mdataElem.addNamespaceDeclaration(mdataNS);
        }
        if (mdata.hasXlink()) {
            mdataElem.setAttribute("href", mdata.getXlinkHref(), xlinkNS);
            if (mdata.getXlinkTitle() != null) {
                mdataElem.setAttribute("title", mdata.getXlinkTitle(), xlinkNS);
            }
        } else if (mdata.getThreddsMetadata() != null) {
            this.writeThreddsMetadata(mdataElem, mdata.getThreddsMetadata());
        } else {
            MetadataConverterIF converter = mdata.getConverter();
            if (converter != null && mdata.getContentObject() != null) {
                if (mdata.getContentObject() instanceof Element) {
                    Element mdataOrg = (Element)mdata.getContentObject();
                    List<Element> children = mdataOrg.getChildren();
                    for (Element child : children) {
                        mdataElem.addContent(child.clone());
                    }
                } else {
                    converter.addMetadataContent(mdataElem, mdata.getContentObject());
                    mdataElem.detach();
                }
            }
        }
        return mdataElem;
    }

    private Element writeProperty(InvProperty prop) {
        Element propElem = new Element("property", defNS);
        propElem.setAttribute("name", prop.getName());
        propElem.setAttribute("value", prop.getValue());
        return propElem;
    }

    protected Element writeSource(String elementName, ThreddsMetadata.Source p) {
        Element elem = new Element(elementName, defNS);
        elem.addContent(this.writeControlledVocabulary(p.getNameVocab(), "name"));
        Element contact = new Element("contact", defNS);
        if (p.getUrl() != null) {
            contact.setAttribute("url", p.getUrl());
        }
        if (p.getEmail() != null) {
            contact.setAttribute("email", p.getEmail());
        }
        elem.addContent(contact);
        return elem;
    }

    private Element writeService(InvService service) {
        Element serviceElem = new Element("service", defNS);
        serviceElem.setAttribute("name", service.getName());
        serviceElem.setAttribute("serviceType", service.getServiceType().toString());
        serviceElem.setAttribute("base", service.getBase());
        if (service.getSuffix() != null && service.getSuffix().length() > 0) {
            serviceElem.setAttribute("suffix", service.getSuffix());
        }
        for (InvProperty p : service.getProperties()) {
            serviceElem.addContent(this.writeProperty(p));
        }
        for (InvService nested : service.getServices()) {
            serviceElem.addContent(this.writeService(nested));
        }
        if (this.raw) {
            for (InvProperty p : service.getDatasetRoots()) {
                serviceElem.addContent(this.writeDatasetRoot(p));
            }
        }
        return serviceElem;
    }

    private Element writeDataSize(double size) {
        String unit;
        Element sizeElem = new Element("dataSize", defNS);
        if (useBytesForDataSize) {
            sizeElem.setAttribute("units", "bytes");
            long bytes = (long)size;
            sizeElem.setText(Long.toString(bytes));
            return sizeElem;
        }
        if (size > 1.0E15) {
            unit = "Pbytes";
            size *= 1.0E-15;
        } else if (size > 1.0E12) {
            unit = "Tbytes";
            size *= 1.0E-12;
        } else if (size > 1.0E9) {
            unit = "Gbytes";
            size *= 1.0E-9;
        } else if (size > 1000000.0) {
            unit = "Mbytes";
            size *= 1.0E-6;
        } else if (size > 1000.0) {
            unit = "Kbytes";
            size *= 0.001;
        } else {
            unit = "bytes";
        }
        sizeElem.setAttribute("units", unit);
        sizeElem.setText(Format.d(size, 4));
        return sizeElem;
    }

    protected void writeInheritedMetadata(Element elem, ThreddsMetadata tmi) {
        Element mdataElem = new Element("metadata", defNS);
        mdataElem.setAttribute("inherited", "true");
        this.writeThreddsMetadata(mdataElem, tmi);
        if (mdataElem.getChildren().size() > 0) {
            elem.addContent(mdataElem);
        }
    }

    protected void writeThreddsMetadata(Element elem, ThreddsMetadata tmg) {
        DateRange tc;
        if (tmg.getServiceName() != null) {
            Element serviceNameElem = new Element("serviceName", defNS);
            serviceNameElem.setText(tmg.getServiceName());
            elem.addContent(serviceNameElem);
        }
        if (tmg.getAuthority() != null) {
            Element authElem = new Element("authority", defNS);
            authElem.setText(tmg.getAuthority());
            elem.addContent(authElem);
        }
        if (tmg.getDataType() != null && tmg.getDataType() != FeatureType.NONE && tmg.getDataType() != FeatureType.ANY) {
            Element dataTypeElem = new Element("dataType", defNS);
            dataTypeElem.setText(tmg.getDataType().toString());
            elem.addContent(dataTypeElem);
        }
        if (tmg.getDataFormatType() != null && tmg.getDataFormatType() != DataFormatType.NONE) {
            Element dataFormatElem = new Element("dataFormat", defNS);
            dataFormatElem.setText(tmg.getDataFormatType().toString());
            elem.addContent(dataFormatElem);
        }
        if (tmg.hasDataSize()) {
            elem.addContent(this.writeDataSize(tmg.getDataSize()));
        }
        List<InvDocumentation> docList = tmg.getDocumentation();
        for (InvDocumentation doc : docList) {
            elem.addContent(this.writeDocumentation(doc, "documentation"));
        }
        List<ThreddsMetadata.Contributor> contribList = tmg.getContributors();
        for (ThreddsMetadata.Contributor c : contribList) {
            elem.addContent(this.writeContributor(c));
        }
        List<ThreddsMetadata.Source> creatorList = tmg.getCreators();
        for (ThreddsMetadata.Source p : creatorList) {
            elem.addContent(this.writeSource("creator", p));
        }
        List<ThreddsMetadata.Vocab> kewordList = tmg.getKeywords();
        for (ThreddsMetadata.Vocab v : kewordList) {
            elem.addContent(this.writeControlledVocabulary(v, "keyword"));
        }
        List<InvMetadata> mdList = tmg.getMetadata();
        for (InvMetadata m : mdList) {
            elem.addContent(this.writeMetadata(m));
        }
        List<ThreddsMetadata.Vocab> projList = tmg.getProjects();
        for (ThreddsMetadata.Vocab v : projList) {
            elem.addContent(this.writeControlledVocabulary(v, "project"));
        }
        List<InvProperty> propertyList = tmg.getProperties();
        for (InvProperty p : propertyList) {
            elem.addContent(this.writeProperty(p));
        }
        List<ThreddsMetadata.Source> pubList = tmg.getPublishers();
        for (ThreddsMetadata.Source p : pubList) {
            elem.addContent(this.writeSource("publisher", p));
        }
        List<DateType> dateList = tmg.getDates();
        for (DateType d : dateList) {
            elem.addContent(this.writeDate("date", d));
        }
        ThreddsMetadata.GeospatialCoverage gc = tmg.getGeospatialCoverage();
        if (gc != null && !gc.isEmpty()) {
            elem.addContent(this.writeGeospatialCoverage(gc));
        }
        if ((tc = tmg.getTimeCoverage()) != null) {
            elem.addContent(this.writeTimeCoverage(tc));
        }
        List<ThreddsMetadata.Variables> varList = tmg.getVariables();
        for (ThreddsMetadata.Variables v : varList) {
            elem.addContent(this.writeVariables(v));
        }
        String varMapLink = tmg.getVariableMap();
        if (varMapLink != null) {
            Element velem = new Element("variableMap", defNS);
            velem.setAttribute("href", varMapLink, xlinkNS);
            velem.setAttribute("title", "variables", xlinkNS);
            elem.addContent(velem);
        }
    }

    protected Element writeTimeCoverage(DateRange t) {
        Element telem;
        Element elem = new Element("timeCoverage", defNS);
        DateType start = t.getStart();
        DateType end = t.getEnd();
        TimeDuration duration = t.getDuration();
        TimeDuration resolution = t.getResolution();
        if (t.useStart() && start != null && !start.isBlank()) {
            Element startElem = new Element("start", defNS);
            startElem.setText(start.toString());
            elem.addContent(startElem);
        }
        if (t.useEnd() && end != null && !end.isBlank()) {
            telem = new Element("end", defNS);
            telem.setText(end.toString());
            elem.addContent(telem);
        }
        if (t.useDuration() && duration != null && !duration.isBlank()) {
            telem = new Element("duration", defNS);
            telem.setText(duration.toString());
            elem.addContent(telem);
        }
        if (t.useResolution() && resolution != null && !resolution.isBlank()) {
            telem = new Element("resolution", defNS);
            telem.setText(t.getResolution().toString());
            elem.addContent(telem);
        }
        return elem;
    }

    protected Element writeVariable(ThreddsMetadata.Variable v) {
        String id;
        String desc;
        Element elem = new Element("variable", defNS);
        if (v.getName() != null) {
            elem.setAttribute("name", v.getName());
        }
        if (v.getDescription() != null && (desc = v.getDescription().trim()).length() > 0) {
            elem.setText(v.getDescription());
        }
        if (v.getVocabularyName() != null) {
            elem.setAttribute("vocabulary_name", v.getVocabularyName());
        }
        if (v.getUnits() != null) {
            elem.setAttribute("units", v.getUnits());
        }
        if ((id = v.getVocabularyId()) != null) {
            elem.setAttribute("vocabulary_id", id);
        }
        return elem;
    }

    protected Element writeVariables(ThreddsMetadata.Variables vs) {
        Element elem = new Element("variables", defNS);
        if (vs.getVocabulary() != null) {
            elem.setAttribute("vocabulary", vs.getVocabulary());
        }
        if (vs.getVocabHref() != null) {
            elem.setAttribute("href", vs.getVocabHref(), xlinkNS);
        }
        if (vs.getMapHref() != null) {
            Element mapElem = new Element("variableMap", defNS);
            mapElem.setAttribute("href", vs.getMapHref(), xlinkNS);
            elem.addContent(mapElem);
        } else {
            List<ThreddsMetadata.Variable> varList = vs.getVariableList();
            for (ThreddsMetadata.Variable v : varList) {
                elem.addContent(this.writeVariable(v));
            }
        }
        return elem;
    }
}

