/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt.bval;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.openejb.dyni.DynamicSubclass;
import org.apache.openejb.util.proxy.LocalBeanProxyFactory;
import org.apache.openejb.util.proxy.ProxyGenerationException;
import org.apache.tomee.microprofile.jwt.bval.MethodConstraints;
import org.apache.tomee.microprofile.jwt.bval.ValidationGenerationException;
import org.apache.xbean.asm9.AnnotationVisitor;
import org.apache.xbean.asm9.ClassReader;
import org.apache.xbean.asm9.ClassVisitor;
import org.apache.xbean.asm9.ClassWriter;
import org.apache.xbean.asm9.MethodVisitor;
import org.apache.xbean.asm9.Opcodes;
import org.apache.xbean.asm9.Type;

public abstract class ValidationGenerator
implements Opcodes {
    protected final Class<?> clazz;
    protected final List<MethodConstraints> constraints;
    protected final String suffix;
    protected final Map<String, MethodVisitor> generatedMethods = new LinkedHashMap<String, MethodVisitor>();

    public ValidationGenerator(Class<?> clazz, List<MethodConstraints> constraints, String suffix) {
        this.clazz = clazz;
        this.constraints = new ArrayList<MethodConstraints>(constraints);
        this.suffix = suffix;
        Collections.sort(this.constraints);
    }

    protected abstract void generateMethods(ClassWriter var1);

    public Class<?> generateAndLoad() {
        return this.loadOrCreate();
    }

    public String getName() {
        return this.clazz.getName() + "$$" + this.suffix;
    }

    public Class<?> loadOrCreate() {
        String constraintsClassName = this.getName();
        ClassLoader classLoader = this.clazz.getClassLoader();
        try {
            return classLoader.loadClass(constraintsClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            byte[] bytes;
            try {
                bytes = this.generate();
            }
            catch (ProxyGenerationException e) {
                throw new ValidationGenerationException(this.clazz, (Throwable)e);
            }
            if (bytes == null) {
                return null;
            }
            try {
                return LocalBeanProxyFactory.Unsafe.defineClass((ClassLoader)classLoader, this.clazz, (String)constraintsClassName, (byte[])bytes);
            }
            catch (IllegalAccessException e) {
                throw new ValidationGenerationException(this.clazz, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ValidationGenerationException(this.clazz, e.getCause());
            }
        }
    }

    public byte[] generate() throws ProxyGenerationException {
        this.generatedMethods.clear();
        ClassWriter cw = new ClassWriter(2);
        String generatedClassName = this.getName().replace('.', '/');
        cw.visit(61, 33, generatedClassName, null, "java/lang/Object", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        this.generateMethods(cw);
        for (Class<?> current = this.clazz; current != null && !current.equals(Object.class); current = current.getSuperclass()) {
            try {
                ClassReader classReader = new ClassReader(DynamicSubclass.readClassFile(current));
                classReader.accept((ClassVisitor)new CopyMethodAnnotations(), 1);
                continue;
            }
            catch (IOException e) {
                throw new ProxyGenerationException((Throwable)e);
            }
        }
        return cw.toByteArray();
    }

    public class CopyMethodAnnotations
    extends ClassVisitor {
        public CopyMethodAnnotations() {
            super(589824);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            final MethodVisitor generatedMethod = ValidationGenerator.this.generatedMethods.remove(name + desc);
            if (generatedMethod == null) {
                return null;
            }
            MethodVisitor sourceMethod = super.visitMethod(access, name, desc, signature, exceptions);
            return new MethodVisitor(589824, sourceMethod){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    return generatedMethod.visitAnnotation(desc, visible);
                }

                public void visitEnd() {
                    generatedMethod.visitEnd();
                    super.visitEnd();
                }
            };
        }
    }

    public static class ConstrainedMethodVisitor
    extends MethodVisitor {
        private final List<String> approved;

        public ConstrainedMethodVisitor(MethodVisitor methodVisitor, MethodConstraints methodConstraints) {
            super(589824, methodVisitor);
            this.approved = methodConstraints.getAnnotations().stream().map(Type::getDescriptor).collect(Collectors.toList());
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (this.approved.contains(descriptor)) {
                return super.visitAnnotation(descriptor, visible);
            }
            return null;
        }
    }
}

