/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.feature.transform;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.logging.Logger;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedWriter;
import org.apache.cxf.staxutils.StaxSource;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;

public final class XSLTUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(XSLTUtils.class);

    private XSLTUtils() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static InputStream transform(Templates xsltTemplate, InputStream in) {
        try (InputStream inputStream = in;){
            InputStream inputStream2;
            try (CachedOutputStream out = new CachedOutputStream();){
                StaxSource beforeSource = new StaxSource(StaxUtils.createXMLStreamReader(inputStream));
                Transformer trans = xsltTemplate.newTransformer();
                trans.transform(beforeSource, new StreamResult(out));
                inputStream2 = out.getInputStream();
            }
            return inputStream2;
        }
        catch (IOException e) {
            throw new Fault("GET_CACHED_INPUT_STREAM", LOG, (Throwable)e, e.getMessage());
        }
        catch (TransformerException e) {
            throw new Fault("XML_TRANSFORM", LOG, (Throwable)e, e.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Reader transform(Templates xsltTemplate, Reader inReader) {
        try (Reader reader = inReader;){
            Reader reader2;
            try (CachedWriter outWriter = new CachedWriter();){
                StaxSource beforeSource = new StaxSource(StaxUtils.createXMLStreamReader(reader));
                Transformer trans = xsltTemplate.newTransformer();
                trans.transform(beforeSource, new StreamResult(outWriter));
                reader2 = outWriter.getReader();
            }
            return reader2;
        }
        catch (IOException e) {
            throw new Fault("GET_CACHED_INPUT_STREAM", LOG, (Throwable)e, e.getMessage());
        }
        catch (TransformerException e) {
            throw new Fault("XML_TRANSFORM", LOG, (Throwable)e, e.getMessage());
        }
    }

    public static Document transform(Templates xsltTemplate, Document in) {
        try {
            DOMSource beforeSource = new DOMSource(in);
            Document out = DOMUtils.createDocument();
            Transformer trans = xsltTemplate.newTransformer();
            trans.transform(beforeSource, new DOMResult(out));
            return out;
        }
        catch (TransformerException e) {
            throw new Fault("XML_TRANSFORM", LOG, (Throwable)e, e.getMessage());
        }
    }
}

