/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.engine;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.ruta.FilterManager;
import org.apache.uima.ruta.RutaBlock;
import org.apache.uima.ruta.RutaModule;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.extensions.IEngineLoader;
import org.apache.uima.ruta.extensions.IRutaExtension;
import org.apache.uima.ruta.extensions.RutaEngineLoader;
import org.apache.uima.ruta.extensions.RutaExternalFactory;
import org.apache.uima.ruta.parser.RutaLexer;
import org.apache.uima.ruta.parser.RutaParser;
import org.apache.uima.ruta.seed.RutaAnnotationSeeder;
import org.apache.uima.ruta.verbalize.RutaVerbalizer;
import org.apache.uima.ruta.visitor.CreatedByVisitor;
import org.apache.uima.ruta.visitor.DebugInfoCollectorVisitor;
import org.apache.uima.ruta.visitor.InferenceCrowd;
import org.apache.uima.ruta.visitor.RutaInferenceVisitor;
import org.apache.uima.ruta.visitor.StatisticsVisitor;
import org.apache.uima.ruta.visitor.TimeProfilerVisitor;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RutaEngine
extends JCasAnnotator_ImplBase {
    public static final String SCRIPT_FILE_EXTENSION = ".ruta";
    public static final String SOURCE_DOCUMENT_INFORMATION = "org.apache.uima.examples.SourceDocumentInformation";
    public static final String BASIC_TYPE = "org.apache.uima.ruta.type.RutaBasic";
    public static final String SEEDERS = "seeders";
    public static final String REMOVE_BASICS = "removeBasics";
    public static final String SCRIPT_PATHS = "scriptPaths";
    public static final String DESCRIPTOR_PATHS = "descriptorPaths";
    public static final String MAIN_SCRIPT = "mainScript";
    public static final String ADDITIONAL_SCRIPTS = "additionalScripts";
    public static final String ADDITIONAL_ENGINES = "additionalEngines";
    public static final String ADDITIONAL_EXTENSIONS = "additionalExtensions";
    public static final String ADDITIONAL_ENGINE_LOADERS = "additionalEngineLoaders";
    public static final String CREATE_DEBUG_INFO = "debug";
    public static final String CREATE_DEBUG_INFO_ONLY_FOR = "debugOnlyFor";
    public static final String CREATE_PROFILING_INFO = "profile";
    public static final String CREATE_STATISTIC_INFO = "statistics";
    public static final String CREATE_CREATED_BY_INFO = "createdBy";
    public static final String CREATE_MATCH_DEBUG_INFO = "debugWithMatches";
    public static final String RESOURCE_PATHS = "resourcePaths";
    public static final String SCRIPT_ENCODING = "scriptEncoding";
    public static final String DEFAULT_FILTERED_TYPES = "defaultFilteredTypes";
    public static final String DYNAMIC_ANCHORING = "dynamicAnchoring";
    public static final String RELOAD_SCRIPT = "reloadScript";
    public static final String LOW_MEMORY_PROFILE = "lowMemoryProfile";
    public static final String SIMPLE_GREEDY_FOR_COMPOSED = "simpleGreedyForComposed";
    private String[] seeders;
    private Boolean createDebugInfo;
    private String[] createDebugOnlyFor;
    private Boolean createProfilingInfo;
    private Boolean createStatisticInfo;
    private Boolean withMatches;
    private String[] resourcePaths;
    private String scriptEncoding;
    private UimaContext context;
    private RutaModule script;
    private String[] additionalScriptLocations;
    private String[] additionalEngineLocations;
    private String[] additionalExtensions;
    private String[] additionalEngineLoaders;
    private RutaExternalFactory factory;
    private RutaEngineLoader engineLoader;
    private String[] defaultFilteredTypes;
    private String mainScript;
    private String[] scriptPaths;
    private String[] descriptorPaths;
    private RutaVerbalizer verbalizer;
    private Boolean removeBasics;
    private Map<String, TypeSystemDescription> localTSDMap;
    private Boolean dynamicAnchoring;
    private Boolean reloadScript;
    private Boolean lowMemoryProfile;
    private Boolean simpleGreedyForComposed;
    private Boolean createCreatedByInfo;
    private boolean initialized = false;
    private List<Type> seedTypes;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        if (aContext == null && this.context != null) {
            aContext = this.context;
        }
        this.seeders = (String[])aContext.getConfigParameterValue(SEEDERS);
        this.removeBasics = (Boolean)aContext.getConfigParameterValue(REMOVE_BASICS);
        this.scriptPaths = (String[])aContext.getConfigParameterValue(SCRIPT_PATHS);
        this.descriptorPaths = (String[])aContext.getConfigParameterValue(DESCRIPTOR_PATHS);
        this.mainScript = (String)aContext.getConfigParameterValue(MAIN_SCRIPT);
        this.additionalScriptLocations = (String[])aContext.getConfigParameterValue(ADDITIONAL_SCRIPTS);
        this.additionalEngineLocations = (String[])aContext.getConfigParameterValue(ADDITIONAL_ENGINES);
        this.additionalExtensions = (String[])aContext.getConfigParameterValue(ADDITIONAL_EXTENSIONS);
        this.additionalEngineLoaders = (String[])aContext.getConfigParameterValue(ADDITIONAL_ENGINE_LOADERS);
        this.createDebugInfo = (Boolean)aContext.getConfigParameterValue(CREATE_DEBUG_INFO);
        this.createDebugOnlyFor = (String[])aContext.getConfigParameterValue(CREATE_DEBUG_INFO_ONLY_FOR);
        this.createProfilingInfo = (Boolean)aContext.getConfigParameterValue(CREATE_PROFILING_INFO);
        this.createStatisticInfo = (Boolean)aContext.getConfigParameterValue(CREATE_STATISTIC_INFO);
        this.createCreatedByInfo = (Boolean)aContext.getConfigParameterValue(CREATE_CREATED_BY_INFO);
        this.withMatches = (Boolean)aContext.getConfigParameterValue(CREATE_MATCH_DEBUG_INFO);
        this.resourcePaths = (String[])aContext.getConfigParameterValue(RESOURCE_PATHS);
        this.scriptEncoding = (String)aContext.getConfigParameterValue(SCRIPT_ENCODING);
        this.defaultFilteredTypes = (String[])aContext.getConfigParameterValue(DEFAULT_FILTERED_TYPES);
        this.dynamicAnchoring = (Boolean)aContext.getConfigParameterValue(DYNAMIC_ANCHORING);
        this.reloadScript = (Boolean)aContext.getConfigParameterValue(RELOAD_SCRIPT);
        this.lowMemoryProfile = (Boolean)aContext.getConfigParameterValue(LOW_MEMORY_PROFILE);
        this.simpleGreedyForComposed = (Boolean)aContext.getConfigParameterValue(SIMPLE_GREEDY_FOR_COMPOSED);
        this.removeBasics = this.removeBasics == null ? false : this.removeBasics;
        this.createDebugInfo = this.createDebugInfo == null ? false : this.createDebugInfo;
        this.createDebugOnlyFor = this.createDebugOnlyFor == null ? new String[]{} : this.createDebugOnlyFor;
        this.createProfilingInfo = this.createProfilingInfo == null ? false : this.createProfilingInfo;
        this.createStatisticInfo = this.createStatisticInfo == null ? false : this.createStatisticInfo;
        this.createCreatedByInfo = this.createCreatedByInfo == null ? false : this.createCreatedByInfo;
        this.withMatches = this.withMatches == null ? true : this.withMatches;
        this.scriptEncoding = this.scriptEncoding == null ? "UTF-8" : this.scriptEncoding;
        this.defaultFilteredTypes = this.defaultFilteredTypes == null ? new String[]{} : this.defaultFilteredTypes;
        this.dynamicAnchoring = this.dynamicAnchoring == null ? false : this.dynamicAnchoring;
        this.reloadScript = this.reloadScript == null ? false : this.reloadScript;
        this.lowMemoryProfile = this.lowMemoryProfile == null ? false : this.lowMemoryProfile;
        this.simpleGreedyForComposed = this.simpleGreedyForComposed == null ? false : this.simpleGreedyForComposed;
        this.context = aContext;
        this.factory = new RutaExternalFactory();
        this.engineLoader = new RutaEngineLoader();
        this.verbalizer = new RutaVerbalizer();
        this.localTSDMap = new HashMap<String, TypeSystemDescription>();
        if (!this.factory.isInitialized()) {
            this.initializeExtensionWithClassPath();
        }
        if (!this.engineLoader.isInitialized()) {
            this.initializeEngineLoaderWithClassPath();
        }
        if (!this.reloadScript.booleanValue()) {
            try {
                this.initializeScript("_InitialView");
            }
            catch (AnalysisEngineProcessException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        CAS cas = jcas.getCas();
        if (this.reloadScript.booleanValue() || !cas.getViewName().equals("_InitialView")) {
            this.initializeScript(cas.getViewName());
        } else {
            this.resetEnvironments(cas);
        }
        if (!this.initialized || this.reloadScript.booleanValue()) {
            this.initializeTypes(this.script, cas);
            this.initialized = true;
        }
        InferenceCrowd crowd = this.initializeCrowd();
        RutaStream stream = this.initializeStream(cas, crowd);
        stream.setDynamicAnchoring(this.dynamicAnchoring);
        try {
            this.script.apply(stream, crowd);
        }
        catch (Throwable e) {
            throw new AnalysisEngineProcessException("annotator_exception", new Object[0], e);
        }
        crowd.finished(stream);
        if (this.removeBasics.booleanValue()) {
            ArrayList<AnnotationFS> toRemove = new ArrayList<AnnotationFS>();
            Type basicType = cas.getTypeSystem().getType(BASIC_TYPE);
            AnnotationIndex basicIndex = cas.getAnnotationIndex(basicType);
            for (AnnotationFS fs : basicIndex) {
                toRemove.add(fs);
            }
            for (Type seedType : this.seedTypes) {
                AnnotationIndex seedIndex = cas.getAnnotationIndex(seedType);
                for (AnnotationFS fs : seedIndex) {
                    toRemove.add(fs);
                }
            }
            for (AnnotationFS annotationFS : toRemove) {
                cas.removeFsFromIndexes((FeatureStructure)annotationFS);
            }
        }
    }

    private void resetEnvironments(CAS cas) {
        this.resetEnvironment(this.script, cas);
        Collection<RutaModule> scripts = this.script.getScripts().values();
        for (RutaModule module : scripts) {
            this.resetEnvironment(module, cas);
        }
    }

    private void resetEnvironment(RutaModule module, CAS cas) {
        RutaBlock block = module.getBlock(null);
        block.getEnvironment().reset(cas);
        Collection<RutaBlock> blocks = module.getBlocks().values();
        for (RutaBlock each : blocks) {
            each.getEnvironment().reset(cas);
        }
    }

    private void initializeTypes(RutaModule script, CAS cas) {
        RutaBlock mainRootBlock = script.getBlock(null);
        mainRootBlock.getEnvironment().initializeTypes(cas);
        Collection<RutaModule> values = script.getScripts().values();
        for (RutaModule eachModule : values) {
            this.relinkEnvironments(eachModule, mainRootBlock);
        }
    }

    private void relinkEnvironments(RutaModule script, RutaBlock mainRootBlock) {
        RutaBlock block = script.getBlock(null);
        block.setParent(mainRootBlock);
        Collection<RutaModule> innerScripts = script.getScripts().values();
        for (RutaModule module : innerScripts) {
            this.relinkEnvironments(module, mainRootBlock);
        }
    }

    private void initializeExtensionWithClassPath() {
        if (this.additionalExtensions == null) {
            return;
        }
        for (String each : this.additionalExtensions) {
            try {
                Class<?> forName = Class.forName(each);
                if (!IRutaExtension.class.isAssignableFrom(forName)) continue;
                IRutaExtension extension = (IRutaExtension)forName.newInstance();
                this.verbalizer.addExternalVerbalizers(extension);
                for (String name : extension.getKnownExtensions()) {
                    this.factory.addExtension(name, extension);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void initializeEngineLoaderWithClassPath() {
        if (this.additionalEngineLoaders == null) {
            return;
        }
        for (String each : this.additionalEngineLoaders) {
            try {
                Class<?> forName = Class.forName(each);
                if (!IEngineLoader.class.isAssignableFrom(forName)) continue;
                IEngineLoader loader = (IEngineLoader)forName.newInstance();
                for (String name : loader.getKnownEngines()) {
                    this.engineLoader.addLoader(name, loader);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private InferenceCrowd initializeCrowd() {
        ArrayList<RutaInferenceVisitor> visitors = new ArrayList<RutaInferenceVisitor>();
        if (this.createDebugInfo.booleanValue()) {
            visitors.add(new DebugInfoCollectorVisitor(this.createDebugInfo, this.withMatches, Arrays.asList(this.createDebugOnlyFor), this.verbalizer));
        }
        if (this.createProfilingInfo.booleanValue()) {
            visitors.add(new TimeProfilerVisitor());
        }
        if (this.createStatisticInfo.booleanValue()) {
            visitors.add(new StatisticsVisitor(this.verbalizer));
        }
        if (this.createCreatedByInfo.booleanValue()) {
            visitors.add(new CreatedByVisitor(this.verbalizer));
        }
        return new InferenceCrowd(visitors);
    }

    private RutaStream initializeStream(CAS cas, InferenceCrowd crowd) throws AnalysisEngineProcessException {
        ArrayList<Type> filterTypes = new ArrayList<Type>();
        TypeSystem typeSystem = cas.getTypeSystem();
        for (String each : this.defaultFilteredTypes) {
            Type type = typeSystem.getType(each);
            if (type == null) continue;
            filterTypes.add(type);
        }
        FilterManager filter = new FilterManager(filterTypes, cas);
        Type basicType = typeSystem.getType(BASIC_TYPE);
        this.seedTypes = this.seedAnnotations(cas);
        RutaStream stream = new RutaStream(cas, basicType, filter, this.lowMemoryProfile, this.simpleGreedyForComposed, crowd);
        stream.initalizeBasics();
        return stream;
    }

    private List<Type> seedAnnotations(CAS cas) throws AnalysisEngineProcessException {
        ArrayList<Type> result = new ArrayList<Type>();
        if (this.seeders != null) {
            for (String seederClass : this.seeders) {
                Class<?> loadClass = null;
                try {
                    loadClass = Class.forName(seederClass);
                }
                catch (ClassNotFoundException e) {
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
                Object newInstance = null;
                try {
                    newInstance = loadClass.newInstance();
                }
                catch (Exception e) {
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
                try {
                    RutaAnnotationSeeder seeder = newInstance;
                    result.add(seeder.seed(cas.getDocumentText(), cas));
                }
                catch (Exception e) {
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
            }
        }
        return result;
    }

    private void initializeScript(String viewName) throws AnalysisEngineProcessException {
        if (this.mainScript == null) {
            return;
        }
        String scriptLocation = RutaEngine.locate(this.mainScript, this.scriptPaths, SCRIPT_FILE_EXTENSION);
        if (scriptLocation == null) {
            try {
                String mainScriptPath = this.mainScript.replaceAll("\\.", "/") + SCRIPT_FILE_EXTENSION;
                this.script = this.loadScriptIS(mainScriptPath, null);
            }
            catch (IOException e) {
                throw new AnalysisEngineProcessException((Throwable)new FileNotFoundException("Script [" + this.mainScript + "] cannot be found at [" + this.collectionToString(this.scriptPaths) + "] with extension .ruta"));
            }
            catch (RecognitionException e) {
                throw new AnalysisEngineProcessException((Throwable)new FileNotFoundException("Script [" + this.mainScript + "] cannot be found at [" + this.collectionToString(this.scriptPaths) + "] with extension .ruta"));
            }
        }
        try {
            this.script = this.loadScript(scriptLocation, null);
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        HashMap<String, RutaModule> additionalScripts = new HashMap<String, RutaModule>();
        HashMap<String, AnalysisEngine> additionalEngines = new HashMap<String, AnalysisEngine>();
        if (this.additionalEngineLocations != null) {
            for (String eachEngineLocation : this.additionalEngineLocations) {
                AnalysisEngine eachEngine;
                String location = RutaEngine.locate(eachEngineLocation, this.descriptorPaths, ".xml");
                if (location == null) {
                    String locationIS = RutaEngine.locateIS(eachEngineLocation, this.descriptorPaths, ".xml");
                    try {
                        eachEngine = this.engineLoader.loadEngineIS(locationIS, viewName);
                    }
                    catch (InvalidXMLException e) {
                        throw new AnalysisEngineProcessException((Throwable)new FileNotFoundException("Engine at [" + eachEngineLocation + "] cannot be found in [" + this.collectionToString(this.descriptorPaths) + "] with extension .xml (from mainScript=" + this.mainScript + " in " + this.collectionToString(this.scriptPaths)));
                    }
                    catch (ResourceInitializationException e) {
                        throw new AnalysisEngineProcessException((Throwable)new FileNotFoundException("Engine at [" + eachEngineLocation + "] cannot be found in [" + this.collectionToString(this.descriptorPaths) + "] with extension .xml (from mainScript=" + this.mainScript + " in " + this.collectionToString(this.scriptPaths)));
                    }
                    catch (IOException e) {
                        throw new AnalysisEngineProcessException((Throwable)new FileNotFoundException("Engine at [" + eachEngineLocation + "] cannot be found in [" + this.collectionToString(this.descriptorPaths) + "] with extension .xml (from mainScript=" + this.mainScript + " in " + this.collectionToString(this.scriptPaths)));
                    }
                    catch (ResourceConfigurationException e) {
                        throw new AnalysisEngineProcessException((Throwable)e);
                    }
                    catch (URISyntaxException e) {
                        throw new AnalysisEngineProcessException((Throwable)e);
                    }
                }
                try {
                    eachEngine = this.engineLoader.loadEngine(location, viewName);
                }
                catch (Exception e) {
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
                try {
                    additionalEngines.put(eachEngineLocation, eachEngine);
                    String[] eachEngineLocationPartArray = eachEngineLocation.split("\\.");
                    if (eachEngineLocationPartArray.length <= 1) continue;
                    String shortEachEngineLocation = eachEngineLocationPartArray[eachEngineLocationPartArray.length - 1];
                    additionalEngines.put(shortEachEngineLocation, eachEngine);
                }
                catch (Exception e) {
                    throw new AnalysisEngineProcessException((Throwable)e);
                }
            }
        }
        if (this.additionalScriptLocations != null) {
            for (String add : this.additionalScriptLocations) {
                this.recursiveLoadScript(add, additionalScripts, additionalEngines, viewName);
            }
        }
        for (RutaModule each : additionalScripts.values()) {
            each.setScriptDependencies(additionalScripts);
        }
        this.script.setScriptDependencies(additionalScripts);
        for (RutaModule each : additionalScripts.values()) {
            each.setEngineDependencies(additionalEngines);
        }
        this.script.setEngineDependencies(additionalEngines);
    }

    private void configureEngine(AnalysisEngine engine) throws ResourceConfigurationException {
        ConfigurationParameterDeclarations configurationParameterDeclarations = engine.getAnalysisEngineMetaData().getConfigurationParameterDeclarations();
        ConfigurationParameter configurationParameter = configurationParameterDeclarations.getConfigurationParameter(null, DESCRIPTOR_PATHS);
        if (configurationParameter != null) {
            engine.setConfigParameterValue(DESCRIPTOR_PATHS, (Object)this.descriptorPaths);
            engine.reconfigure();
        }
        if ((configurationParameter = configurationParameterDeclarations.getConfigurationParameter(null, "styleMap")) != null) {
            engine.setConfigParameterValue("styleMap", (Object)(this.mainScript + "StyleMap"));
            engine.reconfigure();
        }
    }

    public static void addSourceDocumentInformation(CAS cas, File each) {
        Type sdiType = cas.getTypeSystem().getType(SOURCE_DOCUMENT_INFORMATION);
        if (sdiType != null && cas.getAnnotationIndex(sdiType).size() == 0) {
            AnnotationFS sdi = cas.createAnnotation(sdiType, cas.getDocumentAnnotation().getBegin(), cas.getDocumentAnnotation().getEnd());
            Feature uriFeature = sdiType.getFeatureByBaseName("uri");
            sdi.setStringValue(uriFeature, each.toURI().getPath());
            cas.addFsToIndexes((FeatureStructure)sdi);
        }
    }

    public static void removeSourceDocumentInformation(CAS cas) {
        Type sdiType = cas.getTypeSystem().getType(SOURCE_DOCUMENT_INFORMATION);
        if (sdiType != null) {
            AnnotationIndex annotationIndex = cas.getAnnotationIndex(sdiType);
            ArrayList<AnnotationFS> toRemove = new ArrayList<AnnotationFS>();
            for (AnnotationFS annotationFS : annotationIndex) {
                toRemove.add(annotationFS);
            }
            for (AnnotationFS annotationFS : toRemove) {
                cas.removeFsFromIndexes((FeatureStructure)annotationFS);
            }
        }
    }

    public static String locate(String name, String[] paths, String suffix) {
        return RutaEngine.locate(name, paths, suffix, true);
    }

    public static String locateIS(String name, String[] paths, String suffix) {
        return RutaEngine.locateIS(name, paths, suffix, true);
    }

    public static String locate(String name, String[] paths, String suffix, boolean mustExist) {
        if (name == null || paths == null) {
            return null;
        }
        name = name.replaceAll("[.]", "/");
        for (String each : paths) {
            File file = new File(each, name + suffix);
            if (mustExist && !file.exists()) continue;
            return file.getAbsolutePath();
        }
        return null;
    }

    public static String locateIS(String name, String[] paths, String suffix, boolean mustExist) {
        if (name == null) {
            return null;
        }
        name = name.replaceAll("[.]", "/");
        return name + suffix;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void recursiveLoadScript(String toLoad, Map<String, RutaModule> additionalScripts, Map<String, AnalysisEngine> additionalEngines, String viewName) throws AnalysisEngineProcessException {
        String location = RutaEngine.locate(toLoad, this.scriptPaths, SCRIPT_FILE_EXTENSION);
        try {
            TypeSystemDescription localTSD = this.getLocalTSD(toLoad);
            RutaModule eachScript = this.loadScript(location, localTSD);
            additionalScripts.put(toLoad, eachScript);
            for (String add : eachScript.getScripts().keySet()) {
                if (additionalScripts.containsKey(add)) continue;
                this.recursiveLoadScript(add, additionalScripts, additionalEngines, viewName);
            }
            Set<String> engineKeySet = eachScript.getEngines().keySet();
            for (String eachEngineLocation : engineKeySet) {
                if (additionalEngines.containsKey(eachEngineLocation)) continue;
                String engineLocation = RutaEngine.locate(eachEngineLocation, this.descriptorPaths, ".xml");
                try {
                    AnalysisEngine eachEngine = this.engineLoader.loadEngine(engineLocation, viewName);
                    additionalEngines.put(eachEngineLocation, eachEngine);
                }
                catch (Exception e) {
                    throw new AnalysisEngineProcessException((Throwable)e);
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (RecognitionException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (InvalidXMLException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    private TypeSystemDescription getLocalTSD(String toLoad) throws InvalidXMLException, IOException {
        String locateTSD;
        TypeSystemDescription localTSD = this.localTSDMap.get(toLoad);
        if (localTSD == null && (locateTSD = RutaEngine.locate(toLoad, this.descriptorPaths, "TypeSystem.xml", true)) != null) {
            localTSD = UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(locateTSD));
            ResourceManager resMgr = UIMAFramework.newDefaultResourceManager();
            resMgr.setDataPath(this.getDataPath());
            localTSD.resolveImports(resMgr);
            this.localTSDMap.put(toLoad, localTSD);
        }
        return localTSD;
    }

    private String getDataPath() {
        String result = "";
        String sep = System.getProperty("path.separator");
        for (String each : this.descriptorPaths) {
            result = result + each + sep;
        }
        result = result.substring(0, result.length() - 1);
        return result;
    }

    private RutaModule loadScript(String scriptLocation, TypeSystemDescription localTSD) throws IOException, RecognitionException {
        File scriptFile = new File(scriptLocation);
        ANTLRFileStream st = new ANTLRFileStream(scriptLocation, this.scriptEncoding);
        RutaLexer lexer = new RutaLexer(st);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        RutaParser parser = new RutaParser(tokens);
        parser.setLocalTSD(localTSD);
        parser.setExternalFactory(this.factory);
        parser.setResourcePaths(this.resourcePaths);
        String name = scriptFile.getName();
        int lastIndexOf = name.lastIndexOf(SCRIPT_FILE_EXTENSION);
        name = name.substring(0, lastIndexOf);
        RutaModule script = parser.file_input(name);
        return script;
    }

    private RutaModule loadScriptIS(String scriptLocation, TypeSystemDescription localTSD) throws IOException, RecognitionException {
        InputStream scriptInputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(scriptLocation);
        ANTLRInputStream st = new ANTLRInputStream(scriptInputStream, this.scriptEncoding);
        RutaLexer lexer = new RutaLexer(st);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        RutaParser parser = new RutaParser(tokens);
        parser.setLocalTSD(localTSD);
        parser.setExternalFactory(this.factory);
        parser.setResourcePaths(this.resourcePaths);
        String name = scriptLocation;
        int lastIndexOf = name.lastIndexOf(SCRIPT_FILE_EXTENSION);
        name = name.substring(0, lastIndexOf);
        RutaModule script = parser.file_input(name);
        return script;
    }

    public RutaExternalFactory getFactory() {
        return this.factory;
    }

    public RutaEngineLoader getEngineLoader() {
        return this.engineLoader;
    }

    private String collectionToString(Collection collection) {
        StringBuilder collectionSB = new StringBuilder();
        collectionSB.append("{");
        for (Object element : collection) {
            collectionSB.append("[").append(element.toString()).append("]");
        }
        collectionSB.append("}");
        return collectionSB.toString();
    }

    private String collectionToString(Object[] collection) {
        return this.collectionToString(Arrays.asList(collection));
    }
}

