/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.TOP_Type;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.ruta.type.RutaBasic_Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RutaBasic
extends Annotation {
    private static final int INITIAL_CAPACITY = 2;
    private boolean lowMemoryProfile = true;
    private Map<String, Integer> partOf = new TreeMap<String, Integer>();
    private final Map<Type, Set<AnnotationFS>> beginMap = new HashMap<Type, Set<AnnotationFS>>(2);
    private final Map<Type, Set<AnnotationFS>> endMap = new HashMap<Type, Set<AnnotationFS>>(2);
    public static final int typeIndexID;
    public static final int type;

    public boolean isLowMemoryProfile() {
        return this.lowMemoryProfile;
    }

    public void setLowMemoryProfile(boolean lowMemoryProfile) {
        this.lowMemoryProfile = lowMemoryProfile;
    }

    public void addPartOf(Type type) {
        TypeSystem typeSystem;
        Type parent;
        Integer count = this.partOf.get(type.getName());
        if (count == null) {
            count = 0;
        }
        Integer n = count;
        Integer n2 = count = Integer.valueOf(count + 1);
        this.partOf.put(type.getName(), count);
        if (!this.lowMemoryProfile && (parent = (typeSystem = this.getCAS().getTypeSystem()).getParent(type)) != null) {
            this.addPartOf(parent);
        }
    }

    public void removePartOf(Type type) {
        TypeSystem typeSystem;
        Type parent;
        Integer count = this.partOf.get(type.getName());
        if (count != null && count > 0) {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count - 1);
            this.partOf.put(type.getName(), count);
        }
        if (!this.lowMemoryProfile && (parent = (typeSystem = this.getCAS().getTypeSystem()).getParent(type)) != null) {
            this.removePartOf(parent);
        }
    }

    public boolean isPartOf(Type type) {
        Integer count = this.partOf.get(type.getName());
        if (count != null && count > 0) {
            return true;
        }
        if (this.lowMemoryProfile) {
            List subsumedTypes = this.getCAS().getTypeSystem().getProperlySubsumedTypes(type);
            for (Type each : subsumedTypes) {
                Integer parentCount = this.partOf.get(each.getName());
                if (parentCount == null || parentCount <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public Set<AnnotationFS> getBeginAnchors(Type type) {
        Set<AnnotationFS> set = this.beginMap.get(type);
        if (this.lowMemoryProfile) {
            HashSet<AnnotationFS> result = new HashSet<AnnotationFS>();
            if (set != null) {
                result.addAll(set);
            }
            List subsumedTypes = this.getCAS().getTypeSystem().getProperlySubsumedTypes(type);
            for (Type each : subsumedTypes) {
                Set<AnnotationFS> c = this.beginMap.get(each);
                if (c == null) continue;
                result.addAll(c);
            }
            return result;
        }
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    public Set<AnnotationFS> getEndAnchors(Type type) {
        Set<AnnotationFS> set = this.endMap.get(type);
        if (this.lowMemoryProfile) {
            HashSet<AnnotationFS> result = new HashSet<AnnotationFS>(set);
            if (set != null) {
                result.addAll(set);
            }
            List subsumedTypes = this.getCAS().getTypeSystem().getProperlySubsumedTypes(type);
            for (Type each : subsumedTypes) {
                Set<AnnotationFS> c = this.endMap.get(each);
                if (c == null) continue;
                result.addAll(c);
            }
            return result;
        }
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    public boolean beginsWith(Type type) {
        if (this.beginMap.containsKey(type)) {
            return true;
        }
        if (this.lowMemoryProfile) {
            List subsumedTypes = this.getCAS().getTypeSystem().getProperlySubsumedTypes(type);
            for (Type each : subsumedTypes) {
                if (!this.beginsWith(each)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean endsWith(Type type) {
        if (this.endMap.containsKey(type)) {
            return true;
        }
        if (this.lowMemoryProfile) {
            List subsumedTypes = this.getCAS().getTypeSystem().getProperlySubsumedTypes(type);
            for (Type each : subsumedTypes) {
                if (!this.endsWith(each)) continue;
                return true;
            }
        }
        return false;
    }

    public void addBegin(AnnotationFS annotation, Type type) {
        TypeSystem typeSystem;
        Type parent;
        Set<AnnotationFS> list = this.beginMap.get(type);
        if (list == null) {
            list = new HashSet<AnnotationFS>(2);
            this.beginMap.put(type, list);
        }
        list.add(annotation);
        if (!this.lowMemoryProfile && (parent = (typeSystem = this.getCAS().getTypeSystem()).getParent(type)) != null) {
            this.addBegin(annotation, parent);
        }
    }

    public void addEnd(AnnotationFS annotation, Type type) {
        TypeSystem typeSystem;
        Type parent;
        Set<AnnotationFS> list = this.endMap.get(type);
        if (list == null) {
            list = new HashSet<AnnotationFS>(2);
            this.endMap.put(type, list);
        }
        list.add(annotation);
        if (!this.lowMemoryProfile && (parent = (typeSystem = this.getCAS().getTypeSystem()).getParent(type)) != null) {
            this.addEnd(annotation, parent);
        }
    }

    public void removeBegin(AnnotationFS annotation, Type type) {
        TypeSystem typeSystem;
        Type parent;
        Set<AnnotationFS> list = this.beginMap.get(type);
        if (list != null) {
            list.remove(annotation);
            if (list.isEmpty()) {
                this.beginMap.remove(annotation.getType());
            }
        }
        if (!this.lowMemoryProfile && (parent = (typeSystem = this.getCAS().getTypeSystem()).getParent(type)) != null) {
            this.removeBegin(annotation, parent);
        }
    }

    public void removeEnd(AnnotationFS annotation, Type type) {
        TypeSystem typeSystem;
        Type parent;
        Set<AnnotationFS> list = this.endMap.get(type);
        if (list != null) {
            list.remove(annotation);
            if (list.isEmpty()) {
                this.endMap.remove(annotation.getType());
            }
        }
        if (!this.lowMemoryProfile && (parent = (typeSystem = this.getCAS().getTypeSystem()).getParent(type)) != null) {
            this.removeEnd(annotation, parent);
        }
    }

    public Map<Type, Set<AnnotationFS>> getBeginMap() {
        return this.beginMap;
    }

    public int getTypeIndexID() {
        return typeIndexID;
    }

    protected RutaBasic() {
    }

    public RutaBasic(int addr, TOP_Type type) {
        super(addr, type);
        this.readObject();
    }

    public RutaBasic(JCas jcas) {
        super(jcas);
        this.readObject();
    }

    public RutaBasic(JCas jcas, int begin, int end) {
        super(jcas);
        this.setBegin(begin);
        this.setEnd(end);
        this.readObject();
    }

    private void readObject() {
    }

    public String getReplacement() {
        if (RutaBasic_Type.featOkTst && ((RutaBasic_Type)this.jcasType).casFeat_replacement == null) {
            this.jcasType.jcas.throwFeatMissing("replacement", "org.apache.uima.ruta.type.RutaBasic");
        }
        return this.jcasType.ll_cas.ll_getStringValue(this.addr, ((RutaBasic_Type)this.jcasType).casFeatCode_replacement);
    }

    public void setReplacement(String v) {
        if (RutaBasic_Type.featOkTst && ((RutaBasic_Type)this.jcasType).casFeat_replacement == null) {
            this.jcasType.jcas.throwFeatMissing("replacement", "org.apache.uima.ruta.type.RutaBasic");
        }
        this.jcasType.ll_cas.ll_setStringValue(this.addr, ((RutaBasic_Type)this.jcasType).casFeatCode_replacement, v);
    }

    public Map<Type, Set<AnnotationFS>> getEndMap() {
        return this.endMap;
    }

    static {
        type = typeIndexID = JCasRegistry.register(RutaBasic.class);
    }
}

