/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.ui.documentation;

import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.htmlparser.Tag;
import org.htmlparser.visitors.NodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlDocumentationVisitor
extends NodeVisitor {
    private TreeMap<String, String> map;
    private int divDepth = 0;
    private int elementStart = 0;
    private String document;

    public HtmlDocumentationVisitor(String document) {
        this.document = document;
        this.map = new TreeMap();
    }

    public void visitTag(Tag tag) {
        String name = tag.getTagName().toLowerCase();
        if ("div".equals(name)) {
            ++this.divDepth;
            if (this.divDepth == 1) {
                this.elementStart = tag.getStartPosition();
            }
        }
    }

    public void visitEndTag(Tag tag) {
        String name = tag.getTagName().toLowerCase();
        if ("div".equals(name)) {
            if (this.divDepth == 1) {
                String section = this.document.substring(this.elementStart, tag.getEndPosition());
                this.processSection(section);
            }
            --this.divDepth;
        }
    }

    private void processSection(String section) {
        Pattern pattern = Pattern.compile("title=\"\\d+\\.\\d+\\.\\d+\\.&nbsp;(\\p{Upper}+)\"");
        Matcher matcher = pattern.matcher(section);
        boolean found = matcher.find();
        if (found) {
            String group = matcher.group(1);
            section = section.trim();
            section = section.replaceAll("</?a.*>", "");
            section = section.replaceAll("\\d+\\.\\d+\\.\\d+.\\d+\\.&nbsp;", "");
            section = section.replaceAll("\\d+\\.\\d+\\.\\d+.&nbsp;", "");
            this.map.put(group, section);
        }
    }

    public Map<String, String> getMap() {
        return this.map;
    }
}

