/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.SourceElementRequestorAdaptor;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.env.MethodSourceCode;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.ICalleeProcessor;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;

public class RutaCalleeProcessor
implements ICalleeProcessor {
    protected static int EXACT_RULE = 8;
    private Map fSearchResults = new HashMap();
    private IMethod method;

    public RutaCalleeProcessor(IMethod method, IProgressMonitor monitor, IDLTKSearchScope scope) {
        this.method = method;
    }

    public Map doOperation() {
        block5: {
            try {
                if (this.method.getSource() != null) {
                    CaleeSourceElementRequestor requestor = new CaleeSourceElementRequestor();
                    ISourceElementParser parser = DLTKLanguageManager.getSourceElementParser((String)"org.apache.uima.ruta.ide.nature");
                    parser.setRequestor((ISourceElementRequestor)requestor);
                    parser.parseSourceModule((IModuleSource)new MethodSourceCode(this.method));
                }
                return this.fSearchResults;
            }
            catch (ModelException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block5;
                e.printStackTrace();
            }
        }
        return this.fSearchResults;
    }

    public IMethod[] findMethods(String methodName, int argCount, int sourcePosition) {
        ArrayList<IModelElement> methods;
        block3: {
            methods = new ArrayList<IModelElement>();
            ISourceModule module = this.method.getSourceModule();
            try {
                IModelElement[] elements = module.codeSelect(sourcePosition, methodName.length());
                for (int i = 0; i < elements.length; ++i) {
                    if (!(elements[i] instanceof IMethod)) continue;
                    methods.add(elements[i]);
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block3;
                e.printStackTrace();
            }
        }
        return methods.toArray(new IMethod[methods.size()]);
    }

    protected void search(String patternString, int searchFor, int limitTo, IDLTKSearchScope scope, SearchRequestor resultCollector) throws CoreException {
        this.search(patternString, searchFor, limitTo, EXACT_RULE, scope, resultCollector);
    }

    protected void search(String patternString, int searchFor, int limitTo, int matchRule, IDLTKSearchScope scope, SearchRequestor requestor) throws CoreException {
        if (patternString.indexOf(42) != -1 || patternString.indexOf(63) != -1) {
            matchRule |= 2;
        }
        SearchPattern pattern = SearchPattern.createPattern((String)patternString, (int)searchFor, (int)limitTo, (int)matchRule, (IDLTKLanguageToolkit)scope.getLanguageToolkit());
        new SearchEngine().search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
    }

    private class CaleeSourceElementRequestor
    extends SourceElementRequestorAdaptor {
        private CaleeSourceElementRequestor() {
        }

        public void acceptMethodReference(String methodName, int argCount, int sourcePosition, int sourceEndPosition) {
            int off;
            String name;
            block2: {
                name = new String(methodName);
                off = 0;
                try {
                    off = RutaCalleeProcessor.this.method.getSourceRange().getOffset();
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG) break block2;
                    e.printStackTrace();
                }
            }
            SimpleReference ref = new SimpleReference(off + sourcePosition, off + sourceEndPosition, name);
            IMethod[] methods = RutaCalleeProcessor.this.findMethods(name, argCount, off + sourcePosition);
            RutaCalleeProcessor.this.fSearchResults.put(ref, methods);
        }
    }
}

