/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.collections.concurrent;

import com.strobel.annotations.NotNull;
import com.strobel.collections.concurrent.ConcurrentIntObjectHashMap;
import com.strobel.collections.concurrent.ConcurrentIntObjectMap;
import com.strobel.collections.concurrent.IntObjectEntry;
import com.strobel.util.ContractUtils;
import java.lang.ref.ReferenceQueue;
import java.util.Iterator;
import java.util.NoSuchElementException;

abstract class ConcurrentRefValueIntObjectHashMap<V>
implements ConcurrentIntObjectMap<V> {
    private final ConcurrentIntObjectHashMap<IntReference<V>> _map = new ConcurrentIntObjectHashMap();
    private final ReferenceQueue<V> _queue = new ReferenceQueue();

    ConcurrentRefValueIntObjectHashMap() {
    }

    protected abstract IntReference<V> createReference(int var1, @NotNull V var2, ReferenceQueue<V> var3);

    private void processQueue() {
        IntReference reference;
        while ((reference = (IntReference)((Object)this._queue.poll())) != null) {
            this._map.remove(reference.key(), reference);
        }
        return;
    }

    @Override
    @NotNull
    public V addOrGet(int key, @NotNull V value) {
        IntReference<V> oldReference;
        boolean replaced;
        this.processQueue();
        IntReference<V> newReference = this.createReference(key, value, this._queue);
        do {
            if ((oldReference = this._map.putIfAbsent(key, newReference)) == null) {
                return value;
            }
            V oldValue = oldReference.get();
            if (oldValue == null) continue;
            return oldValue;
        } while (!(replaced = this._map.replace(key, oldReference, newReference)));
        return value;
    }

    @Override
    public V putIfAbsent(int key, @NotNull V value) {
        IntReference<V> oldReference;
        boolean replaced;
        this.processQueue();
        IntReference<V> newReference = this.createReference(key, value, this._queue);
        do {
            if ((oldReference = this._map.putIfAbsent(key, newReference)) == null) {
                return null;
            }
            V oldValue = oldReference.get();
            if (oldValue == null) continue;
            return oldValue;
        } while (!(replaced = this._map.replace(key, oldReference, newReference)));
        return null;
    }

    @Override
    public boolean remove(int key, @NotNull V value) {
        this.processQueue();
        return this._map.remove(key, this.createReference(key, value, this._queue));
    }

    @Override
    public boolean replace(int key, @NotNull V oldValue, @NotNull V newValue) {
        this.processQueue();
        return this._map.replace(key, this.createReference(key, oldValue, this._queue), this.createReference(key, newValue, this._queue));
    }

    @Override
    public V put(int key, @NotNull V value) {
        this.processQueue();
        IntReference<V> oldReference = this._map.put(key, this.createReference(key, value, this._queue));
        return oldReference != null ? (V)oldReference.get() : null;
    }

    @Override
    public V get(int key) {
        IntReference<V> reference = this._map.get(key);
        return reference != null ? (V)reference.get() : null;
    }

    @Override
    public V remove(int key) {
        this.processQueue();
        IntReference<V> reference = this._map.remove(key);
        return reference != null ? (V)reference.get() : null;
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public boolean contains(int key) {
        return this._map.contains(key);
    }

    @Override
    public void clear() {
        this._map.clear();
        this.processQueue();
    }

    @Override
    @NotNull
    public int[] keys() {
        return this._map.keys();
    }

    @Override
    @NotNull
    public Iterable<IntObjectEntry<V>> entries() {
        return new Iterable<IntObjectEntry<V>>(){

            @Override
            public Iterator<IntObjectEntry<V>> iterator() {
                return new Iterator<IntObjectEntry<V>>(){
                    final Iterator<IntObjectEntry<IntReference<V>>> entryIterator;
                    IntObjectEntry<V> next;
                    {
                        this.entryIterator = ConcurrentRefValueIntObjectHashMap.this._map.entries().iterator();
                        this.next = this.nextLiveEntry();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public IntObjectEntry<V> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        IntObjectEntry result = this.next;
                        this.next = this.nextLiveEntry();
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw ContractUtils.unsupported();
                    }

                    private IntObjectEntry<V> nextLiveEntry() {
                        while (this.entryIterator.hasNext()) {
                            IntObjectEntry entry = this.entryIterator.next();
                            final Object value = entry.value().get();
                            if (value == null) continue;
                            final int key = entry.key();
                            return new IntObjectEntry<V>(){

                                @Override
                                public int key() {
                                    return key;
                                }

                                @Override
                                @NotNull
                                public V value() {
                                    return value;
                                }
                            };
                        }
                        return null;
                    }
                };
            }
        };
    }

    protected static interface IntReference<V> {
        public int key();

        public V get();
    }
}

