/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.UimaSerializable;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.MarkerImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.cas.impl.XmiSerializationSharedData;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.internal.util.XmlElementName;
import org.apache.uima.jcas.cas.CommonList;
import org.apache.uima.jcas.cas.CommonPrimitiveArray;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.cas.NonEmptyList;
import org.apache.uima.jcas.cas.Sofa;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.util.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CasSerializerSupport {
    public static final int TYPE_CLASS_INTLIST = 101;
    public static final int TYPE_CLASS_FLOATLIST = 102;
    public static final int TYPE_CLASS_STRINGLIST = 103;
    public static final int TYPE_CLASS_FSLIST = 104;
    public static int PP_LINE_LENGTH = 120;
    public static int PP_ELEMENTS = 30;
    public static AtomicInteger errorCount = new AtomicInteger(0);
    public static final Comparator<TypeImpl> COMPARATOR_SHORT_TYPENAME = new Comparator<TypeImpl>(){

        @Override
        public int compare(TypeImpl object1, TypeImpl object2) {
            return object1.getShortName().compareTo(object2.getShortName());
        }
    };
    TypeSystemImpl filterTypeSystem;
    ErrorHandler errorHandler = null;
    Logger logger;
    public boolean isFormattedOutput;

    public CasSerializerSupport setPrettyPrint(boolean pp) {
        this.isFormattedOutput = pp;
        return this;
    }

    public CasSerializerSupport setFilterTypes(TypeSystemImpl ts) {
        this.filterTypeSystem = ts;
        return this;
    }

    public TypeSystemImpl getFilterTypes() {
        return this.filterTypeSystem;
    }

    public CasSerializerSupport setErrorHandler(ErrorHandler eh) {
        this.errorHandler = eh;
        return this;
    }

    public static final int classifyType(TypeImpl ti) {
        switch (ti.getCode()) {
            case 17: {
                return 101;
            }
            case 14: {
                return 102;
            }
            case 20: {
                return 103;
            }
            case 11: {
                return 104;
            }
        }
        return TypeSystemImpl.getTypeClass(ti);
    }

    private static boolean isArrayOrList(TOP fs) {
        return fs instanceof CommonPrimitiveArray || fs instanceof FSArray || fs instanceof CommonList;
    }

    public class CasDocSerializer {
        public final CASImpl cas;
        public final TypeSystemImpl tsi;
        public final Set<TOP> visited_not_yet_written = Collections.newSetFromMap(new IdentityHashMap());
        private final Set<TOP> enqueued_multiRef_arrays_or_lists = Collections.newSetFromMap(new IdentityHashMap());
        public final Set<TOP> multiRefFSs;
        public final boolean isDynamicMultiRef;
        public List<TOP> previouslySerializedFSs = null;
        public List<TOP> modifiedEmbeddedValueFSs = null;
        public final List<TOP>[] indexedFSs;
        private final Deque<TOP> queue;
        public XmlElementName[] typeCode2namespaceNames;
        private final BitSet typeUsed;
        public boolean needNameSpaces = true;
        public final Map<String, String> nsUriToPrefixMap = new HashMap<String, String>();
        public final Set<String> nsPrefixesUsed = new HashSet<String>();
        public final MarkerImpl marker;
        public final XmiSerializationSharedData sharedData;
        public final boolean isDelta;
        public final boolean isFiltering;
        private TypeImpl[] sortedUsedTypes;
        private final ErrorHandler errorHandler2;
        public TypeSystemImpl filterTypeSystem_inner;
        private final Map<String, String> uniqueStrings = new HashMap<String, String>();
        public final boolean isFormattedOutput_inner;
        private final CasSerializerSupportSerialize csss;
        public final Comparator<TOP> sortFssByType = new Comparator<TOP>(){

            @Override
            public int compare(TOP fs1, TOP fs2) {
                int c = Integer.compare(fs1._getTypeImpl().getCode(), fs2._getTypeImpl().getCode());
                if (c != 0) {
                    return c;
                }
                if (fs1 instanceof Annotation) {
                    Annotation fs1a = (Annotation)fs1;
                    Annotation fs2a = (Annotation)fs2;
                    c = Integer.compare(fs1a.getBegin(), fs2a.getBegin());
                    if (c != 0) {
                        return c;
                    }
                    c = Integer.compare(fs2a.getEnd(), fs1a.getEnd());
                    if (c != 0) {
                        return c;
                    }
                }
                return Integer.compare(fs1._id, fs2._id);
            }
        };

        public CasDocSerializer(ContentHandler ch, CASImpl cas, XmiSerializationSharedData sharedData, MarkerImpl marker, CasSerializerSupportSerialize csss) {
            this(ch, cas, sharedData, marker, csss, false);
        }

        public CasDocSerializer(ContentHandler ch, CASImpl cas, XmiSerializationSharedData sharedData, MarkerImpl marker, CasSerializerSupportSerialize csss, boolean trackMultiRefs) {
            this.cas = cas;
            this.csss = csss;
            this.sharedData = sharedData;
            this.filterTypeSystem_inner = CasSerializerSupport.this.filterTypeSystem;
            this.isFormattedOutput_inner = CasSerializerSupport.this.isFormattedOutput;
            this.marker = marker;
            this.errorHandler2 = CasSerializerSupport.this.errorHandler;
            this.tsi = cas.getTypeSystemImpl();
            this.queue = new ArrayDeque<TOP>();
            this.indexedFSs = new List[cas.getViewCount()];
            this.typeUsed = new BitSet();
            boolean bl = this.isFiltering = this.filterTypeSystem_inner != null && this.filterTypeSystem_inner != this.tsi;
            if (marker != null && !marker.isValid()) {
                throw new CASRuntimeException("INVALID_MARKER", "Invalid Marker.");
            }
            this.isDelta = marker != null;
            this.multiRefFSs = Collections.newSetFromMap(new IdentityHashMap());
            this.isDynamicMultiRef = trackMultiRefs;
        }

        private void reportMultiRefWarning(FeatureImpl fi) throws SAXException {
            String message = String.format("Feature %s is marked multipleReferencesAllowed=false, but it has multiple references.  These will be serialized in duplicate.", fi.getName());
            Misc.decreasingWithTrace(errorCount, message, CasSerializerSupport.this.logger);
            if (this.errorHandler2 != null) {
                this.errorHandler2.warning(new SAXParseException(message, null));
            }
        }

        public void serialize() throws Exception {
            this.typeCode2namespaceNames = new XmlElementName[this.tsi.getLargestTypeCode() + 1];
            this.sortedUsedTypes = null;
            this.typeUsed.clear();
            Arrays.fill(this.indexedFSs, null);
            this.queue.clear();
            this.csss.initializeNamespaces();
            int iElementCount = 1;
            this.enqueueIndexed();
            this.enqueueIncoming();
            this.enqueueNonsharedMultivaluedFS();
            this.enqueueFeaturesOfIndexed();
            iElementCount += this.previouslySerializedFSs == null ? 0 : this.previouslySerializedFSs.size();
            iElementCount += this.modifiedEmbeddedValueFSs == null ? 0 : this.modifiedEmbeddedValueFSs.size();
            for (List<TOP> fss : this.indexedFSs) {
                iElementCount += fss == null ? 0 : fss.size();
            }
            iElementCount += this.queue.size();
            FSIndex sofaIndex = this.cas.getBaseCAS().indexRepository.getIndex("SofaIndex");
            if (!this.isDelta) {
                iElementCount += sofaIndex.size();
                iElementCount += this.getElementCountForSharedData();
            } else {
                int numViews = this.cas.getViewCount();
                for (int sofaNum = 1; sofaNum <= numViews; ++sofaNum) {
                    FSIndexRepositoryImpl loopIR = this.cas.getBaseCAS().getSofaIndexRepository(sofaNum);
                    if (loopIR == null || !loopIR.isModified()) continue;
                    ++iElementCount;
                }
            }
            this.csss.writeFeatureStructures(iElementCount);
            this.csss.writeViews();
            this.csss.writeEndOfSerialization();
        }

        public Sofa getSofa(int sofaNum) {
            if (sofaNum != 1 || this.cas.isInitialSofaCreated()) {
                return ((CASImpl)this.cas.getView(sofaNum)).getSofaRef();
            }
            return null;
        }

        public void writeViewsCommons() throws Exception {
            int numViews = this.cas.getViewCount();
            for (int sofaNum = 1; sofaNum <= numViews; ++sofaNum) {
                Collection<TOP> fss;
                FSIndexRepositoryImpl loopIR = this.cas.getBaseCAS().getSofaIndexRepository(sofaNum);
                Sofa sofa = this.getSofa(sofaNum);
                if (loopIR == null) continue;
                if (!this.isDelta) {
                    fss = loopIR.getIndexedFSs();
                    this.csss.writeView(sofa, fss);
                    continue;
                }
                if (sofaNum != 1 && this.marker.isNew(sofa)) {
                    fss = loopIR.getIndexedFSs();
                    this.csss.writeView(sofa, fss);
                    continue;
                }
                if (!loopIR.isModified()) continue;
                this.csss.writeView(sofa, loopIR.getAddedFSs(), loopIR.getDeletedFSs(), loopIR.getReindexedFSs());
            }
        }

        public TypeImpl[] getSortedUsedTypes() {
            if (null == this.sortedUsedTypes) {
                this.sortedUsedTypes = new TypeImpl[this.typeUsed.cardinality()];
                int i = 0;
                for (TypeImpl ti : this.getUsedTypesIterable()) {
                    this.sortedUsedTypes[i++] = ti;
                }
                Arrays.sort(this.sortedUsedTypes, COMPARATOR_SHORT_TYPENAME);
            }
            return this.sortedUsedTypes;
        }

        private Iterable<TypeImpl> getUsedTypesIterable() {
            return new Iterable<TypeImpl>(){

                @Override
                public Iterator<TypeImpl> iterator() {
                    return new Iterator<TypeImpl>(){
                        private int i = 0;

                        @Override
                        public boolean hasNext() {
                            return CasDocSerializer.this.typeUsed.nextSetBit(this.i) >= 0;
                        }

                        @Override
                        public TypeImpl next() {
                            int next_i = CasDocSerializer.this.typeUsed.nextSetBit(this.i);
                            if (next_i < 0) {
                                throw new NoSuchElementException();
                            }
                            this.i = next_i + 1;
                            return (TypeImpl)CasDocSerializer.this.tsi.ll_getTypeForCode(next_i);
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }

        private void enqueueIncoming() {
            if (this.sharedData == null) {
                return;
            }
            TOP[] fss = this.sharedData.getAndSortByIdAllFSsInIdMap();
            this.previouslySerializedFSs = new ArrayList<TOP>();
            for (TOP fs : fss) {
                int typeCode;
                if (fs == null || this.isDelta && !this.marker.isModified(fs) || (typeCode = this.enqueueCommon(fs)) == -1) continue;
                this.previouslySerializedFSs.add(fs);
            }
        }

        private void enqueueIndexed() {
            FSIndexRepositoryImpl ir = (FSIndexRepositoryImpl)this.cas.getBaseCAS().getBaseIndexRepository();
            Collection<TOP> fss = ir.getIndexedFSs();
            try {
                for (TOP fs : fss) {
                    this.enqueueFsAndMaybeFeatures(fs);
                }
            }
            catch (SAXException e) {
                throw new RuntimeException("Internal error - should never happen", e);
            }
            int numViews = this.cas.getViewCount();
            for (int sofaNum = 1; sofaNum <= numViews; ++sofaNum) {
                FSIndexRepositoryImpl loopIR = this.cas.getBaseCAS().getSofaIndexRepository(sofaNum);
                if (loopIR == null) continue;
                Collection<TOP> items = loopIR.getIndexedFSs();
                for (TOP item : items) {
                    this.enqueueIndexedFs_only_not_features(sofaNum, item);
                }
            }
        }

        private void enqueueNonsharedMultivaluedFS() {
            if (this.sharedData == null || !this.isDelta) {
                return;
            }
            TOP[] fss = this.sharedData.getNonsharedMulitValuedFSs();
            this.modifiedEmbeddedValueFSs = new ArrayList<TOP>();
            for (TOP fs : fss) {
                if (!this.marker.isModified(fs)) continue;
                TOP encompassingFs = this.sharedData.getEncompassingFS(fs);
                assert (null != encompassingFs);
                if (-1 == this.enqueueCommonWithoutDeltaAndFilteringCheck(encompassingFs)) continue;
                this.modifiedEmbeddedValueFSs.add(encompassingFs);
            }
        }

        private void enqueueFeaturesOfIndexed() throws SAXException {
            if (null != this.previouslySerializedFSs) {
                this.enqueueFeaturesOfFSs(this.previouslySerializedFSs);
            }
            if (null != this.modifiedEmbeddedValueFSs) {
                this.enqueueFeaturesOfFSs(this.modifiedEmbeddedValueFSs);
            }
            for (List<TOP> fss : this.indexedFSs) {
                if (fss == null) continue;
                this.enqueueFeaturesOfFSs(fss);
            }
        }

        private void enqueueFeaturesOfFSs(List<TOP> fss) throws SAXException {
            for (TOP fs : fss) {
                this.enqueueFeatures(fs);
            }
        }

        int enqueueCommon(TOP fs) {
            return this.enqueueCommon(fs, true);
        }

        int enqueueCommonWithoutDeltaAndFilteringCheck(TOP fs) {
            return this.enqueueCommon(fs, false);
        }

        private int enqueueCommon(TOP fs, boolean doDeltaAndFilteringCheck) {
            if (doDeltaAndFilteringCheck) {
                String typeName;
                if (this.isDelta && !this.marker.isNew(fs) && !this.marker.isModified(fs)) {
                    return -1;
                }
                if (this.isFiltering && this.filterTypeSystem_inner.getType(typeName = fs._getTypeImpl().getName()) == null) {
                    return -1;
                }
            }
            if (!this.visited_not_yet_written.add(fs)) {
                boolean wasAdded;
                if ((this.isDynamicMultiRef || CasSerializerSupport.isArrayOrList(fs)) && (wasAdded = this.multiRefFSs.add(fs))) {
                    this.queue.add(fs);
                }
                return -1;
            }
            int typeCode = fs._getTypeCode();
            boolean alreadySet = this.typeUsed.get(typeCode);
            if (!alreadySet) {
                this.typeUsed.set(typeCode);
                String typeName = fs._getTypeImpl().getName();
                XmlElementName newXel = this.csss.uimaTypeName2XmiElementName(typeName);
                if (!this.needNameSpaces) {
                    this.csss.checkForNameCollision(newXel);
                }
                this.typeCode2namespaceNames[typeCode] = newXel;
            }
            return typeCode;
        }

        void enqueueIndexedFs_only_not_features(int viewNumber, TOP fs) {
            if (this.enqueueCommon(fs) != -1) {
                List<TOP> fss = this.indexedFSs[viewNumber - 1];
                if (null == fss) {
                    this.indexedFSs[viewNumber - 1] = fss = new ArrayList<TOP>();
                }
                fss.add(fs);
            }
        }

        private void enqueueFsAndMaybeFeatures(TOP fs) throws SAXException {
            if (null == fs) {
                return;
            }
            int typeCode = this.enqueueCommon(fs);
            if (typeCode == -1) {
                return;
            }
            this.queue.add(fs);
            this.enqueueFeatures(fs);
        }

        private boolean isListElementsMultiplyReferenced(TOP listNode) {
            boolean foundCycle = false;
            CommonList curNode = (CommonList)((Object)listNode);
            while (curNode instanceof NonEmptyList) {
                if (!this.visited_not_yet_written.add((TOP)((Object)curNode))) {
                    foundCycle = true;
                    break;
                }
                curNode = curNode.getCommonTail();
            }
            return foundCycle;
        }

        private boolean isMultiRef_enqueue(FeatureImpl fi, TOP featVal, boolean alreadyVisited, boolean isListNode, boolean isListFeat) throws SAXException {
            if (!this.isDynamicMultiRef) {
                boolean multiRefAllowed;
                boolean bl = multiRefAllowed = fi.isMultipleReferencesAllowed() || isListNode;
                if (!multiRefAllowed) {
                    if (isListFeat && this.isListElementsMultiplyReferenced(featVal) || !isListFeat && alreadyVisited) {
                        this.reportMultiRefWarning(fi);
                    } else if (!isListFeat) {
                        this.visited_not_yet_written.add(featVal);
                    }
                    return false;
                }
                return true;
            }
            if (alreadyVisited) {
                return !this.multiRefFSs.contains(featVal);
            }
            return true;
        }

        private void enqueueFeatures(TOP fs) throws SAXException {
            if (fs instanceof FSArray) {
                TOP[] theArray;
                for (TOP elem : theArray = ((FSArray)fs)._getTheArray()) {
                    if (this.isFiltering && null == this.filterTypeSystem_inner.getType(elem._getTypeImpl().getName()) || elem == null) continue;
                    this.enqueueFsAndMaybeFeatures(elem);
                }
                return;
            }
            boolean insideListNode = fs instanceof CommonList;
            if (fs instanceof UimaSerializable) {
                ((UimaSerializable)((Object)fs))._save_to_cas_data();
            }
            block6: for (FeatureImpl fi : fs._getTypeImpl().getFeatureImpls()) {
                if (this.isFiltering && this.filterTypeSystem_inner.getFeatureByFullName(fi.getName()) == null) continue;
                int fsClass = fi.rangeTypeClass;
                switch (fsClass) {
                    case 8: {
                        this.enqueueFsAndMaybeFeatures(fs.getFeatureValue(fi));
                        continue block6;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: {
                        TOP array = fs.getFeatureValue(fi);
                        if (null == array) continue block6;
                        boolean alreadyVisited = this.visited_not_yet_written.contains(array);
                        if (this.isMultiRef_enqueue(fi, array, alreadyVisited, false, false)) {
                            if (this.enqueued_multiRef_arrays_or_lists.add(array)) {
                                this.enqueueFsAndMaybeFeatures(array);
                                continue block6;
                            }
                            if (!this.isDynamicMultiRef) continue block6;
                            this.multiRefFSs.add(array);
                            continue block6;
                        }
                        if (!(array instanceof FSArray) || alreadyVisited) continue block6;
                        this.enqueueFSArrayElements((FSArray)array);
                        continue block6;
                    }
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: {
                        TOP startOfList_node = fs.getFeatureValue(fi);
                        if (null == startOfList_node) continue block6;
                        boolean alreadyVisited = this.visited_not_yet_written.contains(startOfList_node);
                        if (this.isMultiRef_enqueue(fi, startOfList_node, alreadyVisited, insideListNode, true)) {
                            if (this.enqueued_multiRef_arrays_or_lists.add(startOfList_node)) {
                                this.enqueueFsAndMaybeFeatures(startOfList_node);
                                continue block6;
                            }
                            if (!this.isDynamicMultiRef) continue block6;
                            this.multiRefFSs.add(startOfList_node);
                            continue block6;
                        }
                        if (!(startOfList_node instanceof FSList) || alreadyVisited) continue block6;
                        this.enqueueFSListElements((FSList)startOfList_node);
                        continue block6;
                    }
                }
            }
        }

        private void enqueueFSArrayElements(FSArray fsArray) throws SAXException {
            for (TOP elem : fsArray._getTheArray()) {
                if (elem == null) continue;
                this.enqueueFsAndMaybeFeatures(elem);
            }
        }

        private void enqueueFSListElements(FSList<TOP> node) throws SAXException {
            node.walkList_saxException(n -> this.enqueueFsAndMaybeFeatures((TOP)((NonEmptyFSList)n).getHead()), null);
        }

        public void encodeIndexed() throws Exception {
            if (null != this.previouslySerializedFSs) {
                this.encodeFSs(this.previouslySerializedFSs);
            }
            if (null != this.modifiedEmbeddedValueFSs) {
                this.encodeFSs(this.modifiedEmbeddedValueFSs);
            }
            for (List<TOP> fss : this.indexedFSs) {
                if (fss == null) continue;
                this.encodeFSs(fss);
            }
        }

        private void encodeFSs(List<TOP> fss) throws Exception {
            for (TOP fs : fss) {
                this.encodeFS(fs);
            }
        }

        public void encodeQueued() throws Exception {
            for (TOP fs : this.queue) {
                if (!this.visited_not_yet_written.contains(fs) || this.isDynamicMultiRef && !this.multiRefFSs.contains(fs)) continue;
                this.encodeFS(fs);
            }
        }

        public void encodeFS(TOP fs) throws Exception {
            int typeCode = fs._getTypeImpl().getCode();
            int typeClass = CasSerializerSupport.classifyType(fs._getTypeImpl());
            boolean isIndexId = this.csss.writeFsStart(fs, typeCode);
            if (!isIndexId && this.isDynamicMultiRef && this.multiRefFSs.contains(fs)) {
                this.csss.writeFsRef(fs);
            } else {
                this.visited_not_yet_written.remove(fs);
                switch (typeClass) {
                    case 8: {
                        this.csss.writeFs(fs, typeCode);
                        break;
                    }
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: {
                        this.csss.writeListsAsIndividualFSs(fs, typeCode);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: {
                        this.csss.writeArrays(fs, typeCode, typeClass);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Error classifying FS type.");
                    }
                }
                this.csss.writeEndOfIndividualFs();
            }
        }

        int getElementCountForSharedData() {
            return this.sharedData == null ? 0 : this.sharedData.getOutOfTypeSystemElements().size();
        }

        public String getXmiId(TOP fs) {
            int v = this.getXmiIdAsInt(fs);
            return v == 0 ? null : Integer.toString(v);
        }

        public int getXmiIdAsInt(TOP fs) {
            if (fs == null) {
                return 0;
            }
            if (this.isFiltering && null == this.filterTypeSystem_inner.getType(fs._getTypeImpl().getName())) {
                return 0;
            }
            if (this.sharedData == null) {
                return fs._id;
            }
            return this.sharedData.getXmiIdAsInt(fs);
        }

        public String getNameSpacePrefix(String uimaTypeName, String nsUri, int lastDotIndex) {
            String prefix = this.nsUriToPrefixMap.get(nsUri);
            if (prefix == null) {
                if (lastDotIndex != -1) {
                    int secondLastDotIndex = uimaTypeName.lastIndexOf(46, lastDotIndex - 1);
                    prefix = uimaTypeName.substring(secondLastDotIndex + 1, lastDotIndex);
                } else {
                    prefix = "noNamespace";
                }
                if (this.nsPrefixesUsed.contains(prefix)) {
                    String basePrefix = prefix;
                    int num = 2;
                    while (this.nsPrefixesUsed.contains(basePrefix + num)) {
                        ++num;
                    }
                    prefix = basePrefix + num;
                }
                this.nsUriToPrefixMap.put(nsUri, prefix);
                this.nsPrefixesUsed.add(prefix);
            }
            return prefix;
        }

        public String getUniqueString(String s) {
            String u = this.uniqueStrings.get(s);
            if (null == u) {
                u = s;
                this.uniqueStrings.put(s, s);
            }
            return u;
        }

        public String getTypeNameFromXmlElementName(XmlElementName xe) {
            String nsUri = xe.nsUri;
            if (nsUri == null || nsUri.length() == 0) {
                throw new UnsupportedOperationException();
            }
            int pfx = XmiCasSerializer.URIPFX.length;
            int sfx = XmiCasSerializer.URISFX.length;
            String r = nsUri.startsWith("http:///uima/noNamespace.ecore") ? "" : nsUri.substring(pfx, nsUri.length() - sfx);
            r = r.replace('/', '.');
            return r + xe.localName;
        }

        public boolean isStaticMultiRef(FeatureImpl fi) {
            return fi.isMultipleReferencesAllowed();
        }
    }

    public static abstract class CasSerializerSupportSerialize {
        protected abstract void initializeNamespaces();

        protected abstract void checkForNameCollision(XmlElementName var1);

        protected abstract void addNameSpace(XmlElementName var1);

        protected abstract XmlElementName uimaTypeName2XmiElementName(String var1);

        protected abstract void writeFeatureStructures(int var1) throws Exception;

        protected abstract void writeViews() throws Exception;

        protected abstract void writeView(Sofa var1, Collection<TOP> var2) throws Exception;

        protected abstract void writeView(Sofa var1, Collection<TOP> var2, Collection<TOP> var3, Collection<TOP> var4) throws Exception;

        protected abstract boolean writeFsStart(TOP var1, int var2) throws Exception;

        protected abstract void writeFs(TOP var1, int var2) throws Exception;

        protected abstract void writeListsAsIndividualFSs(TOP var1, int var2) throws Exception;

        protected abstract void writeArrays(TOP var1, int var2, int var3) throws Exception;

        protected abstract void writeEndOfIndividualFs() throws Exception;

        protected abstract void writeEndOfSerialization() throws Exception;

        protected abstract void writeFsRef(TOP var1) throws Exception;
    }
}

