/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import org.elasticsearch.cluster.coordination.CoordinationMetaData;
import org.elasticsearch.cluster.coordination.CoordinationState;
import org.elasticsearch.cluster.node.DiscoveryNode;

public abstract class ElectionStrategy {
    public static final ElectionStrategy DEFAULT_INSTANCE = new ElectionStrategy(){

        @Override
        protected boolean satisfiesAdditionalQuorumConstraints(DiscoveryNode localNode, long localCurrentTerm, long localAcceptedTerm, long localAcceptedVersion, CoordinationMetaData.VotingConfiguration lastCommittedConfiguration, CoordinationMetaData.VotingConfiguration lastAcceptedConfiguration, CoordinationState.VoteCollection joinVotes) {
            return true;
        }
    };

    protected ElectionStrategy() {
    }

    public final boolean isElectionQuorum(DiscoveryNode localNode, long localCurrentTerm, long localAcceptedTerm, long localAcceptedVersion, CoordinationMetaData.VotingConfiguration lastCommittedConfiguration, CoordinationMetaData.VotingConfiguration lastAcceptedConfiguration, CoordinationState.VoteCollection joinVotes) {
        return joinVotes.isQuorum(lastCommittedConfiguration) && joinVotes.isQuorum(lastAcceptedConfiguration) && this.satisfiesAdditionalQuorumConstraints(localNode, localCurrentTerm, localAcceptedTerm, localAcceptedVersion, lastCommittedConfiguration, lastAcceptedConfiguration, joinVotes);
    }

    protected abstract boolean satisfiesAdditionalQuorumConstraints(DiscoveryNode var1, long var2, long var4, long var6, CoordinationMetaData.VotingConfiguration var8, CoordinationMetaData.VotingConfiguration var9, CoordinationState.VoteCollection var10);
}

