/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.parser.antlr4;

import org.apache.groovy.parser.antlr4.GroovySyntaxError;
import org.apache.groovy.parser.antlr4.PositionInfo;

public interface SyntaxErrorReportable {
    default public void require(boolean condition, String msg, int offset, boolean toAttachPositionInfo) {
        if (condition) {
            return;
        }
        this.throwSyntaxError(msg, offset, toAttachPositionInfo);
    }

    default public void require(boolean condition, String msg, boolean toAttachPositionInfo) {
        this.require(condition, msg, 0, toAttachPositionInfo);
    }

    default public void require(boolean condition, String msg, int offset) {
        this.require(condition, msg, offset, false);
    }

    default public void require(boolean condition, String msg) {
        this.require(condition, msg, false);
    }

    default public void throwSyntaxError(String msg, int offset, boolean toAttachPositionInfo) {
        PositionInfo positionInfo = this.genPositionInfo(offset);
        throw new GroovySyntaxError(msg + (toAttachPositionInfo ? positionInfo.toString() : ""), this.getSyntaxErrorSource(), positionInfo.getLine(), positionInfo.getColumn());
    }

    public int getSyntaxErrorSource();

    default public PositionInfo genPositionInfo(int offset) {
        return new PositionInfo(this.getErrorLine(), this.getErrorColumn() + offset);
    }

    public int getErrorLine();

    public int getErrorColumn();
}

