/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.bundle;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.karaf.cellar.core.CellarSupport;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.util.bundles.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.startlevel.BundleStartLevel;

public class BundleSupport
extends CellarSupport {
    protected BundleContext bundleContext;
    private FeaturesService featuresService;

    public void installBundleFromLocation(String location, Integer level) throws BundleException {
        Bundle bundle = this.getBundleContext().installBundle(location);
        if (level != null) {
            ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).setStartLevel(level.intValue());
        }
    }

    public boolean isInstalled(String location) {
        return this.findBundle(location) != null;
    }

    public boolean isStarted(String location) {
        Bundle[] bundles;
        for (Bundle bundle : bundles = this.getBundleContext().getBundles()) {
            if (!bundle.getLocation().equals(location) || bundle.getState() != 32) continue;
            return true;
        }
        return false;
    }

    public void uninstallBundle(String symbolicName, String version) throws BundleException {
        Bundle[] bundles = this.getBundleContext().getBundles();
        if (bundles != null) {
            for (Bundle bundle : bundles) {
                if (!bundle.getSymbolicName().equals(symbolicName) || !((String)bundle.getHeaders().get("Bundle-Version")).toString().equals(version)) continue;
                bundle.uninstall();
            }
        }
    }

    public void startBundle(String symbolicName, String version) throws BundleException {
        Bundle[] bundles = this.getBundleContext().getBundles();
        if (bundles != null) {
            for (Bundle bundle : bundles) {
                if (!bundle.getSymbolicName().equals(symbolicName) || !((String)bundle.getHeaders().get("Bundle-Version")).toString().equals(version)) continue;
                bundle.start();
            }
        }
    }

    public void stopBundle(String symbolicName, String version) throws BundleException {
        Bundle[] bundles = this.getBundleContext().getBundles();
        if (bundles != null) {
            for (Bundle bundle : bundles) {
                if (!bundle.getSymbolicName().equals(symbolicName) || !((String)bundle.getHeaders().get("Bundle-Version")).toString().equals(version)) continue;
                bundle.stop();
            }
        }
    }

    public void updateBundle(String symbolicName, String version, String location) throws BundleException {
        Bundle[] bundles = this.getBundleContext().getBundles();
        if (bundles != null) {
            for (Bundle bundle : bundles) {
                if (!bundle.getSymbolicName().equals(symbolicName) || !((String)bundle.getHeaders().get("Bundle-Version")).toString().equals(version)) continue;
                if (location != null) {
                    try {
                        this.update(bundle, new URL(location));
                        continue;
                    }
                    catch (Exception e) {
                        throw new BundleException("Can't update bundle", (Throwable)e);
                    }
                }
                String loc = (String)bundle.getHeaders().get("Bundle-UpdateLocation");
                if (loc != null && !loc.equals(bundle.getLocation())) {
                    try {
                        this.update(bundle, new URL(loc));
                        continue;
                    }
                    catch (Exception e) {
                        throw new BundleException("Can't update bundle", (Throwable)e);
                    }
                }
                bundle.update();
            }
        }
    }

    private void update(Bundle bundle, URL location) throws IOException, BundleException {
        try (InputStream is = location.openStream();){
            File file = BundleUtils.fixBundleWithUpdateLocation(is, location.toString());
            try (FileInputStream fis = new FileInputStream(file);){
                bundle.update((InputStream)fis);
            }
            file.delete();
        }
    }

    protected List<Feature> retrieveFeature(String bundleLocation) throws Exception {
        Feature[] features = this.featuresService.listFeatures();
        ArrayList<Feature> matchingFeatures = new ArrayList<Feature>();
        for (Feature feature : features) {
            List bundles = feature.getBundles();
            for (BundleInfo bundleInfo : bundles) {
                String location = bundleInfo.getLocation();
                if (!location.equalsIgnoreCase(bundleLocation)) continue;
                matchingFeatures.add(feature);
                LOGGER.debug("CELLAR BUNDLE: found a feature {} containing bundle {}", (Object)feature.getName(), (Object)bundleLocation);
            }
        }
        return matchingFeatures;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public FeaturesService getFeaturesService() {
        return this.featuresService;
    }

    public void setFeaturesService(FeaturesService featureService) {
        this.featuresService = featureService;
    }

    protected Bundle findBundle(String location) {
        Bundle[] bundles;
        for (Bundle bundle : bundles = this.getBundleContext().getBundles()) {
            if (!bundle.getLocation().equals(location)) continue;
            return bundle;
        }
        return null;
    }
}

