/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.baseplugin.actions;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Persona;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.actions.ActionExecutor;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.ConfigSharingService;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.api.services.PrivacyService;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.api.services.SchedulerService;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeProfilesOnPropertyAction
implements ActionExecutor {
    private static final Logger logger = LoggerFactory.getLogger((String)MergeProfilesOnPropertyAction.class.getName());
    private ProfileService profileService;
    private PersistenceService persistenceService;
    private EventService eventService;
    private DefinitionsService definitionsService;
    private PrivacyService privacyService;
    private ConfigSharingService configSharingService;
    private SchedulerService schedulerService;
    private int maxProfilesInOneMerge = 50;

    public int execute(Action action, Event event) {
        HttpServletResponse httpServletResponse = (HttpServletResponse)event.getAttributes().get("http_response");
        HttpServletRequest httpServletRequest = (HttpServletRequest)event.getAttributes().get("http_request");
        Profile eventProfile = event.getProfile();
        String mergePropName = (String)action.getParameterValues().get("mergeProfilePropertyName");
        String mergePropValue = (String)action.getParameterValues().get("mergeProfilePropertyValue");
        boolean forceEventProfileAsMaster = action.getParameterValues().containsKey("forceEventProfileAsMaster") ? (Boolean)action.getParameterValues().get("forceEventProfileAsMaster") : false;
        String currentProfileMergeValue = (String)eventProfile.getSystemProperties().get(mergePropName);
        if (eventProfile instanceof Persona || eventProfile.isAnonymousProfile() || StringUtils.isEmpty((CharSequence)mergePropName) || StringUtils.isEmpty((CharSequence)mergePropValue)) {
            return 0;
        }
        List<Profile> profilesToBeMerge = this.getProfilesToBeMerge(mergePropName, mergePropValue);
        if (StringUtils.isNotEmpty((CharSequence)currentProfileMergeValue) && !currentProfileMergeValue.equals(mergePropValue)) {
            String reassignProfileId = this.reassignCurrentBrowsingData(event, profilesToBeMerge, forceEventProfileAsMaster, mergePropName, mergePropValue);
            this.sendProfileCookie(reassignProfileId, httpServletResponse, httpServletRequest);
            return 6;
        }
        boolean profileUpdated = false;
        if (StringUtils.isEmpty((CharSequence)currentProfileMergeValue)) {
            profileUpdated = true;
            eventProfile.getSystemProperties().put(mergePropName, mergePropValue);
        }
        if (profilesToBeMerge.isEmpty()) {
            return profileUpdated ? 4 : 0;
        }
        if (profilesToBeMerge.stream().noneMatch(p -> StringUtils.equals((CharSequence)p.getItemId(), (CharSequence)eventProfile.getItemId()))) {
            profilesToBeMerge.add(eventProfile);
        }
        String eventProfileId = eventProfile.getItemId();
        Profile masterProfile = this.profileService.mergeProfiles(forceEventProfileAsMaster ? eventProfile : profilesToBeMerge.get(0), profilesToBeMerge);
        String masterProfileId = masterProfile.getItemId();
        if (!forceEventProfileAsMaster && masterProfileId.equals(eventProfileId)) {
            return profileUpdated ? 4 : 0;
        }
        if (this.privacyService.isRequireAnonymousBrowsing(eventProfile).booleanValue()) {
            this.privacyService.setRequireAnonymousBrowsing(masterProfileId, true, event.getScope());
        }
        boolean anonymousBrowsing = this.privacyService.isRequireAnonymousBrowsing(masterProfileId);
        this.sendProfileCookie(eventProfileId, httpServletResponse, httpServletRequest);
        if (event.getSession() != null) {
            event.getSession().setProfile(anonymousBrowsing ? this.privacyService.getAnonymousProfile(masterProfile) : masterProfile);
        }
        event.setProfileId(anonymousBrowsing ? null : masterProfileId);
        event.setProfile(masterProfile);
        event.getActionPostExecutors().add(() -> {
            try {
                List mergedProfiles = profilesToBeMerge.stream().filter(mergedProfile -> !StringUtils.equals((CharSequence)mergedProfile.getItemId(), (CharSequence)masterProfileId)).collect(Collectors.toList());
                this.reassignPersistedBrowsingDatasAsync(anonymousBrowsing, mergedProfiles.stream().map(Item::getItemId).collect(Collectors.toList()), masterProfileId);
                if (event.isPersistent()) {
                    this.persistenceService.save((Item)event);
                }
                for (Profile mergedProfile2 : mergedProfiles) {
                    boolean isExist;
                    mergedProfile2.setMergedWith(masterProfileId);
                    mergedProfile2.setSystemProperty("lastUpdated", (Object)new Date());
                    boolean bl = isExist = this.persistenceService.load(mergedProfile2.getItemId(), Profile.class) != null;
                    if (!isExist) {
                        this.persistenceService.save((Item)mergedProfile2);
                        continue;
                    }
                    HashMap<String, Object> sourceMap = new HashMap<String, Object>();
                    sourceMap.put("mergedWith", masterProfileId);
                    sourceMap.put("systemProperties", mergedProfile2.getSystemProperties());
                    this.persistenceService.update((Item)mergedProfile2, null, Profile.class, sourceMap, true);
                }
            }
            catch (Exception e) {
                logger.error("unable to execute callback action, profile and session will not be saved", (Throwable)e);
                return false;
            }
            return true;
        });
        return 6;
    }

    private void sendProfileCookie(String profileId, HttpServletResponse response, HttpServletRequest request) {
        if (response != null && request != null) {
            String profileIdCookieName = (String)this.configSharingService.getProperty("profileIdCookieName");
            String profileIdCookieDomain = (String)this.configSharingService.getProperty("profileIdCookieDomain");
            Integer profileIdCookieMaxAgeInSeconds = (Integer)this.configSharingService.getProperty("profileIdCookieMaxAgeInSeconds");
            Boolean profileIdCookieHttpOnly = (Boolean)this.configSharingService.getProperty("profileIdCookieHttpOnly");
            response.addHeader("Set-Cookie", profileIdCookieName + "=" + profileId + "; Path=/; Max-Age=" + profileIdCookieMaxAgeInSeconds + (StringUtils.isNotBlank((CharSequence)profileIdCookieDomain) ? "; Domain=" + profileIdCookieDomain : "") + "; SameSite=Lax" + (request.isSecure() ? "; Secure" : "") + (profileIdCookieHttpOnly != false ? "; HttpOnly" : ""));
        }
    }

    private List<Profile> getProfilesToBeMerge(String mergeProfilePropertyName, String mergeProfilePropertyValue) {
        Condition propertyCondition = new Condition(this.definitionsService.getConditionType("profilePropertyCondition"));
        propertyCondition.setParameter("comparisonOperator", (Object)"equals");
        propertyCondition.setParameter("propertyName", (Object)("systemProperties." + mergeProfilePropertyName));
        propertyCondition.setParameter("propertyValue", (Object)mergeProfilePropertyValue);
        return this.persistenceService.query(propertyCondition, "properties.firstVisit", Profile.class, 0, this.maxProfilesInOneMerge).getList();
    }

    private void reassignPersistedBrowsingDatasAsync(final boolean anonymousBrowsing, final List<String> mergedProfileIds, final String masterProfileId) {
        this.schedulerService.getSharedScheduleExecutorService().schedule(new TimerTask(){

            @Override
            public void run() {
                if (!anonymousBrowsing) {
                    Condition profileIdsCondition = new Condition(MergeProfilesOnPropertyAction.this.definitionsService.getConditionType("eventPropertyCondition"));
                    profileIdsCondition.setParameter("propertyName", (Object)"profileId");
                    profileIdsCondition.setParameter("comparisonOperator", (Object)"in");
                    profileIdsCondition.setParameter("propertyValues", (Object)mergedProfileIds);
                    String[] scripts = new String[]{"updateProfileId"};
                    Map[] scriptParams = new Map[]{Collections.singletonMap("profileId", masterProfileId)};
                    Condition[] conditions = new Condition[]{profileIdsCondition};
                    MergeProfilesOnPropertyAction.this.persistenceService.updateWithQueryAndStoredScript(null, new Class[]{Session.class, Event.class}, scripts, scriptParams, conditions, false);
                } else {
                    for (String mergedProfileId : mergedProfileIds) {
                        MergeProfilesOnPropertyAction.this.privacyService.anonymizeBrowsingData(mergedProfileId);
                    }
                }
            }
        }, 1000L, TimeUnit.MILLISECONDS);
    }

    private String reassignCurrentBrowsingData(Event event, List<Profile> existingMergedProfiles, boolean forceEventProfileAsMaster, String mergePropName, String mergePropValue) {
        Profile eventProfile = event.getProfile();
        if (existingMergedProfiles.size() > 0) {
            eventProfile = existingMergedProfiles.get(0);
        } else {
            if (!forceEventProfileAsMaster) {
                eventProfile = new Profile(UUID.randomUUID().toString());
                eventProfile.setProperty("firstVisit", (Object)event.getTimeStamp());
            }
            eventProfile.getSystemProperties().put(mergePropName, mergePropValue);
        }
        logger.info("Different users, switch to {}", (Object)eventProfile.getItemId());
        event.setProfileId(eventProfile.getItemId());
        event.setProfile(eventProfile);
        if (event.getSession() != null) {
            Session eventSession = event.getSession();
            eventSession.setProfile(eventProfile);
            this.eventService.send(new Event("sessionReassigned", eventSession, eventProfile, event.getScope(), (Item)event, (Item)eventSession, null, event.getTimeStamp(), false));
        }
        return eventProfile.getItemId();
    }

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public void setPrivacyService(PrivacyService privacyService) {
        this.privacyService = privacyService;
    }

    public void setDefinitionsService(DefinitionsService definitionsService) {
        this.definitionsService = definitionsService;
    }

    public void setConfigSharingService(ConfigSharingService configSharingService) {
        this.configSharingService = configSharingService;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void setMaxProfilesInOneMerge(String maxProfilesInOneMerge) {
        this.maxProfilesInOneMerge = Integer.parseInt(maxProfilesInOneMerge);
    }
}

