/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.webconsole.http;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.apache.karaf.http.core.ProxyService;
import org.apache.karaf.util.tracker.BaseActivator;
import org.apache.karaf.util.tracker.annotation.RequireService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.apache.karaf.webconsole.http.HttpPlugin;
import org.apache.karaf.webconsole.http.ServletEventHandler;
import org.apache.karaf.webconsole.http.WebEventHandler;
import org.ops4j.pax.web.service.spi.ServletListener;
import org.ops4j.pax.web.service.spi.WebListener;

@Services(requires={@RequireService(value=ProxyService.class)})
public class Activator
extends BaseActivator {
    private HttpPlugin httpPlugin;
    private ServletEventHandler eaHandler;
    private WebEventHandler webEaHandler;

    @Override
    protected void doStart() throws Exception {
        ProxyService proxyService = this.getTrackedService(ProxyService.class);
        if (proxyService == null) {
            return;
        }
        this.eaHandler = new ServletEventHandler();
        this.eaHandler.setBundleContext(this.bundleContext);
        this.eaHandler.init();
        this.register(ServletListener.class, this.eaHandler);
        this.webEaHandler = new WebEventHandler();
        this.webEaHandler.setBundleContext(this.bundleContext);
        this.webEaHandler.init();
        this.register(WebListener.class, this.webEaHandler);
        this.httpPlugin = new HttpPlugin();
        this.httpPlugin.setBundleContext(this.bundleContext);
        this.httpPlugin.setServletEventHandler(this.eaHandler);
        this.httpPlugin.setWebEventHandler(this.webEaHandler);
        this.httpPlugin.setProxyService(proxyService);
        this.httpPlugin.start();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("felix.webconsole.label", "http");
        this.register(Servlet.class, this.httpPlugin, props);
    }

    @Override
    protected void doStop() {
        super.doStop();
        if (this.httpPlugin != null) {
            this.httpPlugin.stop();
            this.httpPlugin = null;
        }
        if (this.eaHandler != null) {
            this.eaHandler.destroy();
            this.eaHandler = null;
        }
        if (this.webEaHandler != null) {
            this.webEaHandler.destroy();
            this.webEaHandler = null;
        }
    }
}

