/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.NamedDelegate;
import groovy.transform.NamedParam;
import groovy.transform.NamedVariant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.groovy.ast.tools.AnnotatedNodeUtils;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.apache.groovy.ast.tools.VisibilityUtils;
import org.codehaus.groovy.antlr.PrimitiveHelper;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.SEMANTIC_ANALYSIS)
public class NamedVariantASTTransformation
extends AbstractASTTransformation {
    private static final ClassNode NAMED_VARIANT_TYPE = ClassHelper.make(NamedVariant.class);
    private static final String NAMED_VARIANT = "@" + NAMED_VARIANT_TYPE.getNameWithoutPackage();
    private static final ClassNode NAMED_PARAM_TYPE = ClassHelper.makeWithoutCaching(NamedParam.class, false);
    private static final ClassNode NAMED_DELEGATE_TYPE = ClassHelper.makeWithoutCaching(NamedDelegate.class, false);

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        MethodNode mNode = (MethodNode)nodes[1];
        AnnotationNode anno = (AnnotationNode)nodes[0];
        if (!NAMED_VARIANT_TYPE.equals(anno.getClassNode())) {
            return;
        }
        Parameter[] fromParams = mNode.getParameters();
        if (fromParams.length == 0) {
            this.addError("Error during " + NAMED_VARIANT + " processing. No-args method not supported.", mNode);
            return;
        }
        boolean autoDelegate = this.memberHasValue(anno, "autoDelegate", true);
        Parameter mapParam = GeneralUtils.param(GenericsUtils.nonGeneric(ClassHelper.MAP_TYPE), "__namedArgs");
        ArrayList<Parameter> genParams = new ArrayList<Parameter>();
        genParams.add(mapParam);
        ClassNode cNode = mNode.getDeclaringClass();
        BlockStatement inner = new BlockStatement();
        ArgumentListExpression args = new ArgumentListExpression();
        ArrayList<String> propNames = new ArrayList<String>();
        boolean annoFound = false;
        for (Parameter fromParam : fromParams) {
            if (!AnnotatedNodeUtils.hasAnnotation(fromParam, NAMED_PARAM_TYPE) && !AnnotatedNodeUtils.hasAnnotation(fromParam, NAMED_DELEGATE_TYPE)) continue;
            annoFound = true;
        }
        if (!annoFound && autoDelegate) {
            this.processDelegateParam(mNode, mapParam, args, propNames, fromParams[0]);
        } else {
            for (Parameter fromParam : fromParams) {
                if (!annoFound) {
                    if (this.processImplicitNamedParam(mNode, mapParam, args, propNames, fromParam)) continue;
                    return;
                }
                if (AnnotatedNodeUtils.hasAnnotation(fromParam, NAMED_PARAM_TYPE)) {
                    if (this.processExplicitNamedParam(mNode, mapParam, inner, args, propNames, fromParam)) continue;
                    return;
                }
                if (AnnotatedNodeUtils.hasAnnotation(fromParam, NAMED_DELEGATE_TYPE)) {
                    if (this.processDelegateParam(mNode, mapParam, args, propNames, fromParam)) continue;
                    return;
                }
                args.addExpression(GeneralUtils.varX(fromParam));
                if (this.hasDuplicates(mNode, propNames, fromParam.getName())) {
                    return;
                }
                genParams.add(fromParam);
            }
        }
        this.createMapVariant(mNode, anno, mapParam, genParams, cNode, inner, args, propNames);
    }

    private boolean processImplicitNamedParam(MethodNode mNode, Parameter mapParam, ArgumentListExpression args, List<String> propNames, Parameter fromParam) {
        boolean required = fromParam.hasInitialExpression();
        String name = fromParam.getName();
        if (this.hasDuplicates(mNode, propNames, name)) {
            return false;
        }
        AnnotationNode namedParam = new AnnotationNode(NAMED_PARAM_TYPE);
        namedParam.addMember("value", GeneralUtils.constX(name));
        namedParam.addMember("type", GeneralUtils.classX(fromParam.getType()));
        namedParam.addMember("required", GeneralUtils.constX(required, true));
        mapParam.addAnnotation(namedParam);
        args.addExpression(GeneralUtils.propX((Expression)GeneralUtils.varX(mapParam), name));
        return true;
    }

    private boolean processExplicitNamedParam(MethodNode mNode, Parameter mapParam, BlockStatement inner, ArgumentListExpression args, List<String> propNames, Parameter fromParam) {
        AnnotationNode namedParam = fromParam.getAnnotations(NAMED_PARAM_TYPE).get(0);
        boolean required = this.memberHasValue(namedParam, "required", true);
        if (NamedVariantASTTransformation.getMemberStringValue(namedParam, "value") == null) {
            namedParam.addMember("value", GeneralUtils.constX(fromParam.getName()));
        }
        String name = NamedVariantASTTransformation.getMemberStringValue(namedParam, "value");
        if (this.getMemberValue(namedParam, "type") == null) {
            namedParam.addMember("type", GeneralUtils.classX(fromParam.getType()));
        }
        if (this.hasDuplicates(mNode, propNames, name)) {
            return false;
        }
        if (required) {
            if (fromParam.hasInitialExpression()) {
                this.addError("Error during " + NAMED_VARIANT + " processing. A required parameter can't have an initial value.", mNode);
                return false;
            }
            inner.addStatement(new AssertStatement(GeneralUtils.boolX(GeneralUtils.callX((Expression)GeneralUtils.varX(mapParam), "containsKey", (Expression)GeneralUtils.args(GeneralUtils.constX(name)))), GeneralUtils.plusX(GeneralUtils.constX("Missing required named argument '" + name + "'. Keys found: "), GeneralUtils.callX(GeneralUtils.varX(mapParam), "keySet"))));
        }
        args.addExpression(GeneralUtils.propX((Expression)GeneralUtils.varX(mapParam), name));
        mapParam.addAnnotation(namedParam);
        fromParam.getAnnotations().remove(namedParam);
        return true;
    }

    private boolean processDelegateParam(MethodNode mNode, Parameter mapParam, ArgumentListExpression args, List<String> propNames, Parameter fromParam) {
        if (ClassNodeUtils.isInnerClass(fromParam.getType()) && mNode.isStatic()) {
            this.addError("Error during " + NAMED_VARIANT + " processing. Delegate type '" + fromParam.getType().getNameWithoutPackage() + "' is an inner class which is not supported.", mNode);
            return false;
        }
        HashSet<String> names = new HashSet<String>();
        List<PropertyNode> props = GeneralUtils.getAllProperties(names, fromParam.getType(), true, false, false, true, false, true);
        for (String string : names) {
            if (!this.hasDuplicates(mNode, propNames, string)) continue;
            return false;
        }
        ArrayList<MapEntryExpression> entries = new ArrayList<MapEntryExpression>();
        for (PropertyNode pNode : props) {
            String name = pNode.getName();
            Expression defaultValue = Optional.ofNullable(pNode.getInitialExpression()).orElseGet(() -> this.getDefaultExpression(pNode.getType()));
            entries.add(GeneralUtils.entryX(GeneralUtils.constX(name), GeneralUtils.callX((Expression)GeneralUtils.varX(mapParam), "getOrDefault", (Expression)GeneralUtils.args(GeneralUtils.constX(name), defaultValue))));
            AnnotationNode namedParam = new AnnotationNode(NAMED_PARAM_TYPE);
            namedParam.addMember("value", GeneralUtils.constX(name));
            namedParam.addMember("type", GeneralUtils.classX(pNode.getType()));
            mapParam.addAnnotation(namedParam);
        }
        MapExpression mapExpression = GeneralUtils.mapX(entries);
        args.addExpression(GeneralUtils.castX(fromParam.getType(), mapExpression));
        return true;
    }

    private Expression getDefaultExpression(ClassNode pType) {
        return Optional.ofNullable(PrimitiveHelper.getDefaultValueForPrimitive(pType)).orElse(GeneralUtils.nullX());
    }

    private boolean hasDuplicates(MethodNode mNode, List<String> propNames, String next) {
        if (propNames.contains(next)) {
            this.addError("Error during " + NAMED_VARIANT + " processing. Duplicate property '" + next + "' found.", mNode);
            return true;
        }
        propNames.add(next);
        return false;
    }

    private void createMapVariant(MethodNode mNode, AnnotationNode anno, Parameter mapParam, List<Parameter> genParams, ClassNode cNode, BlockStatement inner, ArgumentListExpression args, List<String> propNames) {
        Parameter namedArgKey = GeneralUtils.param(ClassHelper.STRING_TYPE, "namedArgKey");
        inner.addStatement(new ForStatement(namedArgKey, GeneralUtils.callX(GeneralUtils.varX(mapParam), "keySet"), new AssertStatement(GeneralUtils.boolX(GeneralUtils.callX((Expression)GeneralUtils.list2args(propNames), "contains", (Expression)GeneralUtils.varX(namedArgKey))), GeneralUtils.plusX(GeneralUtils.constX("Unrecognized namedArgKey: "), GeneralUtils.varX(namedArgKey)))));
        Parameter[] genParamsArray = genParams.toArray(Parameter.EMPTY_ARRAY);
        if (cNode.hasMethod(mNode.getName(), genParamsArray)) {
            this.addError("Error during " + NAMED_VARIANT + " processing. Class " + cNode.getNameWithoutPackage() + " already has a named-arg " + (mNode instanceof ConstructorNode ? "constructor" : "method") + " of type " + genParams, mNode);
            return;
        }
        BlockStatement body = new BlockStatement();
        int modifiers = VisibilityUtils.getVisibility(anno, mNode, mNode.getClass(), mNode.getModifiers());
        if (mNode instanceof ConstructorNode) {
            body.addStatement(GeneralUtils.stmt(GeneralUtils.ctorX(ClassNode.THIS, args)));
            body.addStatement(inner);
            ClassNodeUtils.addGeneratedConstructor(cNode, modifiers, genParamsArray, mNode.getExceptions(), body);
        } else {
            body.addStatement(inner);
            body.addStatement(GeneralUtils.stmt(GeneralUtils.callThisX(mNode.getName(), args)));
            ClassNodeUtils.addGeneratedMethod(cNode, mNode.getName(), modifiers, mNode.getReturnType(), genParamsArray, mNode.getExceptions(), body);
        }
    }
}

