/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.codec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.aries.jmx.codec.PropertyData;
import org.apache.aries.jmx.util.FrameworkUtils;
import org.apache.aries.jmx.util.TypeUtils;
import org.osgi.framework.ServiceReference;
import org.osgi.jmx.JmxConstants;
import org.osgi.jmx.framework.ServiceStateMBean;

public class ServiceData {
    private long serviceId;
    private long bundleId;
    private String[] serviceInterfaces;
    private List<PropertyData<? extends Object>> properties = new ArrayList<PropertyData<? extends Object>>();
    private long[] usingBundles;

    private ServiceData() {
    }

    public ServiceData(ServiceReference<?> serviceReference) throws IllegalArgumentException {
        if (serviceReference == null) {
            throw new IllegalArgumentException("Argument serviceReference cannot be null");
        }
        this.serviceId = (Long)serviceReference.getProperty("service.id");
        this.bundleId = serviceReference.getBundle().getBundleId();
        this.serviceInterfaces = (String[])serviceReference.getProperty("objectClass");
        this.usingBundles = FrameworkUtils.getBundleIds(serviceReference.getUsingBundles());
        for (String propertyKey : serviceReference.getPropertyKeys()) {
            this.properties.add(PropertyData.newInstance(propertyKey, serviceReference.getProperty(propertyKey)));
        }
    }

    public CompositeData toCompositeData() {
        return this.toCompositeData(ServiceStateMBean.SERVICE_TYPE.keySet());
    }

    public CompositeData toCompositeData(Collection<String> itemNames) {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("Identifier", this.serviceId);
        if (itemNames.contains("BundleIdentifier")) {
            items.put("BundleIdentifier", this.bundleId);
        }
        if (itemNames.contains("objectClass")) {
            items.put("objectClass", this.serviceInterfaces);
        }
        TabularDataSupport propertiesTable = new TabularDataSupport(JmxConstants.PROPERTIES_TYPE);
        for (PropertyData<? extends Object> propertyData : this.properties) {
            propertiesTable.put(propertyData.toCompositeData());
        }
        items.put("Properties", propertiesTable);
        if (itemNames.contains("UsingBundles")) {
            items.put("UsingBundles", TypeUtils.toLong(this.usingBundles));
        }
        String[] allItemNames = ServiceStateMBean.SERVICE_TYPE.keySet().toArray(new String[0]);
        Object[] itemValues = new Object[allItemNames.length];
        for (int i = 0; i < allItemNames.length; ++i) {
            itemValues[i] = items.get(allItemNames[i]);
        }
        try {
            return new CompositeDataSupport(ServiceStateMBean.SERVICE_TYPE, allItemNames, itemValues);
        }
        catch (OpenDataException e) {
            throw new IllegalStateException("Failed to create CompositeData for ServiceReference with service.id [" + this.serviceId + "]", e);
        }
    }

    public static ServiceData from(CompositeData compositeData) {
        if (compositeData == null) {
            throw new IllegalArgumentException("Argument compositeData cannot be null");
        }
        if (!compositeData.getCompositeType().equals(ServiceStateMBean.SERVICE_TYPE)) {
            throw new IllegalArgumentException("Invalid CompositeType [" + compositeData.getCompositeType() + "]");
        }
        ServiceData serviceData = new ServiceData();
        serviceData.serviceId = (Long)compositeData.get("Identifier");
        serviceData.bundleId = (Long)compositeData.get("BundleIdentifier");
        serviceData.serviceInterfaces = (String[])compositeData.get("objectClass");
        serviceData.usingBundles = TypeUtils.toPrimitive((Long[])compositeData.get("UsingBundles"));
        TabularData propertiesTable = (TabularData)compositeData.get("Properties");
        Collection<?> propertyData = propertiesTable.values();
        for (CompositeData propertyRow : propertyData) {
            serviceData.properties.add(PropertyData.from(propertyRow));
        }
        return serviceData;
    }

    public long getServiceId() {
        return this.serviceId;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public String[] getServiceInterfaces() {
        return this.serviceInterfaces;
    }

    public List<PropertyData<? extends Object>> getProperties() {
        return this.properties;
    }

    public long[] getUsingBundles() {
        return this.usingBundles;
    }
}

