/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal.convert;

import java.math.BigDecimal;
import javax.money.convert.ConversionQuery;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ProviderContext;
import javax.money.convert.ProviderContextBuilder;
import javax.money.convert.RateType;
import org.javamoney.moneta.convert.ExchangeRateBuilder;
import org.javamoney.moneta.spi.AbstractRateProvider;
import org.javamoney.moneta.spi.DefaultNumberValue;

public class IdentityRateProvider
extends AbstractRateProvider {
    private static final ProviderContext CONTEXT = ((ProviderContextBuilder)ProviderContextBuilder.of((String)"IDENT", (RateType)RateType.OTHER, (RateType[])new RateType[0]).set("providerDescription", (Object)"Identitiy Provider")).build();

    public IdentityRateProvider() {
        super(CONTEXT);
    }

    public boolean isAvailable(ConversionQuery conversionQuery) {
        return conversionQuery.getBaseCurrency().getCurrencyCode().equals(conversionQuery.getCurrency().getCurrencyCode());
    }

    @Override
    public ExchangeRate getExchangeRate(ConversionQuery conversionQuery) {
        if (conversionQuery.getBaseCurrency().getCurrencyCode().equals(conversionQuery.getCurrency().getCurrencyCode())) {
            ExchangeRateBuilder builder = new ExchangeRateBuilder(this.getContext().getProviderName(), RateType.OTHER).setBase(conversionQuery.getBaseCurrency());
            builder.setTerm(conversionQuery.getCurrency());
            builder.setFactor(DefaultNumberValue.of(BigDecimal.ONE));
            return builder.build();
        }
        return null;
    }

    public ExchangeRate getReversed(ExchangeRate rate) {
        if (rate.getContext().getProviderName().equals(CONTEXT.getProviderName())) {
            return new ExchangeRateBuilder(rate.getContext()).setTerm(rate.getBaseCurrency()).setBase(rate.getCurrency()).setFactor(new DefaultNumberValue(BigDecimal.ONE)).build();
        }
        return null;
    }
}

