/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.service.result;

import aQute.bnd.service.result.ConsumerWithException;
import aQute.bnd.service.result.Err;
import aQute.bnd.service.result.FunctionWithException;
import aQute.bnd.service.result.Ok;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Result<V, E> {
    public static <V, E> Result<V, E> of(V value, E error) {
        return value != null ? Result.ok(value) : Result.err(error);
    }

    public static <V, E> Result<V, E> ok(V value) {
        return new Ok(value);
    }

    public static <V, E> Result<V, E> err(E error) {
        return new Err(error);
    }

    public static <V> Result<V, String> err(String format, Object ... args) {
        try {
            return new Err(String.format(format, args));
        }
        catch (Exception e) {
            return new Err(format + " " + Arrays.toString(args));
        }
    }

    public boolean isOk();

    public boolean isErr();

    public Optional<V> value();

    public Optional<E> error();

    public V unwrap();

    public V unwrap(String var1);

    public V orElse(V var1);

    public V orElseGet(Supplier<? extends V> var1);

    public <R extends Throwable> V orElseThrow(FunctionWithException<? super E, ? extends R> var1) throws R;

    public <U> Result<U, E> map(FunctionWithException<? super V, ? extends U> var1);

    public <F> Result<V, F> mapErr(FunctionWithException<? super E, ? extends F> var1);

    public <U> Result<U, E> flatMap(FunctionWithException<? super V, ? extends Result<? extends U, ? extends E>> var1);

    public Result<V, E> recover(FunctionWithException<? super E, ? extends V> var1);

    public void accept(ConsumerWithException<? super V> var1, ConsumerWithException<? super E> var2);

    public <X> Result<X, E> asError();

    public <X extends Throwable> V unwrap(Function<E, X> var1) throws X;
}

