// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

type Slice struct {
	orig  *[]otlpcommon.AnyValue
	state *State
}

func GetOrigSlice(ms Slice) *[]otlpcommon.AnyValue {
	return ms.orig
}

func GetSliceState(ms Slice) *State {
	return ms.state
}

func NewSlice(orig *[]otlpcommon.AnyValue, state *State) Slice {
	return Slice{orig: orig, state: state}
}

func GenerateTestSlice() Slice {
	orig := GenerateOrigTestAnyValueSlice()
	state := StateMutable
	return NewSlice(&orig, &state)
}

func CopyOrigAnyValueSlice(dest, src []otlpcommon.AnyValue) []otlpcommon.AnyValue {
	var newDest []otlpcommon.AnyValue
	if cap(dest) < len(src) {
		newDest = make([]otlpcommon.AnyValue, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			dest[i] = otlpcommon.AnyValue{}
		}
	}
	for i := range src {
		CopyOrigAnyValue(&newDest[i], &src[i])
	}
	return newDest
}

func GenerateOrigTestAnyValueSlice() []otlpcommon.AnyValue {
	orig := make([]otlpcommon.AnyValue, 7)
	for i := 0; i < 7; i++ {
		orig[i] = otlpcommon.AnyValue{}
		FillOrigTestAnyValue(&orig[i])
	}
	return orig
}

// UnmarshalJSONOrigAnyValueSlice unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigAnyValueSlice(iter *json.Iterator) []otlpcommon.AnyValue {
	var orig []otlpcommon.AnyValue
	iter.ReadArrayCB(func(iter *json.Iterator) bool {
		orig = append(orig, otlpcommon.AnyValue{})
		UnmarshalJSONOrigAnyValue(&orig[len(orig)-1], iter)
		return true
	})
	return orig
}
