// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func CopyOrigAttributeUnit(dest, src *otlpprofiles.AttributeUnit) {
	dest.AttributeKeyStrindex = src.AttributeKeyStrindex
	dest.UnitStrindex = src.UnitStrindex
}

func FillOrigTestAttributeUnit(orig *otlpprofiles.AttributeUnit) {
	orig.AttributeKeyStrindex = int32(13)
	orig.UnitStrindex = int32(13)
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigAttributeUnit(orig *otlpprofiles.AttributeUnit, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.AttributeKeyStrindex != int32(0) {
		dest.WriteObjectField("attributeKeyStrindex")
		dest.WriteInt32(orig.AttributeKeyStrindex)
	}
	if orig.UnitStrindex != int32(0) {
		dest.WriteObjectField("unitStrindex")
		dest.WriteInt32(orig.UnitStrindex)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigAttributeUnit unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigAttributeUnit(orig *otlpprofiles.AttributeUnit, iter *json.Iterator) {
	iter.ReadObjectCB(func(iter *json.Iterator, f string) bool {
		switch f {
		case "attributeKeyStrindex", "attribute_key_strindex":
			orig.AttributeKeyStrindex = iter.ReadInt32()
		case "unitStrindex", "unit_strindex":
			orig.UnitStrindex = iter.ReadInt32()
		default:
			iter.Skip()
		}
		return true
	})
}

func SizeProtoOrigAttributeUnit(orig *otlpprofiles.AttributeUnit) int {
	var n int
	var l int
	_ = l
	if orig.AttributeKeyStrindex != 0 {
		n += 1 + proto.Sov(uint64(orig.AttributeKeyStrindex))
	}
	if orig.UnitStrindex != 0 {
		n += 1 + proto.Sov(uint64(orig.UnitStrindex))
	}
	return n
}

func MarshalProtoOrigAttributeUnit(orig *otlpprofiles.AttributeUnit, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.AttributeKeyStrindex != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.AttributeKeyStrindex))
		pos--
		buf[pos] = 0x8
	}
	if orig.UnitStrindex != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.UnitStrindex))
		pos--
		buf[pos] = 0x10
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigAttributeUnit(orig *otlpprofiles.AttributeUnit, buf []byte) error {
	return orig.Unmarshal(buf)
}
