// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExemplar(t *testing.T) {
	src := &otlpmetrics.Exemplar{}
	dest := &otlpmetrics.Exemplar{}
	CopyOrigExemplar(dest, src)
	assert.Equal(t, &otlpmetrics.Exemplar{}, dest)
	FillOrigTestExemplar(src)
	CopyOrigExemplar(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigExemplarUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpmetrics.Exemplar{}
	UnmarshalJSONOrigExemplar(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpmetrics.Exemplar{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigExemplar(t *testing.T) {
	for name, src := range getEncodingTestValuesExemplar() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigExemplar(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpmetrics.Exemplar{}
			UnmarshalJSONOrigExemplar(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExemplar(t *testing.T) {
	for name, src := range getEncodingTestValuesExemplar() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExemplar(src))
			gotSize := MarshalProtoOrigExemplar(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpmetrics.Exemplar{}
			require.NoError(t, UnmarshalProtoOrigExemplar(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesExemplar() map[string]*otlpmetrics.Exemplar {
	return map[string]*otlpmetrics.Exemplar{
		"empty": {},
		"fill_test": func() *otlpmetrics.Exemplar {
			src := &otlpmetrics.Exemplar{}
			FillOrigTestExemplar(src)
			return src
		}(),
		"oneof_double": {Value: &otlpmetrics.Exemplar_AsDouble{AsDouble: float64(0)}},
		"oneof_int":    {Value: &otlpmetrics.Exemplar_AsInt{AsInt: int64(0)}},
	}
}
