// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExponentialHistogramDataPoint(t *testing.T) {
	src := &otlpmetrics.ExponentialHistogramDataPoint{}
	dest := &otlpmetrics.ExponentialHistogramDataPoint{}
	CopyOrigExponentialHistogramDataPoint(dest, src)
	assert.Equal(t, &otlpmetrics.ExponentialHistogramDataPoint{}, dest)
	FillOrigTestExponentialHistogramDataPoint(src)
	CopyOrigExponentialHistogramDataPoint(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigExponentialHistogramDataPointUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpmetrics.ExponentialHistogramDataPoint{}
	UnmarshalJSONOrigExponentialHistogramDataPoint(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpmetrics.ExponentialHistogramDataPoint{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigExponentialHistogramDataPoint(t *testing.T) {
	for name, src := range getEncodingTestValuesExponentialHistogramDataPoint() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigExponentialHistogramDataPoint(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpmetrics.ExponentialHistogramDataPoint{}
			UnmarshalJSONOrigExponentialHistogramDataPoint(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExponentialHistogramDataPoint(t *testing.T) {
	for name, src := range getEncodingTestValuesExponentialHistogramDataPoint() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExponentialHistogramDataPoint(src))
			gotSize := MarshalProtoOrigExponentialHistogramDataPoint(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpmetrics.ExponentialHistogramDataPoint{}
			require.NoError(t, UnmarshalProtoOrigExponentialHistogramDataPoint(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesExponentialHistogramDataPoint() map[string]*otlpmetrics.ExponentialHistogramDataPoint {
	return map[string]*otlpmetrics.ExponentialHistogramDataPoint{
		"empty": {},
		"fill_test": func() *otlpmetrics.ExponentialHistogramDataPoint {
			src := &otlpmetrics.ExponentialHistogramDataPoint{}
			FillOrigTestExponentialHistogramDataPoint(src)
			return src
		}(),
		"default_sum": {Sum_: &otlpmetrics.ExponentialHistogramDataPoint_Sum{Sum: float64(0)}},
		"default_min": {Min_: &otlpmetrics.ExponentialHistogramDataPoint_Min{Min: float64(0)}},
		"default_max": {Max_: &otlpmetrics.ExponentialHistogramDataPoint_Max{Max: float64(0)}},
	}
}
