// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigScopeProfiles(t *testing.T) {
	src := &otlpprofiles.ScopeProfiles{}
	dest := &otlpprofiles.ScopeProfiles{}
	CopyOrigScopeProfiles(dest, src)
	assert.Equal(t, &otlpprofiles.ScopeProfiles{}, dest)
	FillOrigTestScopeProfiles(src)
	CopyOrigScopeProfiles(dest, src)
	assert.Equal(t, src, dest)
}

func TestMarshalAndUnmarshalJSONOrigScopeProfilesUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := &otlpprofiles.ScopeProfiles{}
	UnmarshalJSONOrigScopeProfiles(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, &otlpprofiles.ScopeProfiles{}, dest)
}

func TestMarshalAndUnmarshalJSONOrigScopeProfiles(t *testing.T) {
	for name, src := range getEncodingTestValuesScopeProfiles() {
		t.Run(name, func(t *testing.T) {
			stream := json.BorrowStream(nil)
			defer json.ReturnStream(stream)
			MarshalJSONOrigScopeProfiles(src, stream)
			require.NoError(t, stream.Error())

			iter := json.BorrowIterator(stream.Buffer())
			defer json.ReturnIterator(iter)
			dest := &otlpprofiles.ScopeProfiles{}
			UnmarshalJSONOrigScopeProfiles(dest, iter)
			require.NoError(t, iter.Error())

			assert.Equal(t, src, dest)
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigScopeProfiles(t *testing.T) {
	for name, src := range getEncodingTestValuesScopeProfiles() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigScopeProfiles(src))
			gotSize := MarshalProtoOrigScopeProfiles(src, buf)
			assert.Equal(t, len(buf), gotSize)

			dest := &otlpprofiles.ScopeProfiles{}
			require.NoError(t, UnmarshalProtoOrigScopeProfiles(dest, buf))
			assert.Equal(t, src, dest)
		})
	}
}

func getEncodingTestValuesScopeProfiles() map[string]*otlpprofiles.ScopeProfiles {
	return map[string]*otlpprofiles.ScopeProfiles{
		"empty": {},
		"fill_test": func() *otlpprofiles.ScopeProfiles {
			src := &otlpprofiles.ScopeProfiles{}
			FillOrigTestScopeProfiles(src)
			return src
		}(),
	}
}
