// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"go.opentelemetry.io/collector/pdata/internal/json"
)

type UInt64Slice struct {
	orig  *[]uint64
	state *State
}

func GetOrigUInt64Slice(ms UInt64Slice) *[]uint64 {
	return ms.orig
}

func GetUInt64SliceState(ms UInt64Slice) *State {
	return ms.state
}

func NewUInt64Slice(orig *[]uint64, state *State) UInt64Slice {
	return UInt64Slice{orig: orig, state: state}
}

func GenerateTestUInt64Slice() UInt64Slice {
	orig := GenerateOrigTestUint64Slice()
	state := StateMutable
	return NewUInt64Slice(&orig, &state)
}

func CopyOrigUint64Slice(dst, src []uint64) []uint64 {
	return append(dst[:0], src...)
}

func GenerateOrigTestUint64Slice() []uint64 {
	return []uint64{1, 2, 3}
}

// UnmarshalJSONOrigUint64Slice unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigUint64Slice(iter *json.Iterator) []uint64 {
	var orig []uint64
	iter.ReadArrayCB(func(iter *json.Iterator) bool {
		orig = append(orig, iter.ReadUint64())
		return true
	})
	return orig
}
