// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	v1 "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestAttribute_MoveTo(t *testing.T) {
	ms := generateTestAttribute()
	dest := NewAttribute()
	ms.MoveTo(dest)
	assert.Equal(t, NewAttribute(), ms)
	assert.Equal(t, generateTestAttribute(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestAttribute(), dest)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.MoveTo(newAttribute(&v1.KeyValue{}, &sharedState)) })
	assert.Panics(t, func() { newAttribute(&v1.KeyValue{}, &sharedState).MoveTo(dest) })
}

func TestAttribute_CopyTo(t *testing.T) {
	ms := NewAttribute()
	orig := NewAttribute()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestAttribute()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { ms.CopyTo(newAttribute(&v1.KeyValue{}, &sharedState)) })
}

func TestAttribute_Key(t *testing.T) {
	ms := NewAttribute()
	assert.Empty(t, ms.Key())
	ms.SetKey("test_key")
	assert.Equal(t, "test_key", ms.Key())
	sharedState := internal.StateReadOnly
	assert.Panics(t, func() { newAttribute(&v1.KeyValue{}, &sharedState).SetKey("test_key") })
}

func TestAttribute_Value(t *testing.T) {
	ms := NewAttribute()
	assert.Equal(t, pcommon.NewValueEmpty(), ms.Value())
	internal.FillOrigTestAnyValue(&ms.orig.Value)
	assert.Equal(t, pcommon.Value(internal.GenerateTestValue()), ms.Value())
}

func generateTestAttribute() Attribute {
	ms := NewAttribute()
	internal.FillOrigTestKeyValue(ms.orig)
	return ms
}
