// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcollectormetrics "go.opentelemetry.io/proto/slim/otlp/collector/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpcollectormetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/metrics/v1"
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExportMetricsServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportMetricsServiceRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigExportMetricsServiceRequest()
				CopyOrigExportMetricsServiceRequest(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigExportMetricsServiceRequest(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigExportMetricsServiceRequestUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigExportMetricsServiceRequest()
	UnmarshalJSONOrigExportMetricsServiceRequest(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigExportMetricsServiceRequest(), dest)
}

func TestMarshalAndUnmarshalJSONOrigExportMetricsServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportMetricsServiceRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigExportMetricsServiceRequest(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigExportMetricsServiceRequest()
				UnmarshalJSONOrigExportMetricsServiceRequest(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigExportMetricsServiceRequest(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigExportMetricsServiceRequestFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExportMetricsServiceRequest() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigExportMetricsServiceRequest()
			require.Error(t, UnmarshalProtoOrigExportMetricsServiceRequest(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExportMetricsServiceRequestUnknown(t *testing.T) {
	dest := NewOrigExportMetricsServiceRequest()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigExportMetricsServiceRequest(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigExportMetricsServiceRequest(), dest)
}

func TestMarshalAndUnmarshalProtoOrigExportMetricsServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportMetricsServiceRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigExportMetricsServiceRequest(src))
				gotSize := MarshalProtoOrigExportMetricsServiceRequest(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigExportMetricsServiceRequest()
				require.NoError(t, UnmarshalProtoOrigExportMetricsServiceRequest(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigExportMetricsServiceRequest(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExportMetricsServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportMetricsServiceRequest() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExportMetricsServiceRequest(src))
			gotSize := MarshalProtoOrigExportMetricsServiceRequest(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcollectormetrics.ExportMetricsServiceRequest{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigExportMetricsServiceRequest()
			require.NoError(t, UnmarshalProtoOrigExportMetricsServiceRequest(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExportMetricsServiceRequest() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                   {0x02},
		"ResourceMetrics/wrong_wire_type": {0xc},
		"ResourceMetrics/missing_value":   {0xa},
	}
}

func genTestEncodingValuesExportMetricsServiceRequest() map[string]*otlpcollectormetrics.ExportMetricsServiceRequest {
	return map[string]*otlpcollectormetrics.ExportMetricsServiceRequest{
		"empty":                            NewOrigExportMetricsServiceRequest(),
		"ResourceMetrics/default_and_test": {ResourceMetrics: []*otlpmetrics.ResourceMetrics{{}, GenTestOrigResourceMetrics()}},
	}
}
