// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package plog

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	otlplogs "go.opentelemetry.io/collector/pdata/internal/data/protogen/logs/v1"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestResourceLogs_MoveTo(t *testing.T) {
	ms := generateTestResourceLogs()
	dest := NewResourceLogs()
	ms.MoveTo(dest)
	assert.Equal(t, NewResourceLogs(), ms)
	assert.Equal(t, generateTestResourceLogs(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestResourceLogs(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newResourceLogs(internal.NewOrigResourceLogs(), sharedState)) })
	assert.Panics(t, func() { newResourceLogs(internal.NewOrigResourceLogs(), sharedState).MoveTo(dest) })
}

func TestResourceLogs_CopyTo(t *testing.T) {
	ms := NewResourceLogs()
	orig := NewResourceLogs()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestResourceLogs()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newResourceLogs(internal.NewOrigResourceLogs(), sharedState)) })
}

func TestResourceLogs_Resource(t *testing.T) {
	ms := NewResourceLogs()
	assert.Equal(t, pcommon.NewResource(), ms.Resource())
	ms.orig.Resource = *internal.GenTestOrigResource()
	assert.Equal(t, pcommon.Resource(internal.NewResource(internal.GenTestOrigResource(), ms.state)), ms.Resource())
}

func TestResourceLogs_ScopeLogs(t *testing.T) {
	ms := NewResourceLogs()
	assert.Equal(t, NewScopeLogsSlice(), ms.ScopeLogs())
	ms.orig.ScopeLogs = internal.GenerateOrigTestScopeLogsSlice()
	assert.Equal(t, generateTestScopeLogsSlice(), ms.ScopeLogs())
}

func TestResourceLogs_SchemaUrl(t *testing.T) {
	ms := NewResourceLogs()
	assert.Empty(t, ms.SchemaUrl())
	ms.SetSchemaUrl("test_schemaurl")
	assert.Equal(t, "test_schemaurl", ms.SchemaUrl())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newResourceLogs(&otlplogs.ResourceLogs{}, sharedState).SetSchemaUrl("test_schemaurl") })
}

func generateTestResourceLogs() ResourceLogs {
	ms := newResourceLogs(internal.GenTestOrigResourceLogs(), internal.NewState())
	return ms
}
