// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpprofiles "go.opentelemetry.io/proto/slim/otlp/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigKeyValueAndUnit(t *testing.T) {
	for name, src := range genTestEncodingValuesKeyValueAndUnit() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigKeyValueAndUnit()
				CopyOrigKeyValueAndUnit(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigKeyValueAndUnit(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigKeyValueAndUnitUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigKeyValueAndUnit()
	UnmarshalJSONOrigKeyValueAndUnit(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigKeyValueAndUnit(), dest)
}

func TestMarshalAndUnmarshalJSONOrigKeyValueAndUnit(t *testing.T) {
	for name, src := range genTestEncodingValuesKeyValueAndUnit() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigKeyValueAndUnit(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigKeyValueAndUnit()
				UnmarshalJSONOrigKeyValueAndUnit(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigKeyValueAndUnit(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigKeyValueAndUnitFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesKeyValueAndUnit() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigKeyValueAndUnit()
			require.Error(t, UnmarshalProtoOrigKeyValueAndUnit(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigKeyValueAndUnitUnknown(t *testing.T) {
	dest := NewOrigKeyValueAndUnit()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigKeyValueAndUnit(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigKeyValueAndUnit(), dest)
}

func TestMarshalAndUnmarshalProtoOrigKeyValueAndUnit(t *testing.T) {
	for name, src := range genTestEncodingValuesKeyValueAndUnit() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigKeyValueAndUnit(src))
				gotSize := MarshalProtoOrigKeyValueAndUnit(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigKeyValueAndUnit()
				require.NoError(t, UnmarshalProtoOrigKeyValueAndUnit(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigKeyValueAndUnit(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufKeyValueAndUnit(t *testing.T) {
	for name, src := range genTestEncodingValuesKeyValueAndUnit() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigKeyValueAndUnit(src))
			gotSize := MarshalProtoOrigKeyValueAndUnit(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpprofiles.KeyValueAndUnit{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigKeyValueAndUnit()
			require.NoError(t, UnmarshalProtoOrigKeyValueAndUnit(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesKeyValueAndUnit() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                {0x02},
		"KeyStrindex/wrong_wire_type":  {0xc},
		"KeyStrindex/missing_value":    {0x8},
		"Value/wrong_wire_type":        {0x14},
		"Value/missing_value":          {0x12},
		"UnitStrindex/wrong_wire_type": {0x1c},
		"UnitStrindex/missing_value":   {0x18},
	}
}

func genTestEncodingValuesKeyValueAndUnit() map[string]*otlpprofiles.KeyValueAndUnit {
	return map[string]*otlpprofiles.KeyValueAndUnit{
		"empty":             NewOrigKeyValueAndUnit(),
		"KeyStrindex/test":  {KeyStrindex: int32(13)},
		"Value/test":        {Value: *GenTestOrigAnyValue()},
		"UnitStrindex/test": {UnitStrindex: int32(13)},
	}
}
