// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
)

func TestCopyOrigKeyValueAndUnitSlice(t *testing.T) {
	src := []*otlpprofiles.KeyValueAndUnit{}
	dest := []*otlpprofiles.KeyValueAndUnit{}
	// Test CopyTo empty
	dest = CopyOrigKeyValueAndUnitSlice(dest, src)
	assert.Equal(t, []*otlpprofiles.KeyValueAndUnit{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestKeyValueAndUnitSlice()
	dest = CopyOrigKeyValueAndUnitSlice(dest, src)
	assert.Equal(t, GenerateOrigTestKeyValueAndUnitSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigKeyValueAndUnitSlice(dest, src)
	assert.Equal(t, GenerateOrigTestKeyValueAndUnitSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigKeyValueAndUnitSlice(dest, []*otlpprofiles.KeyValueAndUnit{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigKeyValueAndUnitSlice(dest, src)
	assert.Equal(t, GenerateOrigTestKeyValueAndUnitSlice(), dest)
}
